# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import DES, CMD
from common.cmd_execute_offline import BaseCmdExecuteOffline
from common.contentParse import get_cmd_ret

CMD_LIST = [
    {DES: "cmd_info_multipath_info_lun_list", CMD: "esxcli storage core device list"},
    {DES: "cmd_info_multipath_info_plugin_list", CMD: "esxcli storage core device vaai status get"},
    {DES: "cmd_info_multipath_info_datastore_list", CMD: "esxcli storage vmfs extent list"},
    {DES: "cmd_info_multipath_info_array_path_list", CMD: "esxcli storage nmp device list"},
    {DES: "cmd_info_multipath_info_filesystem", CMD: "esxcli storage filesystem list"},
    {DES: "cmd_info_multipath_info_ultra_version", CMD: "esxcli upadm show version"},
]

RESERVATION_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_readresv_", CMD: "vmkfstools -L readresv %s", },
]


def execute(context):
    VmwareMulti(context).execute()


class VmwareMulti(BaseCmdExecuteOffline):
    def __init__(self, context):
        BaseCmdExecuteOffline.__init__(self, context)

    def execute(self):
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(self.get_reservation_path_list(), RESERVATION_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_reservation_path_list(self):
        """
        获取预留数据的盘路径
        :return: 数据
        """
        self.context["command"] = "esxcli storage core device list"
        data_info = get_cmd_ret(self.context)
        result = []
        for line in data_info.splitlines():
            if line.strip().startswith("Devfs Path:"):
                result.append((line.split(":")[1].strip(),))
        return result
