# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import get_cmd_ret

cmd_info_id = [
    "cmd_info_vm_vmhost",
    "cmd_info_vm_vmhost_state_",
    "cmd_info_vm_detail_",
]

cmd_info_desc = [
    "vim-cmd vmsvc/getallvms",
    "vim-cmd vmsvc/get.summary ",
    "vim-cmd vmsvc/device.getdevices ",
]


def execute(context):
    cmd_display = context.get("ret_map")
    cmd_display_temp = ''
    for rg in range(len(cmd_info_id)):
        if cmd_info_id[rg] == "cmd_info_vm_detail_" \
                or cmd_info_id[rg] == "cmd_info_vm_vmhost_state_":
            set_vm_detail(cmd_display, context, cmd_info_id[rg],
                          cmd_info_desc[rg])
            continue
        context["command"] = cmd_info_desc[rg]
        cmd_display_temp = get_cmd_ret(context)
        cmd_display.put("cmd_display" + (cmd_info_id[rg])[8:],
                        cmd_display_temp)
    return cmd_display


def set_vm_detail(cmd_display, context, id_preffix, cmd):
    """
    组装vmware的虚拟机详情
    :param id_preffix: 描述前缀
    :param cmd_display: 回文字典
    :param context: 上下文
    """
    context["command"] = r"vim-cmd vmsvc/getallvms|sed 's/ \+/=/g' |awk -F= " \
                         r"'{ print $1}' | grep -E '^[0-9]+$'"
    vm_ids = get_cmd_ret(context).splitlines()[1:]
    for vm_id in vm_ids:
        if vm_id and "not found" not in vm_id:
            context["command"] = cmd + vm_id.strip()
            cmd_display.put("cmd_display" + id_preffix[8:] + vm_id,
                            get_cmd_ret(context))
