# -*- coding: UTF-8 -*-
import re
import sys
import traceback
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import singleCmdExecute, saveAluaStatusAndCliRet2ForeEval
from common import util
from common import constants

cliRets = []
LINE_BREAK = "\n"
NUM_INT_3 = 3
queryAluaStatusFailedDisks = []
ALUA_ENABLED = 'enabled'
ALUA_NOT_ENABLED = 'not enabled'
ALUA_UNKNOW = 'unknown'

def execute(context):
    '''
    @param context: execute context 
    '''
    global LOGGER
    LOGGER = context.get("Logger")
    try:
        executeStatus, disks = queryHuaweiDisk(context)
        util.updateItemProgress(context, constants.PROG10)
        if not executeStatus:
            util.updateItemProgress(context, constants.PROG95)
            return saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, LINE_BREAK.join(cliRets), context)
        if not disks:
            util.updateItemProgress(context, constants.PROG95)
            return saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, LINE_BREAK.join(cliRets), context)
        executeStatus, executeResult = getAluaStatus(disks, context)
        if not executeStatus:
            util.updateItemProgress(context, constants.PROG95)
            return saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, LINE_BREAK.join(cliRets), context)
        util.updateItemProgress(context, constants.PROG95)
        if executeResult:
            return saveAluaStatusAndCliRet2ForeEval(ALUA_ENABLED, LINE_BREAK.join(cliRets), context)   
        else:
            return saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, LINE_BREAK.join(cliRets), context)   
    except:
        msg = traceback.format_exc()
        LOGGER.error("execute alua configure info ==> " + msg)
        saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, LINE_BREAK.join(cliRets), context)   

def queryHuaweiDisk(context):
    '''
    @summary: query the available huawei disks
    @return: (execute status: True or False, disk list)
    '''
    try:
        disks = []
        command = 'esxcli storage nmp device list | grep -i naa'
        executeStatus, cliRet = singleCmdExecute(context, command, 'query_huawei_disk', True)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.info("***[execute queryHuaweiDisk failure]***")
            return False, disks 
        diskPattern = re.compile(".*huawei.*\((naa.[\d|a-f]{32})\).*", flags=re.IGNORECASE)
        for line in cliRet.splitlines():
            match = diskPattern.search(line)
            if not match:
                continue
            disks.append(match.group(1))
        LOGGER.info("execute queryHuaweiDisk, disks is : %s" % disks)
        return True, disks
    except:
        msg = traceback.format_exc() 
        LOGGER.error("queryHuaweiDisk ==> " + msg)
        return False, []

def getAluaStatus(disks, context):
    '''
    @summary: get the final status of all disks
    '''
    stepProgress = int(constants.PROG80 / len(disks))
    currentProgress = constants.PROG10
    for disk in disks:
        currentProgress += stepProgress
        executeStatus, executeResult = queryAndCheckDiskAlua(disk, context)
        util.updateItemProgress(context, currentProgress)
        if not executeStatus:
            return False, False
        if executeResult:
            return True, True
    return True, False
    
def queryAndCheckDiskAlua(disk, context):
    '''
    @summary: query the alua configure information of disk and check the information
    @return: (execute status: True or False, check result: True or False)
    '''
    try:
        command = 'esxcli storage nmp device list -d=%s' % disk
        executeStatus, cliRet = singleCmdExecute(context, command, 'query_alua_disk_%s' % disk, True)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.info("***[query the disk : %s alua info failure]***" % disk)
            return False, False
        hasKeyWord, checkResult = getDiskAlua(cliRet)
        if not hasKeyWord:
            LOGGER.info("***[query and check disk alua, hasAccessState: %s ]***" % hasKeyWord)
            return False, checkResult     
        return True, checkResult
    except:
        msg = traceback.format_exc() 
        LOGGER.error("queryAndCheckDiskAlua ==> " + msg)
        return False, False

def getDiskAlua(cliRet):
    '''
    @summary: get the alua status of disk
    '''
    hasStorageArrayType = False
    vmwSatpAlua = False
    for line in cliRet.splitlines():
        stripLine = line.strip().lower()
        splitLines = stripLine.split(':')
        if 'storage array type:' in stripLine:
            hasStorageArrayType = True
            if splitLines[-1].strip() == 'vmw_satp_alua':
                vmwSatpAlua = True    
    return hasStorageArrayType, vmwSatpAlua
