# coding=utf-8
__author__ = '******'
# 获取vmvare主机的多路径信息
import os
import re
import sys
import traceback
from com.huawei.ism.tool.infograb.context import EvalResultEnum

path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, "..\\..")
sys.path.append(path)
import vmware_hba_card_info_for_direct_connection
from common import util
from common import constants
from common import contentParse
logger = None

QLOGIC_FLAG = "ql"
EMULEX_FLAG = "lpfc"

cmd_parminfo_id = [
                 "cmd_info_hba_card_esxcli",
                 "cmd_info_hba_card_statsget",
                 "cmd_info_hba_card_55_all",
                 "cmd_info_hba_card_50_all",
                 "cmd_info_hba_wwpns",
                 "cmd_info_hba_iscsi"
                 ]
cmd_parminfo_desc = [
                   "esxcli storage core adapter list",
                   "localcli storage san fc stats get",
                   "/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -a | grep -i 'Key Value Instance'",
                   "ls -1 /proc/scsi/*/*",
                   "esxcli storage core adapter list |grep -i 'Fibre Channel'",
                   "esxcfg-scsidevs -a"
                   ]

#*****************************************************************************************************************    
#说明：
#HBA Name  Driver        Link State  UID             Description                                                   
#--------  ------------  ----------  --------------  --------------------------------------------------------------
#vmhba0    ata_piix      link-n/a    sata.vmhba0     (0:0:31.2) Intel Corporation ICH10 4 port SATA IDE Controller 
#vmhba1    ata_piix      link-n/a    sata.vmhba1     (0:0:31.5) Intel Corporation ICH10 2 port SATA IDE Controller 
#vmhba2    megaraid_sas  link-n/a    unknown.vmhba2  (0:3:0.0) LSI / Symbios Logic LSI MegaRAID SAS 1078 Controller
#vmhba32   ata_piix      link-n/a    sata.vmhba32    (0:0:31.2) Intel Corporation ICH10 4 port SATA IDE Controller 
#vmhba33   ata_piix      link-n/a    sata.vmhba33    (0:0:31.5) Intel Corporation ICH10 2 port SATA IDE Controller 
#vmhba34   iscsi_vmk     online      iscsi.vmhba34   iSCSI Software Adapter    
#从类似上面的回文中获得ata_piix,megraid_sas...驱动名的列表  ,用于esxcfg-module -i Driver_Name获取驱动的详细信息
#*****************************************************************************************************************
def execute(context):
    cliRet = ""
    vmware_hba_card_info_for_direct_connection.execute(context)
    r_map = contentParse.getCommandRet(context, cmd_info_id = ["cmd_info_hba_card_esxcli"], cmd_info_desc = ["esxcli storage core adapter list"])
    temp = r_map.get("cmd_display_hba_card_esxcli")
    cliRet += temp + "\n"
    rList = temp.split('\n')
    rList = rList[3:]
    parms = ""
    util.updateItemProgress(context, constants.PROG5)
    result = []
    for i in range(len(rList)):
        if "online" in rList[i]:
            if "iscsi" in rList[i]:
                lineStr = rList[i].strip()
                lineList = re.split('\s+', lineStr)
                result.append(lineList[0])


#    循环
    for j in range(len(rList) - 1):
        s2 = rList[j]

        firstSpaceIndex = 0
        twoIndex = 0
        for i in range(len(s2)):
            if s2[i] == ' ':
                firstSpaceIndex = i
                break
        temp = s2[firstSpaceIndex:]
        temp = temp.lstrip()
        for i in range(len(temp)):
            if temp[i] == ' ':
                twoIndex = i
                break
        parms = parms + temp[0:twoIndex] + ','
    parms = parms[0:len(parms) - 1]

    CLI = context.get("SSH")
    vmhb_lines = CLI.execCmdWithTimout("esxcli storage core adapter list | grep vmhb | awk \'{print $1}\'", 60).splitlines()
    if len(vmhb_lines) > 1:
        for vmhb in vmhb_lines[1:]:
            if 'vmhb' in vmhb:
                cmd_parminfo_id.append("cmd_info_hba_card_iscsi_targetinfo_" + vmhb)
                cmd_parminfo_desc.append("vmkiscsi-tool -l -T " + " " + vmhb)
    
    #参数列表:ata_piix ...
    parmtempList = parms.split(',')
    parmList = list(set(parmtempList))

    #不同版本查询hba卡型号、驱动版本、fw版本(固件版本)，其中：Vmware 5.5 / 6.0 / 6.5的命令都是一样的
    hbamodel_lsts = []
    try:
        if float(contentParse.get_vmversion(context)) >= 5.5:
            #新方法：采集hba卡型号、驱动版本、fw版本(固件版本)。根据e卡或q卡发送不同的命令，此方法vmware 5.5已验证，5.5以上待验证
            hbamodel_lsts = get_all_hbalst(context, 5.6)
            for id in get_QEv55card_cmd_iddesc(hbamodel_lsts)[0]:
                cmd_parminfo_id.append(id)
            for desc in get_QEv55card_cmd_iddesc(hbamodel_lsts)[1]:
                cmd_parminfo_desc.append(desc)
        elif float(contentParse.get_vmversion(context)) == 5.0:
            hbamodel_lsts = get_all_hbalst(context, 5.0)
            for id in get_QEv50card_cmd_iddesc(hbamodel_lsts)[0]:
                cmd_parminfo_id.append(id)
            for desc in get_QEv50card_cmd_iddesc(hbamodel_lsts)[1]:
                cmd_parminfo_desc.append(desc)
    except Exception, e:
        pass

    cmd_id = []
#   重新封装命令 
    for j in range(len(parmList)):
        cmd_parminfo_id.append("cmd_info_hba_card_esxcli_" + parmList[j])
        cmd_parminfo_desc.append("esxcfg-module -i" + " " + parmList[j])


    for singleParam in result:
        cmd_id.append("cmd_info_esxcli iscsi adapter param get -A " + singleParam)
        cmd_parminfo_id.append("cmd_info_esxcli iscsi adapter param get -A " + singleParam)
        cmd_parminfo_desc.append("esxcli iscsi adapter param get -A " + singleParam)

    getQECardTimeDesc(context, cmd_parminfo_id, cmd_parminfo_desc)
    context["totalPgr"] = constants.PROG75
    context["startPgr"] = constants.PROG15
    retMap = contentParse.getCommandRet(context, cmd_parminfo_id, cmd_parminfo_desc)
    #用作评估工具查看原始信息
    for cmd in cmd_id:
        cmdResult = retMap.get("cmd_display" + cmd[8:])
        cliRet += cmdResult + "\n"
    itemEvalResult = util.genEvalItemObj("IscsiTimeoutCheck", EvalResultEnum.PASSED, cliRet, "")
    retMap["evalResult"] = itemEvalResult

    return retMap


#构造获取HBA Q 卡  和 E卡的超时参数信息，此处不再区分vmvare子系统
def getQECardTimeDesc(context, cmd_parminfo_id, cmd_parminfo_desc):
    logger = context.get("PY_LOGGER")
    cmd_info_id = "cmd_info_hba_card_module_parameters_drivenum_"
    cmd_display = "cmd_display_hba_card_module_parameters_drivenum_"
    try:
        CLI = context.get("SSH")
        hbainfo_lines = CLI.execCmdWithTimout("esxcli storage core adapter list", 60)
        util.updateItemProgress(context, constants.PROG10)
        hbainfo_list = hbainfo_lines.splitlines()
        hbainfo_list = hbainfo_list[3:]

        for item in hbainfo_list:
            items = re.split('\s+', item)
            driver = items[1].strip()
            if QLOGIC_FLAG in driver:
                cmd_parminfo_id.append(cmd_info_id + driver + "_" + items[0])
                cmd_parminfo_desc.append("esxcli system module parameters list -m "
                                 + driver + " | grep 'qlport_down_retry'")

            elif EMULEX_FLAG in driver:
                cmd_parminfo_id.append(cmd_info_id + driver + "_" + items[0])
                cmd_parminfo_desc.append("esxcli system module parameters list -m "
                                 + driver + " | grep 'lpfc_devloss_tmo'")

    except Exception, e:
        msg = traceback.format_exc()
        logger.info("getQECardTimeDesc ==> " + msg)


def get_QEv50card_cmd_iddesc(hbamodel_lines):
    cmd_id_lst = ["cmd_info_hba_card_vm50_allinfo"]
    cmd_desc_lst = ["cat /proc/scsi/*/*"]
    model = ""
    hba_desc = ""
    try:
        if hbamodel_lines == None or 0 == len(hbamodel_lines) :
            return
        for hbamodel in hbamodel_lines:
            #Q card
            if "ql" in hbamodel:
                model = hbamodel
                if '' in model:
                    model = model.replace('', '/')

                if('/' in model):
                    hba_desc = re.split('/', model)[-3] + '/' + re.split('/', model)[-2].strip()
                    cmd_id_lst.append("cmd_info_hba_card_ql_model_" + hba_desc)
                    cmd_desc_lst.append("cat /proc/scsi/" + hba_desc + " | grep -i " + "'Fibre Channel'")

                    cmd_id_lst.append("cmd_info_hba_qcard_fw_version_" + hba_desc)
                    cmd_desc_lst.append("cat /proc/scsi/" + hba_desc + " | grep -i " + "'FC Firmware version'")

                    cmd_id_lst.append("cmd_info_hba_card_linktmo_model_" + hba_desc)
                    cmd_desc_lst.append("cat /proc/scsi/" + hba_desc + " | grep -i " + "'Link down Timeout'")

            elif 'lp' in hbamodel:
            #E card
                model = hbamodel
                if '' in model:
                    model = model.replace('', '/')
                if('/' in model):
                    hba_desc = re.split('/', model)[-3] + '/' + re.split('/', model)[-2].strip()
                    cmd_id_lst.append("cmd_info_hba_card_lp_model_" + hba_desc)
                    cmd_desc_lst.append("cat /proc/scsi/" + hba_desc + " | grep -i " + "'Fibre Channel Adapter'")

                    cmd_id_lst.append("cmd_info_hba_ecard_driver_version_" + hba_desc)
                    cmd_desc_lst.append("cat /proc/scsi/" + hba_desc + " | grep -i " + "'Emulex LightPulse'")

                    cmd_id_lst.append("cmd_info_hba_ecard_linktmo_model_" + hba_desc)
                    cmd_desc_lst.append("cat /proc/scsi/" + hba_desc + " | grep -i " + "'Firmware Version'")

    except Exception, e:
        pass
    return cmd_id_lst, cmd_desc_lst




def get_QEv55card_cmd_iddesc(hbamodel_lines):
    cmd_id_lst = ["cmd_info_hba_card_vm55_allinfo"]
    cmd_desc_lst = ["/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -a"]
    model = ""
    hba_desc = ""
     #test
    try:
        for hbamodel in hbamodel_lines:
            if ":" in hbamodel:
                model = re.split(':', hbamodel)[-1].strip()
            if '/' in model:
                hba_desc = re.split('/', model)[0].strip()
            if 'emulex' in model.lower():
                cmd_id_lst.append("cmd_info_hba_card_emulex_model_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"Fibre Channel Adapter\"")

                cmd_id_lst.append("cmd_info_hba_card_emulex_driversion_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"Emulex LightPulse\"")

                cmd_id_lst.append("cmd_info_hba_card_emulex_fw_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"FW Version\"")

                cmd_id_lst.append("cmd_info_hba_card_emulex_tmo_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"devloss-tmo\"")

            elif 'qlogic' in model.lower():
                cmd_id_lst.append("cmd_info_hba_card_qlogic_model_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"Fibre Channel\"")

                cmd_id_lst.append("cmd_info_hba_card_qlogic_fwdri_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"FC Firmware version\"")

                cmd_id_lst.append("cmd_info_hba_card_qlogic_downtmo_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"Link down Timeout\"")

                cmd_id_lst.append("cmd_info_hba_card_qlogic_mailtmo_" + hba_desc)
                cmd_desc_lst.append("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i " + model + " | " + "grep -i " + "\"Number of mailbox timeout\"")
    except Exception, e:
        pass
    return cmd_id_lst, cmd_desc_lst


#查询所以的hba卡型号
def get_all_hbalst(context, hbaversion):
    hba_lst = []
    try:
        if hbaversion >= 5.5:
            CLI = context.get("SSH")
            hbamodel_lines = CLI.execCmdHasLogTimout("/usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -a | grep -i 'Key Value Instance'", 60)
            hba_lst = re.split('\n', hbamodel_lines)
            hba_lst = hba_lst[1:]
            hba_lst = contentParse.check_lst(hba_lst)
            return hba_lst
        elif str(hbaversion) == "5.0":
            CLI = context.get("SSH")
            hba_lst = []
            hbamodel_lines = CLI.execCmdHasLogTimout("ls -1 /proc/scsi/*/*", 60)
            hba_lst = re.split('\n', hbamodel_lines)
            hba_lst = hba_lst[1:]
            hba_lst = contentParse.check_lst(hba_lst)
            return hba_lst
    except Exception, e:
        return hba_lst
