# coding=utf-8
#vmware 双活排查
import os
import sys
import traceback 

path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, "..\\..")
sys.path.append(path)
from vmware_multipath_info_check import hasNMP, hasUltrapath
from common.contentParse import getCommandRet
from common import constants
from common import util

NMP_RULE_LIST_COMMAND = "esxcli storage nmp satp rule list | grep -i 'HUAWEI'"
ULTRA_VERSION_COMMAND = "esxcli upadm show version"
ULTRA_UPCONFIG_COMMAND = "esxcli upadm show upconfig | grep 'APD to PDL Mode'"
SETTINGS_KERNEL_LIST_COMMAND = "esxcli system settings kernel list"

cmdDesc = [
            "vmware -vl"
           ]
cmdId = [
            "cmd_info_vmware_hypermetro_info_os_version"
         ]

def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmdDisplay
    """
    # 给全局变量赋初始值。
    global CLI
    CLI = context.get("SSH")
    #语言类型
    global LANGUAGE
    LANGUAGE = context.get("lang")
    
    #get logger
    global LOG
    LOG = context.get("Logger")
    LOG.info("***[start executing vmware hyper metro info]***")
    try:
        return collectHyperMetroInfo(context)
    except :
        msg = traceback.format_exc()
        LOG.error("vmware hypermetro info  execute ==> " + msg)       


def collectHyperMetroInfo(context):
    '''
    @summary: 收集双活信息
    @param context : 上下文
    @param CLI : SSH
    @param LANGUAGE : 语言类型
    @return: cmdDisplay 回文结果
    '''
    LOG.info("***[start executing collectHyperMetroInfo()]***")
    #get multipath info
    util.updateItemProgress(context, constants.PROG40)
    getMultipathInfo(context)
    util.updateItemProgress(context, constants.PROG80)
    cmdDisplay = context.get("ret_map")
    return cmdDisplay

def getMultipathInfo(context):
    '''
    @summary:获取双活多路径信息
    @param context : 上下文
    '''
    LOG.info("***[start executing getMultipathInfo()]***")
    try:
        '''
        #不存在共存的场景
        #根据不同多路径类型，获取相应多路径信息
        '''
        if hasUltrapath(context, False):
            LOG.info("***[multipath type is ultrapath ]***")
            colleUltraInfo(context)
        elif hasNMP(context, False):
            LOG.info("***[multipath type is nmp ]***")
            collectNmpInfo(context)
        else:
            cmdId.append("cmd_info_vmware_hypermetro_info_collect_settings")
            cmdDesc.append(SETTINGS_KERNEL_LIST_COMMAND)
            getCommandRet(context, cmdId, cmdDesc)  
            
            
    except:
        msg = traceback.format_exc()
        LOG.error("getMultipathInfo ==> " + msg)  

def colleUltraInfo(context):
    '''
    @summary:收集华为多路径信息
    @param context : 上下文
    '''
    LOG.info("***[start executing colleUltraInfo()]***")
    try:
        cmdRet = makeCommandList2Ultra(cmdId, cmdDesc)
        getCommandRet(context, cmdRet[0], cmdRet[1])                  
    except:
        msg = traceback.format_exc()
        LOG.error("collectNmpInfo ==> " + msg)

def makeCommandList2Ultra(cmdId=[], cmdDesc=[]):
    '''
    @summary: 构造命令列表
    @param cmdId: 命令描述列表
    @param cmdDesc: 命令列表  
    '''
    ultraCmdId = [] + cmdId     
    ultraCmdId.append("cmd_info_vmware_hypermetro_info_collect_ultra_version")
    ultraCmdId.append("cmd_info_vmware_hypermetro_info_collect_ultra_upconfig")
    ultraCmdId.append("cmd_info_vmware_hypermetro_info_collect_settings")
    ultracCmdDesc = [] + cmdDesc
    ultracCmdDesc.append(ULTRA_VERSION_COMMAND)
    ultracCmdDesc.append(ULTRA_UPCONFIG_COMMAND) 
    ultracCmdDesc.append(SETTINGS_KERNEL_LIST_COMMAND)
    return ultraCmdId, ultracCmdDesc

def collectNmpInfo(context):
    '''
    @summary:收集NMP多路径信息
    @param context : 上下文
    '''
    LOG.info("***[start executing collectNmpInfo()]***")
    try:
        cmdRet = makeCommandList2Nmp(cmdId, cmdDesc)
        getCommandRet(context, cmdRet[0], cmdRet[1])                  
    except:
        msg = traceback.format_exc()
        LOG.error("collectNmpInfo ==> " + msg)

def makeCommandList2Nmp(cmdId=[], cmdDesc=[]):
    '''
    @summary: 构造命令列表
    @param cmdId: 命令描述列表
    @param cmdDesc: 命令列表  
    '''
    nmpCmdId = [] + cmdId      
    nmpCmdId.append("cmd_info_vmware_hypermetro_info_collect_nmp")
    nmpCmdId.append("cmd_info_vmware_hypermetro_info_collect_settings")
    nmpCmdDesc = [] + cmdDesc
    nmpCmdDesc.append(NMP_RULE_LIST_COMMAND)
    nmpCmdDesc.append(SETTINGS_KERNEL_LIST_COMMAND) 
    return nmpCmdId, nmpCmdDesc
