#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@version: SmartKit V200R006C00
@time: 209/10/24
@file: vmware_lun_wwn_info.py
@function:
@modify:
"""

import sys
import os
import traceback

current_absolute_path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(current_absolute_path, "..\\..")
sys.path.append(path)
from common.contentParse import create_result_info
from common import constants
from common.util import log, HostResultInfo, HostLunInfo, \
    qryUltrapathVersion, check_ultrapath_is_pass, \
    create_lun_info, get_host_wwn_info

LAUNCHER = "esxcfg-scsidevs -a"


def get_result_info(context):
    """
    :param context:
    :return:
    """
    host_result_info = HostResultInfo()
    host_lun_info = HostLunInfo()
    cli = context.get("SSH")
    host_lun_info.set_host_id(cli.getHost())
    cli_rets = ''
    try:
        # from launcher get initiator info
        _, cli_rets, initiator_wwn = get_host_wwn_info(context)
        if initiator_wwn:
            host_lun_info.set_initiator(initiator_wwn)
            host_result_info.set_hosts(host_lun_info)
        else:
            log.info(context, "Cannot find host initiator info, set pass.")
            create_result_info(context, "True", cli_rets, LAUNCHER,
                               host_result_info)
            return

        is_ultrapath_qry_succ, ultrapath_version, cli_ret = \
            qryUltrapathVersion(context, isVMware=True)
        cli_rets += cli_ret

        if not is_ultrapath_qry_succ:
            log.error(context, 'Query ultrapath version failed.')
            fail_cmd = constants.ULTRA_PATH_VERSION_COMMAND
            create_result_info(context, "False", cli_rets, fail_cmd,
                               host_result_info)
            return

        if check_ultrapath_is_pass(context, ultrapath_version,
                                   constants.VMWARE_CONSISTENCY_ULTRAPATH_VER):
            create_result_info(context, "True", cli_rets, "",
                               host_result_info)
            log.info(context, 'ultrapath pass, return.')
            return

        is_qry_succ, _, cli_ret, disk_wwn_dict = qry_lun_wwn_info(context)
        cli_rets += cli_ret
        is_qry_host_lun_id_succ, cli_ret, host_lun_id_dict = \
            qry_lun_host_id_info(context, disk_wwn_dict)
        cli_rets += cli_ret
        if is_qry_succ and is_qry_host_lun_id_succ:
            create_lun_info(host_lun_info, host_lun_id_dict)
            host_result_info.set_hosts(host_lun_info)
            create_result_info(context, "nocheck", cli_rets, "",
                               host_result_info)
        else:
            fail_cmd = constants.NMP_EXIST_COMMAND
            create_result_info(context, "False", cli_rets, fail_cmd,
                               host_result_info)
    except Exception as e:
        log.info(context, "get host result info exception:%s:%s" % (
            e, str(traceback.format_exc())))
        create_result_info(context, "False", cli_rets, '',
                           host_result_info)


def qry_lun_wwn_info(context):
    """
    :param context:
    :return:
    """
    cli = context.get("SSH")
    lun_wwn = {}
    cli_ret = ''
    vlu_id_cmd = constants.NMP_EXIST_COMMAND
    try:
        cli_ret = cli.execCmdWithNoCheckResult(vlu_id_cmd,
                                               constants.HOST_CMD_TIMEOUT)
        for line in cli_ret.splitlines():
            line = line.strip().lower()
            if line.startswith("naa"):
                lun_wwn[line[4:]] = ""
        return True, '', cli_ret, lun_wwn
    except Exception as e:
        log.info(context, "Query nmp wwn exception:%s:%s" % (
            e, str(traceback.format_exc())))
        return False, vlu_id_cmd, cli_ret, {}


def qry_lun_host_id_info(context, disk_wwn_dict):
    """
    获取host_lun_id
    :param context:
    :param disk_wwn_dict:
    :return:
    """
    cli = context.get("SSH")
    host_lun_id_dict = {}
    cli_rets = ''
    log.info(context, "disk_wwn_dict:%s" % str(disk_wwn_dict))
    try:
        for key, value in disk_wwn_dict.items():
            host_lun_id_dict[key] = dict(disk_name="",
                                         host_lun_id=[])
            vlu_id_cmd = constants.NMP_EXIST_HOST_LUN_ID_COMMAND % key

            cli_ret = cli.execCmdWithNoCheckResult(vlu_id_cmd,
                                                   constants.HOST_CMD_TIMEOUT)
            cli_rets += cli_ret

            for line in cli_ret.splitlines():
                line = line.strip().lower()
                if line.startswith("lun:"):
                    host_lun_id = line[4:].strip()
                    host_lun_id_list = host_lun_id_dict[key].get(
                        constants.HOST_LUN_ID, [])
                    host_lun_id_list.append(host_lun_id)
        return True, cli_rets, host_lun_id_dict
    except Exception as e:
        log.info(context, "Query nmp host lun id exception:%s:%s" % (
            e, str(traceback.format_exc())))
    return False, cli_rets, {}
