# coding=utf-8
__author__ = '******'
# 获取vmvare主机的多路径信息
import os
import re
import sys
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path =os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants
from common import util
from common.contentParse import getCommandRet
from vmware_multipath_info_check import mulitpathExecute
from vmware_lun_wwn_info import get_result_info

cmd_info_id = ["cmd_info_multipath_esxcli_storage_mprunparams",
               "cmd_info_multipath_esxcli_mpathconfg",
               "cmd_info_multipath_esxcfg_mpath_l",
                #多路径状态检查
               "cmd_info_multipath_esxcli_phypathstate",
               "cmd_info_multipath_esxcli_lgcpathstate",
               "cmd_info_multipath_esxcli_lunpathinfo",
               "cmd_info_multipath_esxcli_mpathinfo",
               "cmd_info_multipath_esxcli_status"
                ]
            
cmd_info_desc = ["esxcli storage nmp device list",
                 "esxcli software vib list",
                 "esxcfg-mpath -l",
                  #多路径状态检查
                 "esxcli upadm show path",
                 "esxcli storage core path list",
                 "esxcli upadm show vlun -t all",
                 "esxcfg-mpath -b",
                 "esxcli storage nmp path list"
                 ]


def execute(context):
    util.updateItemProgress(context, constants.PROG5)
    get_result_info(context)
    mulitpathExecute(context)
    checkErrMsg = ''
    
    try:
        checkErrMsg = context.get("ret_map").get('err_msg')
    except:
        util.log.error(context,"get error msg key error.")
    context["totalPgr"] = constants.PROG30
    context["startPgr"] = constants.PROG65
    cmdDisplay = getCommandRet(context,cmd_info_id,cmd_info_desc)
    multipathInfoErrorMsg = cmdDisplay.get('err_msg')
    
    if checkErrMsg:
        cmdDisplay.put('err_msg', checkErrMsg + multipathInfoErrorMsg)
    else:
        cmdDisplay.put('err_msg', multipathInfoErrorMsg)
    return cmdDisplay 

