# coding=utf-8
#vmware 多路径信息检查
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult
import os
import re
import sys
import traceback 
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.util import chkSingleLunPathRedundant, MultipathCoexistenceInfo
import common.constants as CONSTANT
from common.contentParse import addMultiPathResultToFile
from common import util
from common import constants
CLI = None
LANGUAGE = None
ALL_DEVICE_SIZE = None
#存储信息字典
multiInfo = {}
#不通过的vlun列表
failVlunList = []
#不通过的hyper metro vlun列表
hyperLunNoRedundantPthIdList = []
#不通过的设备列表
failDeviceList = []
#用于保存执行失败的command
commandFailureList = []
#command execute result
executeCommandRet = []
#query fail device or lun list
queryFailList = []
#用于保存自带多路径iscsi的业务IP
selfMultiPathInfoList = []
#用于保存自带多路径场景下解析出的华为盘
hwNmpDiskList = []
#IP
IP = None
VMWARE_NO_MULTIPATH_UNABLE_TIPS = "ultrapath.and.multipathd.all.not.running"
#查询多路径版本失败，无法评估；
VMWARE_MULTIPATH_VERSION_QUERY_FAIL_UNABLE_TIPS = "qry.multipath.version.failed"
#自研和自带同时开启
VMWARE_ULTRA_NMP_BOTH_HAS_UNABLE_TIPS = "ultrapath.and.multipathd.all.running"
NMP_PATH_LIST_D = "esxcli storage core path list -d "
TRANSPORT = "transport:"
FC = "fc"
ISCSI = "iscsi"
MPX = "mpx"
NAA = "naa"
DISPLAY_NAME = "Display Name"



def mulitpathExecute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，传递上下文。
    global CLI
    CLI = context.get("SSH")
    #语言类型
    global LANGUAGE
    LANGUAGE = context.get("lang")
    
    #get logger
    global LOG
    LOG = context.get("Logger")
    LOG.info("***[start executing vmware info check]***")
    global COEXISTENCE
    COEXISTENCE = False

    #过滤掉与当前存储不关联的主机信息新增加字典格式如下:
    #LUNWWNSNDICT["0"] = WWN_600188210062f25795d139b700000004    自研+非双活
    #LUNWWNSNDICT["0"] = SN_210000188262f257,SN_210000188262f258 自研+双活
    global LUNWWNSNDICT
    LUNWWNSNDICT = {}

    global IP
    IP = CLI.getHost()
    cmd_display = context.get("ret_map")
    try:
        data = checkAndGetResult(context, CLI, LANGUAGE)
        commandDesc2 = "cmd_display_vmware_mulitipath_status_result_str"
        resultStr2 = CONSTANT.RESULT_FLAG + str(makeMultipathInfo())
        #多路径状态信息写入text
        LOG.info("***[multipath status result is: " + resultStr2 + "]***")
        cmd_display.put(commandDesc2, resultStr2)
        if data[2]:
            return cmd_display
        if data[0]:
            LOG.info("***[evaluate pass]***")
        else:
            LOG.info("***[evaluate failure]***")
        #将评估结果写入text中
        result = data[1]
        '''
        #结果 为字典结构。将其转换成字符串，存入text;
        #读取出该字符串后，使用eval()方法，可以将该结果再转换成字典
        '''
        resultStr = CONSTANT.RESULT_FLAG + result.getEvalResultJsonString()
        LOG.info("***[evaluate result is: " + resultStr + "]***")
        commandDesc = "cmd_display_vmware_mulitipath_check_result_str"
        #结果保存，最后写入text文件中
        cmd_display.put(commandDesc, resultStr)
        cmd_display.put("evalResult", result)
        return cmd_display
    except :
        msg = traceback.format_exc()
        LOG.error("vmware multipath execute ==> " + msg)

def makeMultipathInfo():
    '''
    @summary: 构造多路径信息，评估使用
    '''
    dataDict = {}
    versionStr = 'NA'
    if multiInfo.has_key("version"):
        versionStr = str(multiInfo["version"])
    dataDict["HuaweiMultipathVersion"] = versionStr
    dataDict["SelfMultiPath"] = multiInfo["SelfMultiPath"]
    dataStr = str(dataDict)
    return dataStr

def checkAndGetResult(context, CLI, LANGUAGE):
    '''
    @summary评估，并返回评估结果
    @param context : 上下文
    @param CLI : SSH
    @param LANGUAGE : 语言类型
    '''
    LOG.info("***[start executing checkAndGetResult()]***")
    flag = False
    result = None
    coexistFlag = False
    global LUNWWNSNDICT
    #若不是可支持的操作系统
    if not isVmwareOs(context):
        evalMessage = CONSTANT.OS_NOT_SUPPORT_TIPS
        paramList = []
        result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.UNABLE_EVAL, evalMessage, ''.join(executeCommandRet), paramList)
        util.updateItemProgress(context, constants.PROG20)
        return flag, result, coexistFlag
    #判断是否含有多路径
    util.updateItemProgress(context, constants.PROG5)
    if hasMultipath(context):
        typeFlag = multiInfo[CONSTANT.MULTI_PATH_TYPE]
        #自研自带共存情况
        if typeFlag == CONSTANT.ULTRA_AND_NMP:
            global COEXISTENCE
            COEXISTENCE = True
            coexistenceInfo = MultipathCoexistenceInfo()
            coexistenceInfo.setCoexistence(True)
            coexistenceInfo.setHostIP(str(IP))
            ultraPathCheck(context, coexistenceInfo)
            nmpCheck(context, coexistenceInfo)
            #将共存结果写入file
            LOG.info("***[ultrapath and nmp coexistence result is: %s]***" % coexistenceInfo.getJsonStr())
            if selfMultiPathInfoList:
                LOG.info("***[Multiple and ultrapath contains iSCSI paths. selfMultiPathInfoList is :" + str(selfMultiPathInfoList) + "]***");
                for selfMultiPathInfo in selfMultiPathInfoList:
                    coexistenceInfo.setSelfMultipathInfo(selfMultiPathInfo)
            addMultiPathResultToFile(context.get("ret_map"), coexistenceInfo.getJsonStr())
            coexistFlag = True
            return flag, result, coexistFlag
        #自研多路径
        elif typeFlag == CONSTANT.ULTRA:
            LOG.info("***[entry ultrapath]***")
            flag = ultraPathCheck(context)
        #自带多路径
        elif typeFlag == CONSTANT.NMP:
            LOG.info("***[entry nmp]***")
            flag = nmpCheck(context)
            LOG.info("***[nmpCheck is end, selfMultiPathInfoList is :" + str(selfMultiPathInfoList) + "]***")
        #evaluate fail
        if not flag:
            # get device or lun fail
            if commandFailureList and CONSTANT.ULTR_LUN_COMMAND in commandFailureList:
                paramList = [CONSTANT.ULTR_LUN_COMMAND] 
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.donot.get.disk.information', ''.join(executeCommandRet), paramList)
            elif commandFailureList and CONSTANT.ULTR_LUN_COMMAND_HIGH_VERSION in commandFailureList:
                paramList = [CONSTANT.ULTR_LUN_COMMAND_HIGH_VERSION]
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.donot.get.disk.information', ''.join(executeCommandRet), paramList)
            elif commandFailureList and CONSTANT.NMP_DEVICE_COMMAND in commandFailureList:
                paramList = [CONSTANT.NMP_DEVICE_COMMAND] 
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.donot.get.disk.information.vmware', ''.join(executeCommandRet), paramList)
            #this condition is lun query fail or some lun not pass
            else:
                result = multiInfo["result"]
        #pass's condition
        else:
            result = multiInfo["result"]
    #不存在多路径，则评估不通过
    else:
        result = multiInfo["result"]
               
    return flag, result, coexistFlag

def getPropProgress(prog):
    '''
    @summary: 返回恰当的进度信息
    :param prog:
    :return:
    '''
    if COEXISTENCE:
        return prog
    return prog * 2
def nmpCheck(context, coexistenceInfo=None):
    '''
    @summary:检查自带多路径
    @param context : 上下文
    '''

    #清空自研多路径信息
    global queryFailList
    queryFailList = []

    #共存场景下清空自研多路径回文信息
    global executeCommandRet
    if coexistenceInfo:
        executeCommandRet = []

    #清空自带多路径信息
    global commandFailureList
    commandFailureList = []

    LOG.info("***[start executing nmpCheck()]***")
    flag = False
    cmd_display = context.get("ret_map")
    try:
        util.addItemProgress(context, getPropProgress(constants.PROG5))
        if hwNmpDiskList:
            LOG.info("***[hwNmpDiskList: " + str(hwNmpDiskList) + "]***")
            #total device size
            ALL_DEVICE_SIZE = len(hwNmpDiskList)
            #对所有设备进行评估
            flag = evaluateDisks(hwNmpDiskList, context)
            #接管
            if coexistenceInfo:
                coexistenceInfo.getSelfMultiPath().setControl(True)
        elif coexistenceInfo:
            #共存情况下默认未接管，此处不用做处理
            util.addItemProgress(context, getPropProgress(constants.PROG20))
            return flag
        else:
            commandFailureList.append(CONSTANT.NMP_DEVICE_COMMAND)
            util.addItemProgress(context, getPropProgress(constants.PROG20))
            return flag     
        result = None
        #通过，PASSED，不用过FAILED
        if flag:
            if coexistenceInfo:
                coexistenceInfo.getSelfMultiPath().setCliRet(''.join(executeCommandRet))
            evalMessage = ""
            paramList = []
            result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.PASSED, evalMessage, ''.join(executeCommandRet), paramList)
            #评估通过，共存情况下不用做处理
        #fail's condition
        else:
            #all device query fail
            if ALL_DEVICE_SIZE == len(queryFailList):
                LOG.info("***[all device query fail]***")
                paramList = [str(IP), ','.join(queryFailList)]
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                if coexistenceInfo:
                    coexistenceInfo.getSelfMultiPath().setCliRet(''.join(executeCommandRet))
                    coexistenceInfo.getSelfMultiPath().setFailCommand(','.join(commandFailureList))
                    coexistenceInfo.getSelfMultiPath().setfailDescribe('qry.single.lunpath.failed')
                    coexistenceInfo.getSelfMultiPath().setNoRedundantPath(','.join(queryFailList))
            #some device query fail and other device not pass
            elif queryFailList and ALL_DEVICE_SIZE != len(queryFailList):
                LOG.info("***[some device query fail]***")
                paramList = [str(IP), ','.join(queryFailList + failDeviceList)]
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                if coexistenceInfo:
                    coexistenceInfo.getSelfMultiPath().setCliRet(''.join(executeCommandRet))
                    coexistenceInfo.getSelfMultiPath().setFailCommand(','.join(commandFailureList))
                    coexistenceInfo.getSelfMultiPath().setfailDescribe('qry.single.lunpath.failed')
                    coexistenceInfo.getSelfMultiPath().setNoRedundantPath(','.join(queryFailList + failDeviceList))
            #evaluate fail, some device not pass or all device not pass
            else:
                paramList = [str(IP), ','.join(failDeviceList)]
                LOG.info("***[failed device list: " + ','.join(failDeviceList) + "]***")
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                multiInfo[CONSTANT.NOT_PASS_DEVICE] = failDeviceList
                if coexistenceInfo:
                    coexistenceInfo.getSelfMultiPath().setCliRet(''.join(executeCommandRet))
                    coexistenceInfo.getSelfMultiPath().setNoRedundantPath(','.join(failDeviceList))
        #将结果写入multiInfo
        if selfMultiPathInfoList:
            LOG.info("***[Multiple paths and contains iSCSI paths.]***")
            result.setSelfMultiPathInfo(str(selfMultiPathInfoList).replace("u'", "'"))
        multiInfo['result'] = result
        
        return flag                   
    except:
        msg = traceback.format_exc()
        LOG.error("nmpCheck ==> " + msg)
        return flag

def evaluateDisks(deviceNames, context):
    '''
    @summary:检查所有磁盘是否通过评估
    @param deviceNames : 磁盘集合
    @param context :上下文
    '''
    LOG.info("***[start executing evaluateDisks()]***")
    flag = False
    command = "esxcfg-mpath -b -d "
    try:
        resultFlag = True
        if deviceNames:
            idx = 0
            prgStep, stepsUnit = util.calcPerStepDetail(getPropProgress(constants.PROG20), len(deviceNames))
            for deviceName in deviceNames:
                #每个设备返回的结果进行与操作
                currFlag = evaluateDisk(command + deviceName, deviceName, context)
                resultFlag = resultFlag and currFlag
                util.itemProgressIncr(context, idx, prgStep, stepsUnit)
                idx += 1
            flag = resultFlag
        return flag       
    except:
        msg = traceback.format_exc()
        LOG.error("evaluateDisks ==> " + msg) 
        return flag
   
def evaluateDisk(command, deviceName, context):
    '''
    @summary:单个磁盘检查是否通过评估
    @param cmmand : 执行命令
    @param deviceName : 设备名称
    @param context :上下文
    '''
    LOG.info("***[start executing evaluateDisk()]***")
    flag = False
    commandDesc = "vmware_multipath_info_check_nmp_disk_"
    cmd_display = context.get("ret_map")
    try:
        ret = oneCmdExecute(command, commandDesc + deviceName, context.get("ret_map"), CLI, LANGUAGE)
        #save execute result
        executeCommandRet.append(ret[2])
        wwpns = []
        resultDict = {}
        isIscsi = False
        isFc = False
        if ret[CONSTANT.MAGIC_INT0] == CONSTANT.MAGIC_INT1:
            lineList = ret[CONSTANT.MAGIC_INT2].splitlines()
            selfMultipathInfo = util.SelfMultipathInfo()
            for line in lineList:
                #adapter用于过滤空白行
                if "adapter" in line.lower():
                    if ISCSI in line.lower():
                        isIscsi = True
                        LOG.info(
                            "***[" + deviceName + " businessIP info str is: " + line + "]***")
                        # 因为IP V6的IP无法从路径信息中解析出IP信息，
                        # 需要使用路径信息是否包含阵列侧IP的形式判断（Java侧），故此处只保存路径信息，不解析IP
                        selfMultipathInfo.setPath(line)
                    else:
                        isFc = True    
                        item = line.strip()
                        #读取最后一个WWPN起始索引
                        index = item.rfind('WWPN')
                        data = item[index:]
                        LOG.info("***[last WWWPN index is: " + str(index) + "data is: " + data + "]***")
                        datas = re.split('\s+', data)
                        if datas and len(datas) >= 2:
                            wwpn = str(datas[CONSTANT.MAGIC_INT1].strip())
                            wwpns.append(wwpn)
            
            #如果存在iscsi组网下链路则存入
            if isIscsi:
                selfMultipathInfo.setDiskName(deviceName)
                #如果同磁盘下fc与iscsi共存，则为非标 
                if isIscsi and isFc:
                    selfMultipathInfo.setNetworkType('HybridNetwork')
                    selfMultiPathInfoList.append(selfMultipathInfo)
                    LOG.info("***[ Disk " + deviceName + " is HybridNetwork.]***")
                    return True
                else:
                    selfMultipathInfo.setNetworkType('ISCSI')
                    LOG.info("***[ Disk " + deviceName + " is ISCSI.]***")
                    selfMultiPathInfoList.append(selfMultipathInfo)
                    return True
            #遍历每一个wwpn
            if wwpns:
                LOG.info("***[wwpns is: " + str(wwpns) + "]***")
                for item in wwpns:
                    try:
                        processWwpn(item, resultDict)
                    except Exception as e:
                        LOG.error("parse wwn error:{0}".format(str(e)))
                LOG.info("***[resultDict= " + str(resultDict) + "]***")
                flag = verifyDeivce(resultDict)
            else:
                queryFailList.append(deviceName)
                return flag          
            #评估不通过，记录不通过设备名称
            if not flag:
                failDeviceList.append(deviceName)
        #命令执行失败
        else:
            LOG.info("***[command execute failure: " + command + " ]***")
            commandFailureList.append(command)
            queryFailList.append(deviceName)
            
        return flag         
    except:
        msg = traceback.format_exc()
        commandFailureList.append(command)
        queryFailList.append(deviceName)
        LOG.error("evaluateDisk ==> " + msg)
        return flag

def verifyDeivce(resultDict):
    '''
    @summary:验证该设备是否通过
    @param resultDict : 结果字典
    '''
    flag = False
    evenFlag = False
    oddFlag = False
    for _, v in resultDict.items():
        '''
        #不存在0、1平面同时存在，则评估不通过
        #(原逻辑只要有一个控制框不通过，则该设备部通过)
        #各个框内的所有面只要有0和1面即可通过
        '''
        if v['1'] == 1:
            evenFlag = True
        if v['0'] == 1:
            oddFlag = True
        #只要0/1面均存在了，即可通过评估
        if evenFlag and oddFlag:
            flag = True
            break
    return flag
              
def processWwpn(wwpn, resultDict):
    '''
    @summary:处理wwpn，计算出mac地址，节点号nodeId
    @param wwpn: wwpn
    @param resultDict : 结果字典
    '''
    LOG.info("***[start executing processWwpn()]***")
    _, ctrlEncMac, ctrlNodeId = util.parse_wwpn(str(wwpn))
    LOG.info("wwpn=%s, ctrlNodeId=%s" % (wwpn, str(ctrlNodeId)))

    nodeDict = None
    if resultDict.has_key(ctrlEncMac):
        nodeDict = resultDict[ctrlEncMac]
    else:
        nodeDict = {}
        #将0、1面均初始化为0
        nodeDict['0'] = 0
        nodeDict['1'] = 0
    '''
    #数据类型定义为 {"框架号" : {"奇偶平面号" : 0 / 1}}
    #1代表该类平通过，0代表该类平面不通过
    '''
    nodeDict[str(ctrlNodeId % 2)] = 1
    resultDict[ctrlEncMac] = nodeDict
    return resultDict


def dealNoRedundantPathLunInfo(noRedundantPathLunIdList):
    '''
    @summary:处理不冗余信息，对不冗余的LUN 增加 LUN 的WWN信息
    @param noRedundantPathLunIdList : 不冗余的LUN 列表
    '''
    #新增加LUN的SN\WWN信息,用于过滤 2018.12.15
    global LUNWWNSNDICT
    noRedundantPathLunIdtmp = []
    for noRedundantPathLunId in noRedundantPathLunIdList:
        noRedundantPathLunIdtmp.append(noRedundantPathLunId + '(' + LUNWWNSNDICT.get(noRedundantPathLunId, "") + ')'
        if LUNWWNSNDICT.get(noRedundantPathLunId, "")
        else noRedundantPathLunId)
    LOG.info("the LUNWWNSNDICT is :" + str(LUNWWNSNDICT))
    return noRedundantPathLunIdtmp

def ultraPathCheck(context, coexistenceInfo=None):
    '''
    @summary:检查自研多路径
    @param context : 上下文
    '''
    LOG.info("***[start executing ultraPathCheck()]***")
    flag = False

    commandDesc = "vmware_multipath_info_check_ultrapath"
    try:
        version = int(''.join(multiInfo["version"].split('.')))
        command = CONSTANT.ULTR_LUN_COMMAND if version <= CONSTANT.CMP_MULTI_PATH_VERSION else CONSTANT.ULTR_LUN_COMMAND_HIGH_VERSION
        ret = oneCmdExecute(command, commandDesc, context.get("ret_map"), CLI, LANGUAGE)
        #save execute result
        executeCommandRet.append(ret[2])
        vlunIdList = []
        #检查命令是否执行成功
        if ret[CONSTANT.MAGIC_INT0] == CONSTANT.MAGIC_INT1 and ret[CONSTANT.MAGIC_INT2].find("Vlun ID") > CONSTANT.MAGIC_INT0:
            lineList = ret[CONSTANT.MAGIC_INT2].splitlines()
            #取出所有的VLun ID
            if len(lineList) > CONSTANT.MAGIC_INT2:
                tempList = lineList[CONSTANT.MAGIC_INT2:]
                for item in tempList:
                    item = item.strip()
                    #为空，则进入下一循环
                    if not item:
                        continue
                    items = re.split("\s+", item)
                    num = items[CONSTANT.MAGIC_INT0].strip()
                    #过滤掉"-----"这类行，且第一项为数字
                    if num.isdigit():
                        #转换成字符，便于直接拼接
                        vlunIdList.append(str(num))
                LOG.info("***[total vlun size: " + str(len(vlunIdList)) + "]***")     
            #开始对每个vlun进行评估
            if vlunIdList:
                #all lun size
                ALL_DEVICE_SIZE = len(vlunIdList)
                query_ret = util.query_show_path_info(context,
                                                      "esxcli upadm show path")
                executeCommandRet.append(query_ret)
                flag = evaluateVluns(vlunIdList, context)
                if coexistenceInfo:
                    coexistenceInfo.getHuaweiMultipath().setControl(True)
            else:
                commandFailureList.append(command)
                #共存情况下默认未接管，此处不用做处理
                return flag
            result = None
            #通过，PASSED，不用过FAILED
            if flag:
                if coexistenceInfo:
                    coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))                
                evalMessage = ""
                paramList = []
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.PASSED, evalMessage, ''.join(executeCommandRet), paramList)
                #评估通过，共存情况下不用做处理
            #失败情况，包含多种情况，查询失败，部分评估不通过等
            else:
                #Only some lun query failed.
                if queryFailList and not failVlunList and not hyperLunNoRedundantPthIdList:
                    LOG.info("***[some lun query fail]***")
                    queryFailListTmp = dealNoRedundantPathLunInfo(queryFailList)
                    paramList = [str(IP), ','.join(queryFailListTmp)]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.ultrapath.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                    if coexistenceInfo:
                        coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                        coexistenceInfo.getHuaweiMultipath().setFailCommand(','.join(commandFailureList))
                        coexistenceInfo.getHuaweiMultipath().setfailDescribe('eval.host.multipath.reduntpath.qry.array.lunpath.failed')
                        coexistenceInfo.getHuaweiMultipath().setNoRedundantPath(','.join(queryFailListTmp))
                #some lun query fail and some normal lun not pass
                elif queryFailList and failVlunList and not hyperLunNoRedundantPthIdList:
                    LOG.info("***[some lun query fail and some normal not redundant]***")
                    queryFailListTmp = dealNoRedundantPathLunInfo(queryFailList)
                    failVlunListTmp = dealNoRedundantPathLunInfo(failVlunList)
                    paramList = [str(IP), ','.join(queryFailListTmp + failVlunListTmp)]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.ultrapath.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                    if coexistenceInfo:
                        coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                        coexistenceInfo.getHuaweiMultipath().setFailCommand(','.join(commandFailureList))
                        coexistenceInfo.getHuaweiMultipath().setfailDescribe('eval.host.multipath.reduntpath.qry.array.lunpath.failed')
                        coexistenceInfo.getHuaweiMultipath().setNoRedundantPath(','.join(queryFailListTmp + failVlunListTmp))
                #some lun query fail and some hyper lun not pass
                elif queryFailList and not failVlunList and hyperLunNoRedundantPthIdList:
                    evalMessage = CONSTANT.QRY_FAIL_HYPER_LUN_NO_REDUNDANT
                    queryFailListTmp = dealNoRedundantPathLunInfo(queryFailList)
                    hyperLunNoRedundantPthIdListTmp = dealNoRedundantPathLunInfo(hyperLunNoRedundantPthIdList)
                    paramList = [str(IP), ','.join(queryFailListTmp), ','.join(hyperLunNoRedundantPthIdListTmp)]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)
                    if coexistenceInfo:
                        coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                        coexistenceInfo.getHuaweiMultipath().setFailCommand(','.join(commandFailureList))
                        coexistenceInfo.getHuaweiMultipath().setfailDescribe('eval.host.multipath.reduntpath.qry.array.lunpath.failed')
                        coexistenceInfo.getHuaweiMultipath().setNoRedundantPath(','.join(queryFailListTmp + hyperLunNoRedundantPthIdListTmp))
                #some lun query fail and some normal lun and some hyper lun not pass
                elif queryFailList and failVlunList and hyperLunNoRedundantPthIdList:
                    evalMessage = CONSTANT.QRY_FAIL_NORMAL_AND_HYPER_LUN_NO_REDUNDANT
                    queryFailListTmp = dealNoRedundantPathLunInfo(queryFailList)
                    failVlunListTmp = dealNoRedundantPathLunInfo(failVlunList)
                    hyperLunNoRedundantPthIdListTmp = dealNoRedundantPathLunInfo(hyperLunNoRedundantPthIdList)
                    paramList = [str(IP), ','.join(queryFailList), ','.join(failVlunList), ','.join(hyperLunNoRedundantPthIdList)]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)
                    if coexistenceInfo:
                        coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                        coexistenceInfo.getHuaweiMultipath().setFailCommand(','.join(commandFailureList))
                        coexistenceInfo.getHuaweiMultipath().setfailDescribe('eval.host.multipath.reduntpath.qry.array.lunpath.failed')
                        coexistenceInfo.getHuaweiMultipath().setNoRedundantPath(','.join(queryFailListTmp + failVlunListTmp + hyperLunNoRedundantPthIdListTmp))
                #All lun query success, normal lun not pass.
                elif not queryFailList and failVlunList and not hyperLunNoRedundantPthIdList:
                    failVlunListTmp = dealNoRedundantPathLunInfo(failVlunList)
                    paramList = [str(IP), ','.join(failVlunListTmp)]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.ultrapath.donot.have.redundant.path', ''.join(executeCommandRet), paramList)
                    if coexistenceInfo:
                        coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                        coexistenceInfo.getHuaweiMultipath().setNoRedundantPath(','.join(failVlunListTmp))
                # All lun query success, hyper lun not pass.
                elif not queryFailList and not failVlunList and hyperLunNoRedundantPthIdList:
                    hyperLunNoRedundantPthIdListTmp = dealNoRedundantPathLunInfo(hyperLunNoRedundantPthIdList)
                    evalMessage = CONSTANT.ULTRA_HYPER_METRO_VLUN_NOT_PASS_TIPS
                    paramList = [str(IP), ','.join(list(set(hyperLunNoRedundantPthIdListTmp)))]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)
                    if coexistenceInfo:
                        coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                        coexistenceInfo.getHuaweiMultipath().setNoRedundantPath(','.join(hyperLunNoRedundantPthIdListTmp))
                # All lun query success, normal lun and hyper lun not pass.
                else:
                    evalMessage = CONSTANT.ULTRA_VLUN_NOT_PASS_TIPS
                    hyperLunNoRedundantPthIdListTmp = dealNoRedundantPathLunInfo(hyperLunNoRedundantPthIdList)
                    failVlunListTmp = dealNoRedundantPathLunInfo(failVlunList)
                    paramList = [str(IP), ','.join(failVlunListTmp), ','.join(list(set(hyperLunNoRedundantPthIdListTmp)))]
                    result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage,
                                            ''.join(executeCommandRet), paramList)
                    if coexistenceInfo:
                        coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                        coexistenceInfo.getHuaweiMultipath().setNoRedundantPath(','.join(failVlunListTmp + hyperLunNoRedundantPthIdListTmp))

            #将结果写入multiInfo
            multiInfo["result"] = result
        
        elif coexistenceInfo and re.search("Can't find any vluns", ret[2], re.I):
            return flag
        #命令执行失败，返回什么结果
        else:
            LOG.info("***[command execute failure: " + command + " ]***")
            commandFailureList.append(command)
            #共存查询LUN列表失败处理
            if coexistenceInfo:
                coexistenceInfo.getHuaweiMultipath().setCliRet(''.join(executeCommandRet))
                coexistenceInfo.getHuaweiMultipath().setFailCommand(command)
                coexistenceInfo.getHuaweiMultipath().setfailDescribe('eval.host.multipath.reduntpath.qry.array.id.empty')
        return flag          
    except:
        msg = traceback.format_exc()
        LOG.error("ultraPathCheck ==> " + msg)
        return flag 

def evaluateVluns(vlunList, context):
    '''
    @summary: 评估所有的vlun是否通过
    @param vlunList : vlunID 
    @param context : 上下文
    '''
    LOG.info("***[start executing evaluateVluns()]***")
    flag = True
    command = ""
    try:
        versionStr = multiInfo["version"]
        items = versionStr.strip().split('.')
        version = int(''.join(items))
        LOG.info("***[ultrapath version " + str(version) + "]***")
        idx = 0
        prgStep, stepsUnit = util.calcPerStepDetail(getPropProgress(constants.PROG30), len(vlunList))
        for vlun in list(set(vlunList)):
            #根据版本号范围确定执行命令
            if version <= CONSTANT.CMP_MULTI_PATH_VERSION:
                command = CONSTANT.SHOW_LUN_COMMAND + vlun
            else:
                command = CONSTANT.SHOW_LUN_COMMAND + vlun + " -t all"
            #每一个lun的评估结果与前一个结果进行与操作,以得到最终结果
            currFlag = evaluateVlun(command, context, vlun)
            flag = flag and currFlag
            util.itemProgressIncr(context, idx, prgStep, stepsUnit)
            idx += 1
        return flag
    except:
        msg = traceback.format_exc()
        LOG.error("evaluateVluns ==> " + msg)
        return False 

def evaluateVlun(command, context, vlunID):
    '''
    @summary:对单个vlun是否通过进行评估
    @param command : 执行命令
    @param context : 上下文
    @param vlunID : vlunID 
    '''
    global LUNWWNSNDICT
    LOG.info("***[start executing evaluateVlun()]***")
    flag = False
    commandDesc = "vmware_multipath_info_check_ultrapath_vlunid_" + vlunID
    try:
        ret = oneCmdExecute(command, commandDesc, context.get("ret_map"), CLI, LANGUAGE)
        #save execute result
        executeCommandRet.append(ret[2])
        if ret[0] == CONSTANT.MAGIC_INT1:
            retstr = ret[2].lower()
            # Migration lun处理
            if 'aggregation type' in retstr and 'migration' in retstr:
                LOG.info("Find migration LUN, ignore:" + str(vlunID))
                return True

            if retstr.find('aggregation type') > 0 and retstr.find('hyper metro') > 0:
                isHyperMetroLUN, flag, lunInfo = chkSingleLunPathRedundant(context, ret[2])

                #获得Lun的信息WWN\SN
                LUNWWNSNDICT[vlunID] = lunInfo

                if not flag:
                    LOG.error("hyper metro vlun check not pass:" + str(vlunID))
                    hyperLunNoRedundantPthIdList.append(vlunID)
            else:
                lineList = ret[2].splitlines()
                itemList = []
                resultDict = {}
                #去掉尾巴
                if len(lineList) > 2:
                    itemList = lineList[0:-1]
                    #获取框架号，奇偶平面信息
                    resultDict = getResultDict(itemList)
                    for line in lineList:
                        if "lun wwn" in line.lower():
                            lunWwn = line.split(':')[-1].strip()
                            LUNWWNSNDICT[vlunID] = ("WWN_" + lunWwn) if lunWwn else ""
                            break

                if resultDict: 
                    #根据resultDict字典结果，进行最终的结果判断
                    if resultDict["exist_shared_card"] \
                            and resultDict["exist_normal_card"]:
                        LOG.info("exist two type card")
                        return False
                    flag = processDict(resultDict, vlunID)
                    if not flag:
                        flag = util.check_lun_redundant_by_path_id(
                            context, resultDict.get("lun_path_ids"))
                else:
                    commandFailureList.append(command)
                    queryFailList.append(vlunID)
                    return flag
        else:
            LOG.info("***[command execute failure: " + command + " ]***")          
            commandFailureList.append(command)
            queryFailList.append(vlunID)   
        return flag             
    except:
        msg = traceback.format_exc()
        LOG.error("evaluateVlun ==> " + msg)
        return flag

def getResultDict(itemList):
    '''
    @summary:从lun信息中获取框架以及奇偶平面信息字典
    @param itemList : 磁盘信息列表
    '''
    LOG.info("***[start executing getResultDict()]***")
    regx = 'controller (\d+)([a|b|c|d])'
    try:
        i = 0
        resultDict = {}
        lun_path_ids = []
        resultDict["lun_path_ids"] = lun_path_ids
        resultDict["exist_shared_card"] = False
        resultDict["exist_normal_card"] = False
        #外层循环
        while i < len(itemList):
            item = itemList[i].lower().strip()
            util.add_ultra_path_id(item, lun_path_ids)
            if util.is_exist_shared_card(item):
                resultDict["exist_shared_card"] = True
            m1 = re.match(regx, item)
            #通过正则表达式匹配是否含有 "controller xa|xb|xc|xd"的字符串
            #如果有，从当前行的下一行开始，依次读取每一行，匹配是否含有normal的字符串，直到再匹配到
            #"controller xa|xb|xc|xd"
            #或者集合已经遍历完, 匹配成功后记录数据
            if m1 is not None:
                resultDict["exist_normal_card"] = True
                index = i + 1
                #是否含"normal"的标识
                hasNormal = False
                #内层循环，依次匹配是否含有normal
                while index < len(itemList):
                    line = itemList[index]
                    LOG.info("***[line= " + line.lower() + "]***")
                    m2 = re.match(regx, line.lower())
                    #排除"controller xa|xb|xc|xd"的字符串
                    if m2 is None:
                        #有"normal"
                        LOG.info("***[m2 is None, line= " + line.lower() + "]***")
                        if ("normal" in line.lower()):
                            hasNormal = True
                    #含有"controller xa|xb|xc|xd"的字符串，退出内层循环
                    #再次进入外层循环，并且外层从index行开始
                    else:
                        i = index
                        break
                    #下一行
                    index = index + 1
                    if hasNormal:
                        #当前行传递给外层i
                        i = index
                        break
                #退出内层循环，查看hasNormal标志位,如下记录数据
                #控制器类型从m1,group(2)中取出，可能为a/b/c/d
                controller = m1.group(2)
                #框架号
                ctrlFrame = m1.group(1)
                '''
                #数据类型定义为 {"框架号" : {"奇偶平面号" : 0 / 1}}
                #1代表该类平通过，0代表该类平面不通过
                '''
                resultDict = filldata2Dict(resultDict, hasNormal, controller, ctrlFrame) 
                if not hasNormal:
                    i = i + 1
            #i 加1，继续外层循环
            else:
                i = i + 1
        return resultDict        
    except:
        msg = traceback.format_exc()
        LOG.error("evaluateVlun ==> " + msg)

def processDict(resultDict, vlunID):
    '''
    @summary:填入了数据的字典进行处理，判断当前vlun是否通过，不通过则需记录当前vlun的ID号
    @param resultDict : 数据字典
    @param vlunID: vlunID 
    '''
    LOG.info("***[start executing processDict()]***")
    flag = False
    evenFlag = False
    oddFlag = False
    LOG.info("***[vlunID= " + vlunID + ", resultDict= " + str(resultDict) + "]***")
    for _, v in resultDict.items():
        #奇偶面同时存在，即同为1时，存在冗余路径, 否则无冗余路径
        #(原只要有一个框架评估不通过，则整个lun不通过)
        #所有框中只要同时含有奇偶面即可通过
        if 'ac' in v and v['ac'] == 1:
            oddFlag = True
        if 'bd' in v and v['bd'] == 1:
            evenFlag = True
        if oddFlag and evenFlag:
            flag = True
            break    
    LOG.info("***[processDict result is: " + str(flag) + "]***")
    #记录评估不通过的vlunId
    if not flag:
        failVlunList.append(vlunID)
    
    return flag
            
def filldata2Dict(resultDict, hasNormal, controller, ctrlFrame):
    '''
    @summary:将数据填充到字典中
    @param resultDict : 数据字典
    @param hasNormal: 标志位
    @param controller: 奇偶面
    @param ctrlFrame: 引擎号
    '''
    LOG.info("***[start executing filldata2Dict()]***")
    LOG.info("***[hasNormal= " + str(hasNormal) + ", controller= " + str(controller) + ", ctrlFrame= " + str(ctrlFrame) + "]***")
    #存储奇偶平面结果的字典
    ctrlDict = None
    if resultDict.has_key(ctrlFrame):
        ctrlDict = resultDict[str(ctrlFrame)]
    else:
        ctrlDict = {}
    
    if hasNormal:
        if 'a' in controller or 'c' in controller:
            ctrlDict['ac'] = 1
        elif 'b' in controller or 'd' in controller:
            ctrlDict['bd'] = 1
    else:
        if 'a' in controller or 'c' in controller:
            ctrlDict['ac'] = 0
        elif 'b' in controller or 'd' in controller:
            ctrlDict['bd'] = 0
    resultDict[str(ctrlFrame)] = ctrlDict
    return resultDict
    
def hasMultipath(context):
    '''
    @summary:判断是否安装了自研或者自带多路径
    @param context : 上下文
    '''
    LOG.info("***[start executing hasMultipath()]***")
    flag = False
    try:
        '''
        #判断是否有自研多路径
        '''
        ultraFlag = hasUltrapath(context)
        LOG.info("***[ultraFlag= " + str(ultraFlag) + "]***")
          
        '''
        #判断是否有自带多路径
        #为了保存自带多路径是否含有，此处必须执行
        '''
        nmpFlag = hasNMP(context)
        #ultra and nmp both enable
        if ultraFlag and nmpFlag:
            #此处更改逻辑，原策略自研自带共存直接报无法评估，现在执行策略：自研自带均验证，使用新的数据协议
            LOG.info("***[this vmware has ultra and nmp]***")
            multiInfo[CONSTANT.MULTI_PATH_TYPE] = CONSTANT.ULTRA_AND_NMP
            return ultraFlag and nmpFlag
            
        if ultraFlag:
            LOG.info("***[this vmware has ultrapath]***")
            multiInfo[CONSTANT.MULTI_PATH_TYPE] = CONSTANT.ULTRA
            flag = ultraFlag
        
        elif nmpFlag:
            LOG.info("***[this vmware has nmp]***")
            multiInfo[CONSTANT.MULTI_PATH_TYPE] = CONSTANT.NMP  
            flag = nmpFlag
        #多路径查询命令失败
        elif CONSTANT.ULTRA_PATH_VERSION_COMMAND in commandFailureList or CONSTANT.NMP_EXIST_COMMAND in commandFailureList or filter(lambda x : NMP_PATH_LIST_D in x, commandFailureList):
            paramList = []
            result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self&buildin.allnotexist', ''.join(executeCommandRet), paramList)
            multiInfo["result"] = result
        else:
            paramList = []
            result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, 'eval.host.multipath.reduntpath.self&buildin.allnotexist', ''.join(executeCommandRet), paramList)
            multiInfo["result"] = result
        
        return flag
    except:
        msg = traceback.format_exc()
        LOG.error("hasMultipath ==> " + msg)
        return flag     

def hasUltrapath(context, isRecord=True):
    '''
    @summary:判断是否有自研多路径
    @param context : 上下文
    '''
    global LOG
    LOG = context.get("Logger")
    LOG.info("***[start executing hasUltrapath()]***")
    flag = False
    command = CONSTANT.ULTRA_PATH_VERSION_COMMAND
    commandDesc = "vmware_multipath_info_check_has_ultrapath"
    pattern = "(\d+)\.(\d+)\.(\d+)"
    try:
        ret = oneCmdExecute(command, commandDesc, context.get("ret_map"), CLI, LANGUAGE, isRecord, context)
        #save execute result
        executeCommandRet.append(ret[2])
        #检查是否oneCmdExecute执行成功
        if ret[0] == CONSTANT.MAGIC_INT1:
            lineList = ret[2].splitlines()
            for line in lineList:
                if (CONSTANT.SOFT_WARE_VERSION in line.lower()) or (CONSTANT.DRIVER_VERSION in line.lower()):
                    datas = line.strip().split(":")
                    LOG.info("***[" + str(datas) + "]***")
                    if len(datas) > CONSTANT.MAGIC_INT1:
                        LOG.info("***[version= " + datas[1] + "]***")
                        if re.match(pattern, datas[1].strip()) is not None:
                            multiInfo["version"] = datas[1].strip()
                            flag = True
                            break
        else:
            LOG.info("***[command execute failure: " + command + "]***")
            commandFailureList.append(command)
            
        return flag
    except:
        msg = traceback.format_exc() 
        LOG.error("hasUltrapath ==> " + msg)
        return flag     

def hasNMP(context, isRecord=True):
    '''
    @summary:判断是否带有自带多路径
    @param context : 上下文
    '''
    LOG.info("***[start executing hasNMP()]***")
    flag = False
    command = CONSTANT.NMP_EXIST_COMMAND
    commandDesc = "vmware_multipath_info_check_has_nmp"
    currentdiskName = ''
    isCurrentHwDisk = False
    isNmp = False
    try:
        ret = oneCmdExecute(command, commandDesc,  context.get("ret_map"), CLI, LANGUAGE, isRecord, context)
        #save execute result
        executeCommandRet.append(ret[2])
        #检查是否命令执行成功
        if ret[0] == 1:
            lineList = ret[2].splitlines()
            
            for line in lineList:
                if line.lower().strip().startswith('naa.'):
                    currentdiskName = line.strip()
                    isCurrentHwDisk = True
                    LOG.info("***[start disk info = " + currentdiskName + "]***")
                #只在当前磁盘回显中查询相关 关键字                    
                if isCurrentHwDisk:
                    if CONSTANT.MULTIPATH_PLUGIN in line.lower() and not isNmp:
                        nmpData = line.split(":")[-1].strip().lower()
                        if "nmp" == nmpData:
                            flag = checkNmpPathTransport(currentdiskName, context, isRecord)
                            LOG.info("***[currentPathName= " + currentdiskName + "flag= " + str(flag) + "]***")                            
                            isNmp = flag
                            
                    if CONSTANT.VENDOR in line.lower():
                        vendorData = line.split(":")[-1].strip().lower()
                        LOG.info("***[vendorData= " + vendorData + "currentPathName= " + currentdiskName +"]***")
                        
                        for hwFlag in CONSTANT.HW_DISK_VENDOR:
                            if hwFlag == vendorData.lower():
                                isCurrentHwDisk = False 
                                hwNmpDiskList.append(currentdiskName)
                                break
        else:
            LOG.info("***[command execute failure: " + command + "]***")
            commandFailureList.append(command)
        #返回前记录NMP是否含有，用于多路径评估使用
        if flag:
            multiInfo["SelfMultiPath"] = "enabled"
        else:
            multiInfo["SelfMultiPath"] = "disabled"
            
        return flag
    except:
        msg = traceback.format_exc() 
        LOG.error("hasNMP ==> " + msg)
        multiInfo["SelfMultiPath"] = "disabled"
        return flag

def checkNmpPathTransport(pathName, context, isRecord=True):
    '''
    @summary: check nmp path transport'value is 'fc' or 'iscsi'
    @param pathName: nmp path name
    @param context: context provide some execute params  
    '''
    LOG.info("***[start executing checkNmpPathTransport()]***")
    flag = False
    commandDesc = "vmware_multipath_info_check_has_nmp_check_path"
    command = NMP_PATH_LIST_D + pathName
    try:
        ret = oneCmdExecute(command, commandDesc, context.get("ret_map"), CLI, LANGUAGE, isRecord, context)
        #save execute result
        executeCommandRet.append(ret[2])
        if ret[0] == CONSTANT.MAGIC_INT1:
            lineList = ret[2].splitlines()
            for line in lineList:
                item = line.lower()
                if TRANSPORT in item and (FC in item or ISCSI in item):
                    flag = True
                    break        
        else:
            LOG.info("***[command execute failure: " + command + "]***")
            commandFailureList.append(command)
        
        return flag
    except:
        msg = traceback.format_exc() 
        LOG.error("checkNmpPathTransport ==> " + msg)
        return flag    
    
def isVmwareOs(context):
    '''
    @summary:检查系统类型
    @param context : 上下文
    '''
    LOG.info("***[start executing isVmwareOs()]***")
    flag = False
    command = CONSTANT.OS_NAME_COMMAND
    commandDesc = "vmware_multipath_info_check_os"
    ret = oneCmdExecute(command, commandDesc, context.get("ret_map"), CLI, LANGUAGE)
    if ret[0] == CONSTANT.MAGIC_INT1:
        osType = ret[2]
        if osType:
            if "vmkernel" in osType.lower():
                flag = True
    else:
        LOG.info("***[command execute failure: " + command + "]***")
        commandFailureList.append(command)
    return flag

def oneCmdExecute(command, commandDesc, cmd_display, CLI, LANGUAGE, isRecord=True, context=None):
    '''
    @summary:获取单一命令执行结果
    @param command : shell 命令
    @param commandDesc: 命令描述
    @param cmd_display: 保存结果的map
    @param CLI: SSH连接
    @param LANGUAGE: 语言类型
    '''
    fun_flag = CONSTANT.CHECK_FAIL
    fun_err_msg = ''
    LOG.info("***[execute command: " + command + "]***")
    cli = CLI
    language = LANGUAGE
    if (cli is None or language is None) and context is not None:
        cli = context.get("SSH")
        language = context.get("lang")
    result = cli.execCmdWithNoCheckResult(command, CONSTANT.HOST_CMD_TIMEOUT)
    if isRecord:
        cmd_display.put("cmd_display_" + commandDesc, result)
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed", "not found"]
    if None == result or '' == result or filter(lambda x : x in result.lower(), regx):
        if "en" == language:
            fun_err_msg += command + ":\texecute failed\r\n"
        else:
            fun_err_msg += command + u":\t执行失败\r\n"
    else:
        if "en" == language:
            fun_err_msg += command + ":\texecute success\r\n"
        else:
            fun_err_msg += command + u":\t执行成功\r\n"
        
        fun_flag = CONSTANT.CHECK_PASS 
    oldErrMsg = ''
    try:
        oldErrMsg = cmd_display.get('err_msg')
        if not oldErrMsg:
            oldErrMsg = ''
    except:
        LOG.error("cmd_display has not err_msg key.")
        
    cmd_display.put("err_msg", oldErrMsg + fun_err_msg)
    LOG.info("***[" + fun_err_msg + "]***")
    return fun_flag, cmd_display, result

