#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
@version: SmartKit V200R006C00
@time: 2019/10/09
@file: vmware_network_discovery_info.py
@function:
@modify:
"""

import sys
import os

current_absolute_path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(current_absolute_path, "..\\..")
sys.path.append(path)
from common.contentParse import cmd_execute

cmd_info_id = ["cmd_info_os_vmware_info",
               "cmd_info_os_disk_capacity",
               "cmd_info_os_storage_volume",
               ]

cmd_info_desc = ["vmware -v",
                 "df -h",
                 "esxcli storage vmfs extent list",
                 ]


def execute(context):
    """
    :param context:
    :return:
    """

    cli = context.get("SSH")
    lan = context.get("lang")
    cmd_display = context.get("ret_map")
    cmd_info_dic = dict(zip(cmd_info_id, cmd_info_desc))
    cmd_execute(cmd_display, cli, lan, context, cmd_info_dic)
    return
