# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import BaseCmdExecute, CMD, DES

CMD_LIST = [{DES: "cmd_display_os_basic_vmware_v", CMD: "vmware -v"},
            {DES: "cmd_display_os_basic_vmware_l", CMD: "vmware -l"},
            {DES: "cmd_display_os_basic_uname_a", CMD: "uname -a"},
            {DES: "cmd_display_os_basic_esxcli_storage_adapter_list", CMD: "esxcli storage core adapter list"},
            {DES: "cmd_display_os_basic_esxcli_storage_core_device_list", CMD: "esxcli storage core device list"},
            {DES: "cmd_display_os_basic_esxcli_storage_core_path_list", CMD: "esxcli storage core path list"},
            {DES: "cmd_display_os_basic_esxcli_storage_vmfs_extent_list", CMD: "esxcli storage vmfs extent list"},
            {DES: "cmd_display_os_basic_esxcli_storage_filesystem_list", CMD: "esxcli storage filesystem list"},
            {DES: "cmd_display_os_basic_esxcli_storage_vm_process_list", CMD: "esxcli vm process list"},
            {DES: "cmd_display_os_basic_esxcfg_info_w", CMD: "esxcfg-info -w"},
            {DES: "cmd_display_os_basic_esxcfg_vmknic_l", CMD: "esxcfg-vmknic -l"},
            {DES: "cmd_display_os_basic_esxcli_hardware_cpu_list", CMD: "esxcli hardware cpu list"},
            {DES: "cmd_display_os_basic_esxcli_hardware_cpu_global", CMD: "esxcli hardware cpu global get"},
            {DES: "cmd_display_os_basic_esxcli_hardware_memory", CMD: "esxcli hardware memory get"},
            {DES: "cmd_display_os_basic_esxcli_hardware_platform", CMD: "esxcli hardware platform get"},
            {DES: "cmd_display_os_basic_nas_fileinfo", CMD: "esxcfg-nas -l"},
            {DES: "cmd_display_os_basic_nsatp", CMD: "esxcli storage nmp satp rule list"},
            {DES: "cmd_display_os_basic_san_fc_list", CMD: "esxcli storage san fc list"},
            {DES: "cmd_display_os_basic_san_fcoe_list", CMD: "esxcli storage san fcoe list"},
            {DES: "cmd_display_os_basic_san_iscsi_list", CMD: "esxcli storage san iscsi list"},
            ]

RESERVATION_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_readresv_", CMD: "vmkfstools -L readresv %s", },
]


def execute(context):
    VmwareOsBasicInfo(context).execute()


class VmwareOsBasicInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        """
        类的执行入口
        """
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(self.get_reservation_path_list(), RESERVATION_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_reservation_path_list(self):
        """
        获取预留数据的盘路径
        :return: 数据
        """
        cmd = "esxcli storage core device list"
        data_info = self.cli.execCmd(cmd)
        result = []
        for line in data_info.splitlines():
            if line.strip().startswith("Devfs Path:"):
                result.append((line.split(":")[1].strip(),))
        return result
