# coding=utf-8
__author__ = '******'
# vmware虚拟机信息
import os
import re
import sys
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import getCommandRet
from common import constants

cmd_info_id = [
               "cmd_info_virtual_machine_vms"          
               ]
            
cmd_info_desc = [
                 "vim-cmd vmsvc/getallvms"
                 ]

cmd_desc = "vim-cmd vmsvc/getallvms"
singleVim_cmd_id = "cmd_info_virtual_single_info_"
singleDetailVim_cmd_id = "cmd_info_virtual_single_detail_info_"
configAndStatus_cmd_id = "cmd_info_virtual_config_status_info_"
singleVim_cmd_desc = "vim-cmd vmsvc/get.summary "
singleDetailVim_cmd_desc = "vim-cmd vmsvc/device.getdevices "
configAndStatus_cmd_desc = "vim-cmd vmsvc/get.guest "

def execute(context):
    
    CLI = context.get("SSH")
    
    vmidsList = get_cmdlst_allVms(CLI, cmd_desc)
    
    if None != vmidsList:
        #多个for循环，使summary命令和detail命令集中收集，使页面展示更友好
        for vmid in vmidsList:
            cmd_info_id.append(singleVim_cmd_id + vmid)
            cmd_info_desc.append(singleVim_cmd_desc + vmid)
        
        for vmid in vmidsList:
            cmd_info_id.append(singleDetailVim_cmd_id + vmid)
            cmd_info_desc.append(singleDetailVim_cmd_desc + vmid)
        
        for vmid in vmidsList:
            cmd_info_id.append(configAndStatus_cmd_id + vmid)
            cmd_info_desc.append(configAndStatus_cmd_desc + vmid)
                    
    context["totalPgr"] = constants.PROG90
    return getCommandRet(context, cmd_info_id, cmd_info_desc)

def get_cmdlst_allVms(CLI, cmd_desc):
    cmd_value_temp = CLI.execCmd(cmd_desc)
    cmd_value_lst = cmd_value_temp.splitlines()
    #过滤掉无用的数据
    check_lst = []
    for line in cmd_value_lst:
        if '' != line.strip():
            check_lst.append(line)
    cmd_value_lst = check_lst

    vmids_lst = []
    for line in cmd_value_lst:
        lineList = re.split('\s\s+', line)
        if 2 < len(lineList):
            strFirst = lineList[0]
            if(strFirst.isdigit()):
                vmids_lst.append(strFirst)
    
    return vmids_lst 
