# --*-- coding:utf-8 --*--

'''vmware 各子系统版本 5.0-6.5 获取 hba卡超时参数'''

import sys
import os
import logging
import re
from common.contentParse import getCommandRetFromTxt, is_success
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)

#获取所有卡的超时参数信息
HBA_ESXCLI_STORAGE_CORE_ADAPTER_LIST = "cmd_display_os_basic_esxcli_storage_adapter_list"
# 超时参数标志
QLOGIC_TIME_FLAG = "qlport_down_retry"
EMULEX_TIME_FLAG = "lpfc_devloss_tmo"
# Q卡E卡标志
QLOGIC_FLAG = "ql"
EMULEX_FLAG = "lpfc"
#链接状态
LINK_STATE = "link-up"
VMWARE_FLAG = "vmware esxi"
  
#判断是否超时
def evaluateHbaTimeParam(context):
    global logger
    logger = context.get("Logger")
    result = ""
    dictList = []
    hasEmptyTimeout = False
    dataList = getHbaTimeoutInfo(context, HBA_ESXCLI_STORAGE_CORE_ADAPTER_LIST)
    if dataList:
        logger.info(str(len(dataList)) + " hba card object")
        for item in dataList:
            dictList.append(timeoutParam2Dict(item))
        for hba in dataList:
            #只返回含有超时时间的hba信息
            if not (hba.get_hba_timeout_value() == 'NA'):
                result = result + hba.toJsonStr() + ","
            else:
                logger.info("Driver: " + hba.get_hba_driver() + "command execute failure")
                hasEmptyTimeout = True

        result = result[0:-1]
        result = "[" + result + "]"
    #是否增加逻辑，只要有driver获取超时参数信息执行命令失败，及本次超时参数采集失败，无法评估？？？？
    #没有获取到E卡 Q卡信息时
    else:
        result = "NA"
    context['result'] = result
     
    return context
    
#获取超时参数信息对象列表
def getHbaTimeoutInfo(context, command):
    context['command'] = command
    infoLine = getCommandRetFromTxt(context)
    infoList = []
    dataList = []
    if infoLine:
        infoList = infoLine[2:]
    if infoList:
        for item in infoList:
            if ((QLOGIC_FLAG in item) or (EMULEX_FLAG in item)) and (LINK_STATE in item):
                hbaTimeObj = makeHbaTimeoutArgs(item)
                dataList.append(hbaTimeObj)        
    if dataList:
        for data in dataList:
            getQECardTime(context, data)
    
    return dataList
    
#构造超时参数对象
def makeHbaTimeoutArgs(hbaitem):  
    if None != hbaitem:
        hbaTimeoutObj = HbaTimeoutArgs()
        items = re.split('\s{2,}', hbaitem)
        hbaTimeoutObj.set_hba_name(items[0])
        hbaTimeoutObj.set_hba_driver(items[1])
        cardWwpn = items[3]
        if cardWwpn:
            wwpns = re.split(':', cardWwpn)
            if (len(wwpns) == 2):
                hbaTimeoutObj.set_hba_card_wwpn(wwpns[1])
        
        return hbaTimeoutObj

#获取每个具体Q卡或者E卡的超时参数信息
def getQECardTime(context, hbaTimeoutObj):  
    command = "cmd_display_hba_card_module_parameters_drivenum_"
    cmd_display = command + hbaTimeoutObj.get_hba_driver() + "_" + hbaTimeoutObj.get_hba_name()
    logger.info("cmd_display= " + cmd_display)
    context['command'] = cmd_display
    infoList = getCommandRetFromTxt(context)
    if not is_success(infoList):
        logger.info("have no info,command execute failure: " + cmd_display)
        
        return
    #此处获取的回文信息列表，在vmvare6.0系统中，命令跨行，不能直接使用infoList[0]
    #含有超时参数信息标志，默认不包含
    hasTimeoutInfo = False
    for info in infoList:
        if (QLOGIC_TIME_FLAG in info.lower()) or (EMULEX_TIME_FLAG in info.lower()):
            hasTimeoutInfo = True
            datas = re.split('\s{2,}', info.strip())
            if (len(datas) == 4) and (datas[2] != None) and (datas[2].isdigit()):
                hbaTimeoutObj.set_hba_timeout_value(datas[2])
                break
            #使用默认值10
            else:
                logger.info("not exists timeout info: " + info)
                logger.info("set default value : 10")
                hbaTimeoutObj.set_hba_timeout_value(10)
                break
    #有Driver，但是未获取到相应超时参数信息，则为命令执行失败         
    if not hasTimeoutInfo:
        logger.info("Driver: " + hbaTimeoutObj.get_hba_driver() + " get timeout info failure, command execute failure")
                   
    return hbaTimeoutObj
            
#构造json对象使用    
def timeoutParam2Dict(hba):
    dict = {}
    dict["hbaName"] = hba.get_hba_name()
    dict["hbaDriver"] = hba.get_hba_driver()
    dict["WWPN"] = hba.get_hba_card_wwpn()
    dict["timeout"] = hba.get_hba_timeout_value()
        
    return dict

#将数据转换成json格式
def getJson(dataList):
    data = ""
    try:
        #call json.dumps
        data = dataList
    except Exception, e:
        logger.info("getJson Exception: " + e)
    
    return data

#获取vmvare版本号
def getVmvareVersionFromText(context):
    context['command'] = 'cmd_display_os_basic_vmware_l'
    list = getCommandRetFromTxt(context)
    versionLine = ""
    version = ""
    if is_success(list):
        for item in list:
            if (VMWARE_FLAG in item.lower()):
                versionLine = item
                break
    if versionLine != "":
        data = versionLine.strip().split()
        version = data[2]
        version = version.strip()[0:3]
     
    return version       
         
#HBA超时参数信息类
class HbaTimeoutArgs:
    #wwpn号
    __hba_card_wwpn = 'NA'
    #host    
    __hba_name = 'NA'
    #驱动    
    __hba_driver = 'NA'
    #超时时间    
    __hba_timeout_value = 'NA'
    #卡型号
    __hba_model = 'NA'
    
    #import json 时报错，jython包版本低
    def toJsonStr(self):
        jsonStr = ""
        wwpn = "\"" + "WWPN" + "\"" + ":" + "\"" + self.__hba_card_wwpn + "\""
        driver = "\"" + "HBADriver" + "\"" + ":" + "\"" + self.__hba_driver + "\""
        
        portId = "\"" + "PortID" + "\"" + ":" + "\"" + 'NA' + "\""
        hbaName = "\"" + "HBAName" + "\"" + ":" + "\"" + self.__hba_name + "\"" 
        host = "\"" + "Host" + "\"" + ":" + "{" + portId + "," + hbaName + "}"
              
        timeout = "\"" + "Timeout" + "\"" + ":" + "\"" + str(self.__hba_timeout_value) + "\""
        hbamodel = "\"" + "HBAModel" + "\"" + ":" + "\"" + self.__hba_model + "\""
        
        jsonStr = "{" + wwpn + "," + driver + "," + host + "," + timeout + "," + hbamodel + "}"
        
        return jsonStr
        
    def get_hba_timeout_value(self):
        return self.__hba_timeout_value
    
    def get_hba_name(self):
        return self.__hba_name
    
    def get_hba_driver(self):
        return self.__hba_driver
    
    def get_hba_card_wwpn(self):
        return self.__hba_card_wwpn
    
    def get_hba_model(self):
        return self.__hba_model
    
    #set
    def set_hba_card_wwpn(self, hbaCardWwpn):
        self.__hba_card_wwpn = hbaCardWwpn
        
    def set_hba_name(self, hbaName):
        self.__hba_name = hbaName
    
    def set_hba_driver(self, hbaDriver):
        self.__hba_driver = hbaDriver
    
    def set_hba_timeout_value(self, timeoutValue):
        self.__hba_timeout_value = timeoutValue
    
    def set_hba_model(self, hbaModel):
        self.__hba_model = hbaModel
    
