# --*-- coding:utf-8 --*--

'''
提取iscsi超时时间
'''

import os
import sys
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)

from common import contentParse

def execute(context):
    '''
    @Function describe  : 把所有iscsi超时时间按格式NoopOutInterval:15,NoopOutTimeout:10,RecoveryTimeout:10抓出来
    @param context: context
    '''
    tempList = contentParse.getCommandRetFromTxt(context)
    result = '';

    for lineStr in tempList:
        if "online" in lineStr and "iscsi" in lineStr:
            hbaLineList = lineStr.strip().split()

            #再搜索此回文，找到iscsi的一些超时参数
            context["command"] = "cmd_display_esxcli iscsi adapter param get -A " + hbaLineList[0]
            iscsiTimeoutList = contentParse.getCommandRetFromTxt(context)

            #三个值，默认为NA
            noopOutIntervalValue = 'NA'
            noopOutTimeoutValue = 'NA'
            recoveryTimeoutValue = 'NA'

            for timeoutLine in iscsiTimeoutList:
                #先判断长度
                timeoutList = timeoutLine.strip().split()
                if 1 == len(timeoutList):
                    continue

                if "NoopOutInterval" in timeoutLine:
                    noopOutIntervalValue = timeoutList[1]
                elif "NoopOutTimeout" in timeoutLine:
                    noopOutTimeoutValue = timeoutList[1]
                elif "RecoveryTimeout" in timeoutLine:
                    recoveryTimeoutValue = timeoutList[1]

            oneHbaTimeout = "NoopOutInterval:" + noopOutIntervalValue + "," + \
                            "NoopOutTimeout:" + noopOutTimeoutValue + "," + \
                            "RecoveryTimeout:" + recoveryTimeoutValue + ";"

            result += oneHbaTimeout

    if not result:
        context["result"]="NA"
        return

    context["result"]=result[0:-1]

