# --*-- coding:utf-8 --*--


#获取vmware,HBA卡型号,报告cmd_display_hba_card_esxcli处获取

import sys
import os
import re
import ast

path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getCommandRetFromTxt, get_vmware_version_fromtxt, getSortedComds
from common.contentParse import getSameCommandsHbaRetFromTxt, is_vmware_version_ge_55, getSingleOrMoreCommandRetFromTxt

def getHbaInfoByDirectCon(context):
    '''
    @summary: Query the HBA Model infomation.
    @param context: Python execution context.
    @return (HBA Model info)
    '''
    global logger
    logger = context.get("Logger")
    hbaModel = ''
    hbaInfo = getSameCommandsHbaRetFromTxt(context, ["HBA_information"])
    logger.info("the HBA infomation by direct connection: " + str(hbaInfo))

    for line in hbaInfo:
        for infostr in line:
            if "Model" in infostr:
                hbaModel = ast.literal_eval(infostr)["Model"]
                return hbaModel
    return hbaModel

def execute(context):

    hbaModel = getHbaInfoByDirectCon(context)
    if hbaModel:
        context['result'] = hbaModel[:-1]
        return context
    else:
        context['result'] = "NA"
        return context

    tempList = getCommandRetFromTxt(context)
    
    cmd_detail_lst = []
    command = context['command']
    hba_version = get_vmware_version_fromtxt(context)
    cmd_detail_lst = getSortedComds(context,command)
   
    if 0 == len(cmd_detail_lst):
        context['result']='NA'
    else:
        all_hbalst_lst = getSameCommandsHbaRetFromTxt(context,cmd_detail_lst)
        result = extractInfo(context,all_hbalst_lst,hba_version)
        if 0 == len(result):
            context['result']=result
        if result[-1] == ',':
            result = result[0:-1]
            result = result.replace(',',';')
            context['result']=result
        else:
            result = result.replace(',',';')
            context['result']=result
    return context

def extractInfo(context,all_hbalst_lst,hba_version):
    hba_lst = []
    for hbavalue_lst in all_hbalst_lst:
        hba_lst.append(get_hba_model(hbavalue_lst,hba_version))
     
    if isHbaLstNotRigt(hba_lst):
        hba_lst = []
        HbaModelCmd = "cmd_display_hba_wwpns"
         
        hbaModelRets = getSingleOrMoreCommandRetFromTxt(context, HbaModelCmd, False)
        for line in hbaModelRets:
            if ('Fibre Channel' in line) and ('link'  in line) and ('up' in line):
                lst = line.split()
                for hba  in lst:
                    if 'lpe' in hba.lower():
                        hba_lst.append(hba)
                        break
    if not hba_lst:
        return "NA"
    else:
        return ";".join(hba_lst)


def isHbaLstNotRigt(lst):
    '''
    @summary: lst里面放的是hba卡型号，如果其中一个值为空串则认为没有拿到正确的值
    @param lst: 放的hba卡型号的列表
    '''
    if not lst:
        return True
    
    for line  in lst:
        if ('' == line.strip()) or (('NA' == line.strip())):
            return True
    return False  

# ******************************************************
# 功能：获取hba卡型号
# 规则：
# vmware 5.0和5.5型号获取方式不一样
# vmware 5.0 Q卡
# cmd_display_hba_card_ql_model_qla2xxx/7
# ~ # cat /proc/scsi/qla2xxx/7 | grep -i 'Fibre Channel'
# QLogic PCI to Fibre Channel Host Adapter for QLE2562:
#  
# cmd_display_hba_card_ql_model_qla2xxx/8
# ~ # cat /proc/scsi/qla2xxx/8 | grep -i 'Fibre Channel'
# QLogic PCI to Fibre Channel Host Adapter for QLE2562:
# vmware 5.0 E卡
# cmd_display_hba_card_lp_model_lpfc820/6
# ~ # cat /proc/scsi/lpfc820/6 | grep -i 'Fibre Channel Adapter'
# Emulex LPe1250-F8 8Gb PCIe Fibre Channel Adapter on PCI bus 0000:02 device 00 irq 136
# vmware 5.5 E卡
# cmd_display_hba_card_emulex_model_vmhba3
# ~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmhba3/Emulex | grep -i 
# "Fibre Channel Adapter"
# Emulex LPe12002    8Gb 2-port PCIe Fibre Channel Adapter on PCI bus 0000:03 device 00 fn 1 port 1
# vmware 5.5 Q卡
# cmd_display_hba_card_qlogic_model_QLNATIVEFC
# ~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i QLNATIVEFC/qlogic | grep
#
#  -i "Fibre Channel"
# QLogic PCI to Fibre Channel Host Adapter for QLE2462:
# QLogic PCI to Fibre Channel Host Adapter for QLE2462:
# *********^^^^^^^^^^************^^^^^^^^^^*********
# ******************************************************
def get_hba_model(hbalst,hba_version):
    if is_vmware_version_ge_55(hba_version):
        return get_hbamodel_v55(hbalst,hba_version)
    else:
        return get_hbamodel_v50(hbalst,hba_version)
        

def get_hbamodel_v50(hbalst,hbaversion):
    card_type = ""
    hbamodel = ""
    for hba in hbalst:
        if "cmd_display_hba_card_ql_model_" in hba:
            card_type = "Q_Card"
        elif "cmd_display_hba_card_lp_model_" in hba:
            card_type = "E_Card"
    
    if "Q_Card" == card_type:
        for line in hbalst:
            if ('host' in line.lower()) and ('adapter' in line.lower()) and ('for' in line.lower()):
                hbamodel = re.split('for',line)[-1].strip()
                hbamodel = hbamodel.replace(':','')
    elif "E_Card" == card_type:
        for line in hbalst:
            if ('Fibre'.lower() in line.lower()) and ('Channel'.lower() in line.lower()) and ('Adapter'.lower() in line.lower()) and ('cat'.lower() not in line.lower()):
                lst = []
                lst = re.split('\s+',line)
                ibm_idx = 0
                for idx,hba in enumerate(lst):
                    if 'lpe' in hba.lower():
                        hbamodel = hba.strip()
                        break
                    if hba.startswith('IBM'):
                        ibm_idx = idx
                        break
                try:
                    hbamodel = lst[ibm_idx] +" " +  lst[ibm_idx+1]
                except:
                    hbamodel = "NA"
    if not hbamodel:
        return 'NA'
    return hbamodel


def get_hbamodel_v55(hbalst,hbaversion):
    card_type = ""
    hbamodel = ""
    for hba in hbalst:
        if "cmd_display_hba_card_qlogic_model_" in hba:
            card_type = "Q_Card"
        elif "cmd_display_hba_card_emulex_model_" in hba:
            card_type = "E_Card"
    
    if "Q_Card" == card_type:
        for line in hbalst:
            if ('fibre' in line.lower()) and ('channel' in line.lower()) and ('-i' not in line.lower()):
                temp = re.split('for',line)[-1].strip()
                temp = temp.replace(':','')
                hbamodel = hbamodel + temp + ','
        if len(hbamodel) >= 1:        
            if ',' == hbamodel[-1]:
                hbamodel = hbamodel[0:-1].strip()
    elif "E_Card" == card_type:
        for idx,line in enumerate(hbalst):
            if ('Fibre'.lower() in line.lower()) and ('Channel'.lower() in line.lower()) and ('Adapter'.lower() in line.lower()) and ('cat'.lower() not in line.lower()):
                lst = []
                lst = hbalst[idx+1].split()
                for hba in lst:
                    if 'lpe' in hba.lower():
                        hbamodel = hba.strip()
                        break
    if not hbamodel:
        return 'NA'
    return hbamodel
