# --*-- coding:utf-8 --*--


#获取vmware,HBA卡驱动版本

import sys
import os
import re
import ast

path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getCommandRetFromTxt,get_vmware_version_fromtxt,getSortedComds
from common.contentParse import getSameCommandsHbaRetFromTxt,is_vmware_version_ge_55

def getHbaInfoByDirectCon(context):
    '''
    @summary: Query the HBA fw version infomation.
    @param context: Python execution context.
    @return (HBA fw version info)
    '''
    global logger
    logger = context.get("Logger")
    hbaDriVer = ''
    hbaInfo = getSameCommandsHbaRetFromTxt(context, ["HBA_information"])
    logger.info("the HBA infomation by direct connection: " + str(hbaInfo))

    for line in hbaInfo:
        for infostr in line:
            if "DriverVersion" in infostr:
                hbaDriVer = ast.literal_eval(infostr)["DriverVersion"]
                return hbaDriVer
    return hbaDriVer

def execute(context):
    hbaDriVer = getHbaInfoByDirectCon(context)
    if hbaDriVer:
        context['result'] = hbaDriVer[:-1]
        return context
    else:
        context['result'] = "NA"
        return context

    tempList = getCommandRetFromTxt(context)
    
    cmd_detail_lst = []
    command = context['command']
    hba_version = get_vmware_version_fromtxt(context)
    cmd_detail_lst = getSortedComds(context,command)
    
    if 0 == len(cmd_detail_lst):
        context['result']='NA'
    else:
        all_hbalst_lst = getSameCommandsHbaRetFromTxt(context,cmd_detail_lst)
        result = extractInfo(all_hbalst_lst,hba_version)
        result = result.replace(',',';')
        context['result']=result
    return context


def extractInfo(all_hbalst_lst,hba_version):
    hba_lst = []
    result = ""
    
    for hbavalue_lst in all_hbalst_lst:
        driVersion = get_hba_driversion(hbavalue_lst,hba_version)
        if driVersion:
            hba_lst.append(driVersion)
    if 0 == len(hba_lst):
        result = "NA"
    else:
        result = ",".join(hba_lst)
    return result


# ******************************************************
# 功能：获取hba卡驱动版本
# 规则：
# vmware 5.0和5.5驱动版本获取方式不一样，如以下回文
# vmware 5.0
# E卡：
# cmd_display_hba_ecard_driver_version_lpfc820/6
# ~ # cat /proc/scsi/lpfc820/6 | grep -i 'Emulex LightPulse'
# Emulex LightPulse FC SCSI 8.2.2.1-18vmw
# -------------
# Q卡：
# cmd_display_hba_qcard_fw_version_qla2xxx/7
# ~ # cat /proc/scsi/qla2xxx/7 | grep -i 'FC Firmware version'
#        FC Firmware version 5.03.15 (d5), Driver version 901.k1.1-14vmw
# *********^^^^^^^^^^************^^^^^^^^^^*********
# cmd_display_hba_qcard_fw_version_qla2xxx/8
# ~ # cat /proc/scsi/qla2xxx/8 | grep -i 'FC Firmware version'
#        FC Firmware version 5.03.15 (d5), Driver version 901.k1.1-14vmw
# ===
# vmware 5.5
# E卡：
# cmd_display_hba_card_emulex_driversion_vmhba3
# ~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmhba3/Emulex | grep -i 
# "Emulex LightPulse"
# Emulex LightPulse FC SCSI 10.0.100.1
# *********^^^^^^^^^^************^^^^^^^^^^*********
# cmd_display_hba_card_emulex_driversion_vmhba2
# ~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmhba2/Emulex | grep -i 
# "Emulex LightPulse"
# Emulex LightPulse FC SCSI 10.0.100.1
# Q卡：
# cmd_display_hba_card_qlogic_fwdri_QLNATIVEFC
# ~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i QLNATIVEFC/qlogic | grep
# 
# -i "FC Firmware version"
#        FC Firmware version 5.09.00 (9496), Driver version 1.0.12.0
#        FC Firmware version 5.09.00 (9496), Driver version 1.0.12.0
# ******************************************************
def get_hba_driversion(hbalst,hba_version):
    if is_vmware_version_ge_55(hba_version):
        return get_hba_driversion_v55(hbalst,hba_version)
    else:
        return get_hba_driversion_v50(hbalst,hba_version)


def get_hba_driversion_v50(hbalst,hbaversion):
    card_type = ""
    result = ""
    for hba in hbalst:
        if "cmd_display_hba_qcard_fw_version_" in hba:
            card_type = "Q_Card"
        elif "cmd_display_hba_ecard_driver_version_" in hba:
            card_type = "E_Card"
    
    if "Q_Card" == card_type:
        for line in hbalst:
            if ('fc' in line.lower()) and ('firmware' in line.lower()) and ('version' in line.lower()) and('/proc/scsi/' not in line):
                versiont_lst = re.split('\s+',line)
                result = versiont_lst[-1].strip()
                result = result.replace(':','')
    elif "E_Card" == card_type:
        for line in hbalst:
            if ('Emulex'.lower() in line.lower()) and ('LightPulse'.lower() in line.lower()) and ('/proc/scsi/'.lower() not in line.lower()):
                result = re.split('\s+',line)[-1].strip()
    return result


# vmware 5.5 E卡
def get_hba_driversion_v55(hbalst,hbaversion):
    '''
    @summary: 获取vmware 5.5 及之后版本的E卡或Q卡 驱动版本
    E卡回显如：
    [root@localhost:~] /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmhba3/Em 
    ulex | grep -i "Emulex LightPulse"
    Emulex LightPulse FC SCSI 10.2.309.8
    
    [root@localhost:~] /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmnic1/Em 
    ulex | grep -i "Emulex LightPulse"
    
    '''
    
    card_type = ""
    result = ""
    for hba in hbalst:
        if "cmd_display_hba_card_qlogic_fwdri_" in hba:
            card_type = "Q_Card"
            break
        elif "cmd_display_hba_card_emulex_driversion_" in hba:
            card_type = "E_Card"
            break
    
    if "Q_Card" == card_type:
        for line in hbalst:
            if ('fc' in line.lower()) and ('firmware' in line.lower()) and ('driver' in line.lower()):
                driversion = re.split('\s+',line)[-1].strip()
                driversion = driversion.replace(':','')
                result = result + driversion +','
        result = result[0:-1]
    elif "E_Card" == card_type:
        for line in hbalst:
            if (line.strip().lower().startswith('emulex lightpulse')):
                lst = []
                lst = re.split('\s+',line)
                result = lst[-1].strip()
                break
    return result

