# --*-- coding:utf-8 --*--


#获取vmware,HBA卡FW版本

import sys
import os
import re
import ast

path = os.path.dirname(os.path.abspath(__file__))
path =os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getCommandRetFromTxt,get_vmware_version_fromtxt,getSortedComds     
from common.contentParse import getSameCommandsHbaRetFromTxt,is_vmware_version_ge_55    

def getHbaInfoByDirectCon(context):
    '''
    @summary: Query the HBA fw version infomation.
    @param context: Python execution context.
    @return (HBA fw version info)
    '''
    global logger
    logger = context.get("Logger")
    hbaFwVer = ''
    hbaInfo = getSameCommandsHbaRetFromTxt(context, ["HBA_information"])
    logger.info("the HBA infomation by direct connection: " + str(hbaInfo))

    for line in hbaInfo:
        for infostr in line:
            if "FWVersion" in infostr:
                hbaFwVer = ast.literal_eval(infostr)["FWVersion"]
                return hbaFwVer
    return hbaFwVer

def execute(context):
    hbaFwVer = getHbaInfoByDirectCon(context)
    if hbaFwVer:
        context['result'] = hbaFwVer[:-1]
        return context
    else:
        context['result'] = "NA"
        return context

    tempList = getCommandRetFromTxt(context)
    
    cmd_detail_lst = []
    command = context['command']
    hba_version = get_vmware_version_fromtxt(context)
    cmd_detail_lst = getSortedComds(context,command)
    
    if 0 == len(cmd_detail_lst):
        context['result']='NA'
    else:
        all_hbalst_lst = getSameCommandsHbaRetFromTxt(context,cmd_detail_lst)
        result = extractInfo(all_hbalst_lst,hba_version)
        
        result = result.replace(',',';')
        context['result']=result
    return context


def extractInfo(all_hbalst_lst,hba_version):
    hba_lst = []
    result = ""
    
    for hbavalue_lst in all_hbalst_lst:
        fwVersion = get_hba_fwversion(hbavalue_lst,hba_version)
        if fwVersion:
            hba_lst.append(fwVersion)
    if 0 == len(hba_lst):
        result = "NA"
    else:
        result = ",".join(hba_lst)
    return result


# ******************************************************
# 规则：
# vmware 5.0和5.5FW版本获取方式不一样，如以下回文
#vmware 5.0
#E卡
#cmd_display_hba_ecard_linktmo_model_lpfc820/6        ,注意：这个地方要改下命令
#~ # cat /proc/scsi/lpfc820/6 | grep -i "Firmware Version"
#Firmware Version: 2.01A13 (OS2.01A13)
#Q卡
#cmd_display_hba_qcard_fw_version_qla2xxx/7
#~ # cat /proc/scsi/qla2xxx/7 | grep -i 'FC Firmware version'
#        FC Firmware version 5.03.15 (d5), Driver version 901.k1.1-14vmw
#-----
#cmd_display_hba_qcard_fw_version_qla2xxx/8
#~ # cat /proc/scsi/qla2xxx/8 | grep -i 'FC Firmware version'
#        FC Firmware version 5.03.15 (d5), Driver version 901.k1.1-14vmw
#vmware 5.5
#E卡：
#cmd_display_hba_card_emulex_fw_vmhba2
#~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmhba2/Emulex | grep -i 
#"FW Version"
#FW Version:    2.01A11
#*********^^^^^^^^^^************^^^^^^^^^^*********
#cmd_display_hba_card_emulex_fw_vmhba3
#~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmhba3/Emulex | grep -i 
#"FW Version"
#FW Version:    2.01A11
#*********^^^^^^^^^^************^^^^^^^^^^*********
#Q：
#cmd_display_hba_card_qlogic_fwdri_QLNATIVEFC
#~ # /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i QLNATIVEFC/qlogic | grep
# -i "FC Firmware version"
#        FC Firmware version 5.09.00 (9496), Driver version 1.0.12.0
#        FC Firmware version 5.09.00 (9496), Driver version 1.0.12.0
# ******************************************************
def get_hba_fwversion(hbalst,hba_version):
    if is_vmware_version_ge_55(hba_version):
        return get_hba_fwversion_v55(hbalst,hba_version)
    else:
        return get_hba_fwversion_v50(hbalst,hba_version)


def get_hba_fwversion_v50(hbalst,hbaversion):
    card_type = ""
    result = ""
    for hba in hbalst:
        if "cmd_display_hba_qcard_fw_version_" in hba:
            card_type = "Q_Card"
        elif "cmd_display_hba_ecard_linktmo_model_" in hba:
            card_type = "E_Card"
    
    if "Q_Card" == card_type:
        for line in hbalst:
            if ('fc' in line.lower()) and ('firmware' in line.lower()) and ('version' in line.lower()) and('/proc/scsi/' not in line):
                versiont_lst = re.split('\s+',line.strip())
                result = versiont_lst[3].strip()
                result = result.replace(':','')
    elif "E_Card" == card_type:
        for line in hbalst:
            if ('Firmware'.lower() in line.lower()) and ('Version'.lower() in line.lower()) and ('/proc/scsi/'.lower() not in line.lower()):
                result = re.split('\s+',line)[2].strip()
                result = result.replace(':', '')
    return result
# vmware 5.5 E卡
def get_hba_fwversion_v55(hbalst,hbaversion):
    '''
    @summary: 获取vmware 5.5 及之后版本的E卡或Q卡 fw版本
    E卡回显如：
    [root@localhost:~] /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmhba3/Em 
    ulex | grep -i "FW Version"
    FW Version: 10.2.590.0
    
    [root@localhost:~] /usr/lib/vmware/vmkmgmt_keyval/vmkmgmt_keyval -l -i vmnic1/Em 
    ulex | grep -i "FW Version"
    
    '''
    card_type = ""
    result = ""
    for hba in hbalst:
        if "cmd_display_hba_card_qlogic_fwdri_" in hba:
            card_type = "Q_Card"
            break
        elif "cmd_display_hba_card_emulex_fw_" in hba:
            card_type = "E_Card"
            break
    
    if "Q_Card" == card_type:
        for line in hbalst:
            if ('fc' in line.lower()) and ('firmware' in line.lower()) and ('driver' in line.lower()):
                driversion = re.split('\s+',line.strip())[3].strip()
                driversion = driversion.replace(':','')
                result = result + driversion +','
        result = result[0:-1]
    elif "E_Card" == card_type:
        for line in hbalst:
            if (line.strip().lower().startswith('fw version:')):
                lst = []
                lst = re.split(':',line)
                result = lst[-1].strip()
                break
    return result
