# --*-- coding:utf-8 --*--
import sys
import os
import re
reload(sys)
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getSameCommandsHbaRetFromTxt
from common.contentParse import getSingleOrMoreCommandRetFromTxt
'''
   1、执行命令： esxcli storage core adapter list |grep -i "Fibre Channel"
   2、提取状态是linkup的端口的wwpn，如以下回文（由于有时候linkup状态的回文并不是link-up开头，所以脚本中配置up开头）
   vmhba5    lpfc          link-up     fc.20000090fa92bbe4:10000090fa92bbe4   xxx  Emulex LPe16000 16Gb PCIe Fibre Channel Adapter
        则  wwpn=10000090fa92bbe4。
'''
#获取hba卡数量
def execute(context):
    #命令描述
    CMD_DESC_WWPN = "cmd_display_hba_wwpns"
    UP = 'up'

    #回文列表
    wwpn_lst = []
    wwpn_clean = []

    all_result = ""
    fc_result = ""

    #获取回文
    wwpn_lst = getSameCommandsHbaRetFromTxt(context, [CMD_DESC_WWPN])[0]
    #过滤
    for wwpnline in wwpn_lst:
        if ("Fibre" in wwpnline) and ("Channel" in wwpnline) and ("esxcli" not in wwpnline) and ("storage" not in wwpnline):
            wwpn_clean.append(wwpnline)
    wwpn_lst = wwpn_clean


    for line in wwpn_lst:
        lst = re.split('\s\s+', line)
        if UP in lst[2]:
            wwpn = re.split(':', lst[3])[-1].strip()
            fc_result = fc_result + wwpn + ';'
    if not fc_result:
        fc_result = "NA"
    else:
        fc_result = fc_result[0:-1]

    iscsi_result = get_iscsi_wwn(context)

    if fc_result == "NA":
        all_result = iscsi_result
    else:
        if iscsi_result == "NA":
            all_result = fc_result
        else:
            all_result = fc_result + ";" + iscsi_result

    context["result"] = all_result
    return context


def get_iscsi_wwn(context):
    """
    获取iscsi的wwn
    :param context:
    :return:
    """
    iscsi_wwn = ""
    cmd_iscsi_wwn_desc = "cmd_display_hba_iscsi"
    iscsi_wwn_str = getSingleOrMoreCommandRetFromTxt(context,
                                                     cmd_iscsi_wwn_desc, False)
    for line in iscsi_wwn_str:
        if "iqn." in line and "iSCSI" in line:
            start_index = line.find("iqn.")
            end_index = line.find("iSCSI")
            iscsi_wwn = iscsi_wwn + line[start_index:end_index] + ";"
    if not iscsi_wwn:
        iscsi_wwn = "NA"
    else:
        iscsi_wwn = iscsi_wwn[0:-1]

    return iscsi_wwn
