# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from common.cmd_execute import change_list_to_tuple, DES, CMD
from common.cmd_execute_offline import BaseCmdExecuteOffline
from common.contentParse import get_cmd_ret
from hosts.common.windows_parse_utils import get_horizontal_cli_ret

CMD_LIST = [
    {DES: "cmd_display_cluster_name_info", CMD: "powershell get-cluster"},
    {DES: "cmd_display_cluster_share_info", CMD: "powershell Get-ClusterSharedVolume"},
    {DES: "cmd_display_cluster_quorum_info", CMD: "powershell Get-ClusterQuorum"},
    {DES: "cmd_display_cluster_resource_info", CMD: "powershell Get-ClusterResource"},
    {DES: "cmd_display_cluster_vm_info", CMD: "powershell get-vm"},
]

VM_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_cluster_vm_drive_", CMD: "powershell get-vmharddiskdrive '%s'"},
    {DES: "cmd_display_cluster_vm_hba_", CMD: "powershell get-vmfibrechannelhba '%s'"},
]

RESOURCE_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_resource_", CMD: "powershell \"Get-ClusterResource -Name '%s'\""},
    {DES: "cmd_display_resource_parameter_",
     CMD: "powershell \"Get-ClusterResource -Name '%s' | Get-ClusterParameter\""},

]

CSV_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_csv_", CMD: "powershell \"Get-ClusterSharedVolume '%s' | select *\""},
    {DES: "cmd_display_csv_parameter_",
     CMD: "powershell \"Get-ClusterSharedVolume -Name '%s' | Get-ClusterParameter\""},
]


def execute(context):
    WindowsCluster(context).execute()


class WindowsCluster(BaseCmdExecuteOffline):
    def __init__(self, context):
        BaseCmdExecuteOffline.__init__(self, context)

    def execute(self):
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_vm_name_list()), VM_RELATIVE_CMD_DICTS)
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_resource_name_list()),
                                        RESOURCE_RELATIVE_CMD_DICTS)
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_csv_name_list()), CSV_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_vm_name_list(self):
        """
        获取虚拟机名列表
        :return: 数据
        """
        self.context["command"] = "powershell get-vm"
        return self.get_param_list("Name")

    def get_resource_name_list(self):
        """
        获取resource名列表
        :return: 数据
        """
        self.context["command"] = "powershell Get-ClusterResource"
        return self.get_param_list("Name")

    def get_csv_name_list(self):
        """
        获取csv名列表
        :return: 数据
        """
        self.context["command"] = "powershell Get-ClusterSharedVolume"
        return self.get_param_list("Name")

    def get_param_list(self, key_name):
        """
        获取 参数 列表
        :param key_name: key值
        :return: 数据
        """
        data_info = get_cmd_ret(self.context).splitlines()[1:-1]
        data_dicts = get_horizontal_cli_ret("\n".join(data_info))
        data_names = []
        for data_dict in data_dicts:
            data_names.append(data_dict.get(key_name, ""))
        return data_names
