# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
import re

from common.cmd_execute import DES, CMD, change_list_to_tuple
from common.cmd_execute_offline import BaseCmdExecuteOffline
from common.contentParse import get_cmd_ret
from hosts.common.windows_parse_utils import get_drive_letter

CMD_LIST = [
    {DES: "cmd_display_disk_info", CMD: "mpclaim -s -d", },
    {DES: "cmd_display_disk_size", CMD: "powershell Get-Disk"},
    {DES: 'cmd_info_volume_info', CMD: 'powershell get-volume'},
    {DES: 'cmd_info_diskpart_list_disk', CMD: 'DISKPART> list disk'},
    {DES: 'cmd_info_diskpart_detail_disk', CMD: 'DISKPART> detail disk'},
    {DES: 'cmd_info_diskpart_list_volume', CMD: 'DISKPART> list volume'},
    {DES: 'cmd_info_diskpart_detail_volume', CMD: 'DISKPART> detail volume'},
    {DES: "cmd_display_disk_info_vxdisk", CMD: "vxdisk list"},
    {DES: "cmd_display_disk_info_dlnkmgr", CMD: "dlnkmgr view -lu"},
    {DES: "cmd_display_disk_info_powermt", CMD: "powermt display dev=all"},
    {DES: "cmd_display_disk_info_ultra", CMD: "upadm show vlun"},
    {DES: "cmd_display_ultra_version", CMD: "upadm show version"},
    {DES: "cmd_display_power_version", CMD: "powermt version"},
    {DES: "cmd_display_hdlm_version", CMD: "dlnkmgr view -sys"},
    {DES: "cmd_display_vxdmp_version", CMD: "vxassist version"},
    {DES: "cmd_display_disk_info_physical_disk", CMD: "powershell \"Get-PhysicalDisk | select *\""},
    {DES: "cmd_display_disk_info_partition", CMD: "powershell Get-Partition"},
]

DRIVER_LETTER_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_disk_info_drive_letter_", CMD: "powershell \"Get-Partition -DriveLetter %s | select *\""},
]

MPIO_DISK_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_disk_detail_", CMD: "mpclaim -s -d %s"},
]


def execute(context):
    WindowsMultiPath(context).execute()


class WindowsMultiPath(BaseCmdExecuteOffline):
    def __init__(self, context):
        BaseCmdExecuteOffline.__init__(self, context)

    def execute(self):
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_driver_letter_list()),
                                        DRIVER_LETTER_RELATIVE_CMD_DICTS)
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_disk_ids()), MPIO_DISK_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_driver_letter_list(self):
        """
        获取盘符
        :return: 数据
        """
        self.context["command"] = "powershell Get-Partition"
        data_info = get_cmd_ret(self.context)
        letters = []
        for line in data_info.splitlines():
            letter = get_drive_letter(line)
            if letter:
                letters.append(letter)
        return letters

    def get_disk_ids(self):
        """
        获取disk的id
        :return: 数据
        """
        ids = []
        self.context["command"] = "mpclaim -s -d"
        ids_info = get_cmd_ret(self.context)
        start_flag = False
        for line in ids_info.splitlines():
            if "-----------" in line:
                start_flag = True
                continue
            if start_flag and line:
                disk_id = re.split(r"\s+", line)[1].replace("Disk", "")
                if disk_id.isdigit():
                    ids.append(disk_id)
        return ids
