# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import BaseCmdExecute, DES, CMD, change_list_to_tuple
from hosts.common.windows_parse_utils import get_drive_letter, get_horizontal_cli_ret

CMD_LIST = [{DES: 'cmd_display_ClusterResource_info', CMD: 'powershell Get-ClusterResource'},
            {DES: 'cmd_display_ClusterQuorum_info', CMD: 'powershell Get-ClusterQuorum'},
            {DES: 'cmd_display_ClusterSharedVolume_info', CMD: 'powershell Get-ClusterSharedVolume'},
            {DES: 'cmd_display_ClusterSharedVolumeState_info', CMD: 'powershell Get-ClusterSharedVolumeState'},
            {DES: 'cmd_display_Clusternode_info', CMD: 'powershell Get-Clusternode'},
            {DES: 'cmd_display_ClusterGroup_info', CMD: 'powershell Get-ClusterGroup'},
            {DES: 'cmd_display_ClusterGroup_cluster', CMD: 'powershell get-cluster'},
            {DES: 'cmd_display_ClusterGroup_clusternetworkinterface', CMD: 'powershell get-clusternetworkinterface'},
            {DES: 'cmd_display_disk_info_physical_disk', CMD: 'powershell "Get-PhysicalDisk | select *"'},
            {DES: 'cmd_display_disk_info_partition', CMD: "powershell Get-Partition"},
            ]

DRIVER_LETTER_RELATIVE_CMD_DICTS = [
    {DES: 'cmd_display_disk_info_drive_letter_', CMD: 'powershell "Get-Partition -DriveLetter %s | select *"'},
]

RESOURCE_RELATIVE_CMD_DICTS = [
    {DES: 'cmd_display_resource_', CMD: 'powershell "Get-ClusterResource -Name \'%s\'"'},
    {DES: 'cmd_display_resource_parameter_',
     CMD: 'powershell "Get-ClusterResource -Name \'%s\' | Get-ClusterParameter"'},

]

CSV_RELATIVE_CMD_DICTS = [
    {DES: 'cmd_display_csv_', CMD: 'powershell "Get-ClusterSharedVolume \'%s\' | select *"'},
    {DES: 'cmd_display_csv_parameter_',
     CMD: 'powershell "Get-ClusterSharedVolume -Name \'%s\' | Get-ClusterParameter"'},
]


def execute(context):
    WindowsCluster(context).execute()


class WindowsCluster(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        """
        类的执行入口
        """
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_driver_letter_list()),
                                        DRIVER_LETTER_RELATIVE_CMD_DICTS)
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_resource_name_list()),
                                        RESOURCE_RELATIVE_CMD_DICTS)
        self.generate_relative_cmd_list(change_list_to_tuple(self.get_csv_name_list()), CSV_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_driver_letter_list(self):
        """
        获取windows主机的盘符
        :return: 数据
        """
        cmd = 'powershell Get-Partition'
        data_info = self.cli.execCmd(cmd)
        letters = []
        for line in data_info.splitlines():
            letter = get_drive_letter(line)
            if letter:
                letters.append(letter)
        return letters

    def get_resource_name_list(self):
        """
        获取resource名列表
        :return: 数据
        """
        cmd = 'powershell Get-ClusterResource'
        return self.get_param_list(cmd, 'Name')

    def get_csv_name_list(self):
        """
        获取csv名列表
        :return: 数据
        """
        cmd = 'powershell Get-ClusterSharedVolume'
        return self.get_param_list(cmd, 'Name')

    def get_param_list(self, cmd, key_name):
        """
        获取 参数 列表
        :param cmd: 命令
        :param key_name: key值
        :return: 数据
        """
        data_info = self.cli.execCmd(cmd)
        data_dicts = get_horizontal_cli_ret(data_info)
        data_names = []
        for data_dict in data_dicts:
            data_names.append(data_dict.get(key_name, ''))
        return data_names
