# -*- coding: UTF-8 -*-
import re
import sys
import traceback
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import singleCmdExecute, saveAluaStatusAndCliRet2ForeEval
from common import util
from common import constants
from common import contentParse
cliRets = []
LINE_BREAK = "\n"
NUM_INT_3 = 3
queryAluaStatusFailedDisks = []
ALUA_ENABLED = 'enabled'
ALUA_NOT_ENABLED = 'not enabled'
ALUA_UNKNOW = 'unknown'
CHECK_FAIL = 0
CHECK_PASS = 1
ALL_MATCHED = 2
def execute(context):
    '''
    @param context: execute context 
    '''
    global LOGGER
    LOGGER = context.get("Logger")
    cmd_display = context.get("ret_map")
    errMsg = ''
    cliRets = ''
    try:
        CLI = context.get("SSH")
        LOGGER = context.get("Logger")
        global LANGUAGE
        LANGUAGE = context.get("lang")
        LOGGER.info("start to query alua infomation..")
        util.updateItemProgress(context, constants.PROG15)
        try:
            cliRets = CLI.executeCmdTimeoutLcalWmic("mpclaim -e", constants.PROG75)
        except :
            cliRets = CLI.executeCmdTimeout("mpclaim -e", constants.PROG75)        
        errMsg = util.errorMsgHandler(errMsg, cliRets, "mpclaim -e", LANGUAGE)
        cmd_display.put("err_msg", errMsg)
        cmd_display.put("cmd_display" + "_mpclaim -e", cliRets)
        util.updateItemProgress(context, constants.PROG55)
        if util.isCmdExecError(cliRets):
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, cliRets, context)
            util.updateItemProgress(context, constants.PROG95)
            LOGGER.info("query alua TOOLKIT_SEND_CMD_TIME_OUT")
            return CHECK_PASS, cmd_display, errMsg
        multiPathInfo = cliRets.lower()
        if "'mpclaim'" in multiPathInfo or '"mpclaim"' in multiPathInfo:
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, cliRets, context)
            util.updateItemProgress(context, constants.PROG95)
            LOGGER.info("query alua not support")
            return CHECK_PASS, cmd_display, errMsg
        if "huawei" not in multiPathInfo:
            util.updateItemProgress(context, constants.PROG95)
            contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, cliRets, context)
            LOGGER.info("query alua no huawei disk")
            return CHECK_PASS, cmd_display, errMsg
        diskCfgs = multiPathInfo.splitlines()
        patternActive = re.compile(r'implicit only|implicit and explicit|huawei')
        for line in diskCfgs:
            diskCfgLine = line.replace(u'不支持 ALUA', 'ALUA Not Supported')
            diskCfgLine = diskCfgLine.replace(u'仅隐式', 'implicit only')
            diskCfgLine = diskCfgLine.replace(u'隐式和显式', 'implicit and explicit')
            diskCfgLine = diskCfgLine.replace(u'是', 'yes')
            LOGGER.info("diskCfgLine" + diskCfgLine)
            if "yes" not in diskCfgLine:
                continue
            result1 = patternActive.findall(diskCfgLine)
            if len(result1) == ALL_MATCHED:
                LOGGER.info("result1" + str(result1))
                contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_ENABLED, cliRets, context)
                util.updateItemProgress(context, constants.PROG95)
                LOGGER.info("query alua have huawei disk enabled")
                return CHECK_PASS, cmd_display, errMsg
        contentParse.saveAluaStatusAndCliRet2ForeEval(ALUA_NOT_ENABLED, cliRets, context)
        util.updateItemProgress(context, constants.PROG95)
        LOGGER.info("query alua have huawei disk not enabled")
        return CHECK_PASS, cmd_display, errMsg
    except:
        msg = traceback.format_exc()
        LOGGER.error("execute alua configure info ==> " + msg)
        saveAluaStatusAndCliRet2ForeEval(ALUA_UNKNOW, cliRets, context)
        return CHECK_PASS, cmd_display, errMsg

