#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import BaseCmdExecute, DES, CMD

CMD_LIST = [
    {DES: "cmd_display_tcp_ip_connection_count", CMD: "netstat -n | find /C /I \"established\"", },
    {DES: "cmd_display_net_user", CMD: "net user"},
    {DES: "cmd_display_net_localgroup", CMD: "net localgroup"},
    {DES: "cmd_display_net_use", CMD: "net use"},
]

NET_USE_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_dir_sad_", CMD: "dir /S /a-d %s", },
    {DES: "cmd_display_dir_find_", CMD: "dir /b %s |find /v /c \"::\""},
    {DES: "cmd_display_tree_", CMD: "tree %s"},
    {DES: "cmd_display_ps1_", CMD: "dir /s %s *.ps1"},
]


def execute(context):
    NasBasicInfo(context).execute()


class NasBasicInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        """
        类的执行入口
        """
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(self.get_net_use_list(), NET_USE_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_net_use_list(self):
        """
        获取windows主机的挂载盘符
        :return: 数据
        """
        cmd = "net use"
        net_use_info = self.cli.execCmd(cmd)
        result = []
        for line in net_use_info.splitlines():
            items = line.split()
            if len(items) > 2 and ":" in items[1]:
                result.append((items[1],))
        return result
