#coding=utf-8

__author__ = '******'
#获取主机上数据库的一些基本信息，如版本号.

import traceback
from common import util
from common import constants

cmd_info_no_jdbc_id = [
    "cmd_info_database_basic_asmtool",
    "cmd_info_database_basic_crsctl",
    "cmd_info_database_basic_olsnodes",
    "cmd_info_database_basic_cemutlo",
    "cmd_info_database_basic_scan",
    "cmd_info_database_basic_nodeapps"
]

cmd_info_no_jdbc_desc = [
    "asmtool -list",
    "crsctl check cluster",
    "olsnodes -s",
    "cemutlo -n",
    "srvctl config scan",
    "srvctl config nodeapps"
]

cmd_info_jdbc_id = [
    "cmd_info_database_basic_local_listener",
    "cmd_info_database_basic_instance",
    "cmd_info_database_basic_vsersion",
    "cmd_info_database_basic_asm_diskgroup",
    "cmd_info_database_basic_x$ksppi_x$ksppcv",
    "cmd_info_database_basic_asm_disk"
]

cmd_info_jdbc_desc = [
    "select NAME,VALUE from v$parameter where NAME like 'local_listener';",
    "select instance_name,host_name from v$instance;",
    "select * from v$version;",
    "select group_number gno,name,state,type,total_mb,free_mb,sector_size from v$asm_diskgroup;",
    "select a.ksppinm name,b.ksppstvl value,a.ksppdesc describe from x$ksppi a,x$ksppcv b"
    " where a.inst_id=userenv('instance') and b.inst_id=userenv('instance') and a.indx=b.indx"
    " and a.ksppinm like '\_asm_hbeatio%' escape '\\\';",
    "select name,path,group_number,disk_number,mount_status,header_status,mode_status,state,"
    "sector_size from v$asm_disk;"
]

CLI = None
LANGUAGE = None
CHECK_FAIL = 0
CHECK_PASS = 1
logger = None


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    global logger
    logger = context.get("Logger") 
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")

    try:
        return cmd_execute_main(cmd_display, CLI, context)
    except:
        logger.error("the except info is:" + traceback.format_exc())
        return cmd_display


def cmd_execute_main(cmd_display, CLI, context):
    
    fun_err_msg = ''
    fun_err_msg_temp = ''
    curstep = constants.PROG5
    util.updateItemProgress(context, curstep)
    # oracle信息采集
    fun_err_msg += cmd_oracle_execute(CLI, cmd_display, fun_err_msg_temp)
    util.updateItemProgress(context, constants.PROG90)
    
    cmd_display.put("err_msg", fun_err_msg)
    return cmd_display


# 查询oracle数据库信息
def cmd_oracle_execute(CLI, cmd_display, fun_err_msg_temp):
    cmd_display_temp = CLI.execCmd("sc query | findstr \"ASM\"")
    cmd_display.put("cmd_display_database_findstr_asm", cmd_display_temp)
    fun_err_msg_temp += deal_fun_err_msg(cmd_display_temp, "sc query | findstr \"ASM\"", fun_err_msg_temp)
    
    #获取SERVICE_NAEM值
    splitlines = cmd_display_temp.splitlines()
        
    for line in splitlines:
        if "SERVICE_NAME" in line:
            splits = line.strip().split(":")
            servicename = splits[len(splits) - 1].strip()
            
            cmd_display_temp = CLI.execCmd("sc qc " + servicename)
            logger.info("sc qc " + servicename)
            cmd_display.put("sc qc " + servicename, cmd_display_temp)
            fun_err_msg_temp += deal_fun_err_msg(cmd_display_temp, "sc qc " + servicename, fun_err_msg_temp)
            logger.info(cmd_display_temp)
            sn_splitlines = cmd_display_temp.splitlines()
            for sn_line in sn_splitlines:
                
                if "bin\ORACLE.EXE" in sn_line:
                    logger.info(sn_line)
                    bpn_splits = sn_line.strip().split()
                    bpn_split = bpn_splits[len(bpn_splits) - 2].strip()
                    #获取oracle_home值
                    ORACLE_HOME = bpn_split[0:bpn_split.find("bin\ORACLE.EXE")]
                    #获取oracle_sid值
                    ORACLE_SID = bpn_splits[len(bpn_splits) - 1].strip()
                    ORACLE_HOME_BIN = ORACLE_HOME + "bin"
                    logger.info(ORACLE_SID)
                    logger.info(ORACLE_HOME_BIN)

                    CLI.execCmd("cd " + ORACLE_HOME_BIN)
                    cmd_info_no_jdbc_dic = dict(zip(cmd_info_no_jdbc_id,cmd_info_no_jdbc_desc))
                    fun_err_msg_temp += cmd_execute(cmd_display, CLI, cmd_info_no_jdbc_dic)
                    
                    #设置环境变量，进入数据库模式
                    oracle_sid_str = "export ORACLE_SID=" + ORACLE_SID
                    oracle_home_str = "export ORACLE_HOME=" + ORACLE_HOME
                    
                    CLI.execCmd(oracle_sid_str)
                    CLI.execCmd(oracle_home_str)
                    cmd_display_temp = CLI.execCmd("sqlplus / as sysasm")
                    
                    #设置sql回显参数格式
                    CLI.execCmd("set linesize 1000")
                    CLI.execCmd("col path for a40")
                    CLI.execCmd("col name for a20")
                    CLI.execCmd("col path for a50")
                    CLI.execCmd("col value for a20")
                    CLI.execCmd("col describe for a100")
                    
                    cmd_info_jdbc_dic = dict(zip(cmd_info_jdbc_id,cmd_info_jdbc_desc))
                    fun_err_msg_temp += cmd_execute(cmd_display, CLI, cmd_info_jdbc_dic)
                    
    return fun_err_msg_temp



# 查询db2数据库信息
def deal_fun_err_msg(cmd_display_temp, cmd, fun_err_msg):
    
        if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
            if "en" == LANGUAGE:
                fun_err_msg = cmd + ":\texecute failed\r\n"
            else:
                fun_err_msg = cmd + u":\t执行失败\r\n"
        else:
            if "en" == LANGUAGE:
                fun_err_msg = cmd + ":\texecute success\r\n"
            else:
                fun_err_msg = cmd + u":\t执行成功\r\n"
        
        return fun_err_msg



def cmd_execute(cmd_display, CLI, cmd_info_dict):
    if len(cmd_info_dict) > 0:
        fun_err_msg = ''

        for cmd_info_id,cmd_info_desc in cmd_info_dict.items():
            cmd_display_temp = CLI.execCmd(cmd_info_desc)
            logger.info(cmd_info_desc)
            cmd_display.put("cmd_display" + cmd_info_id[8:], cmd_display_temp)
            if None == cmd_display_temp or '' == cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                    or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc + ":\texecute failed\r\n"
                else:
                    fun_err_msg += cmd_info_desc + u":\t执行失败\r\n"
            else:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd_info_desc + ":\texecute success\r\n"
                else:
                    fun_err_msg += cmd_info_desc + u":\t执行成功\r\n"
        return  fun_err_msg
    else:
        return ""
