# coding=utf-8
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common.contentParse import getCommandRet #执行多条命令
from common import util
from common import constants
LOG = None

cmdInfoId = []
cmdInfoDesc = []

QLOGIC_TYPE = 0
EMULEX_TYPE = 1


WWPN = 'wwpn'
TMO_ARG = 'tmoArg'

#未安装插件 超时参数
UNKNOWN = 'Unknown'

 
QLOGIC = 'Qlogic'
EMULEX = 'Emulex'


def hbaTmoExecute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    global LOG
    LOG = context.get("Logger")
    devType = context.get('dev_type')
    
    checkHbaInfo(context, devType)
    return context.get("ret_map")

    
#大致步骤
#1.根据命令构造  HbaCardInfoDict   
#2.构造字典列表
#3.保存数据到全局上下文
    
def checkHbaInfo(context, devtype):
    hasQcard = False
    hasEcard = False
    HbaCardInfoList = []    
    
    hbaInfoLines = []
    
    if isWin2012or2016(devtype):
        util.updateItemProgress(context,constants.PROG30)
        injectOneCmdRet(context, 'cmd_info_win1216_hbainfo', 'powershell Get-WmiObject -Class MSFC_FCAdapterHBAAttributes -Namespace root\\WMI')
        hbaInfoRet = getCmdPureRet(context, "cmd_info_win1216_hbainfo")
        hbaInfoLines = hbaInfoRet.splitlines()
    
    if isWin2008(devtype):
        util.updateItemProgress(context,constants.PROG30)
        injectOneCmdRet(context, 'cmd_info_win2008_hbainfo', 'winrm e wmi/root/wmi/MSFC_FCAdapterHBAAttributes')
        hbaInfoRet = getCmdPureRet(context, "cmd_info_win2008_hbainfo")
        hbaInfoLines = hbaInfoRet.splitlines()
        
    util.updateItemProgress(context,constants.PROG40)
    #步骤1：检查服务器上hba卡的类型
    hasQcard, hasEcard = hasQlogicEmulexCard(hbaInfoLines)
    util.updateItemProgress(context,constants.PROG50)
    #如果E卡 Q卡都没有则直接退出检查 此时为超时参数字段为:NA
    if (not hasQcard) and (not hasEcard):
        return 
    
    #求Q卡超时参数采集
    if hasQcard:
        LOG.info('this server has Qlogic Card. begin collect hba tmo args.')
        #步骤2：检查Q卡插件 
        #步骤3：采集Q卡超时参数
        hbaEval = QlogicEval(context)
        HbaCardInfoList.extend(hbaEval.doEval())
        util.updateItemProgress(context,constants.PROG70)
    #求E卡超时参数采集
    if hasEcard:
        LOG.info('this server has Emulex Card. begin collect hba tmo args.')
        hbaEval = EmulexEval(context)
        HbaCardInfoList.extend(hbaEval.doEval())
        util.updateItemProgress(context,constants.PROG90)
    #如果没有可以的hba卡则不保存，超时参数信息，即返回NA
    if HbaCardInfoList:
        LOG.info('str(HbaCardInfoList) = ' + str(HbaCardInfoList).replace("u\'", "\'"))
        saveHbaTmoRet(context, str(HbaCardInfoList).replace("u\'", "\'"))
        util.updateItemProgress(context,constants.PROG95)
    
def hasQlogicEmulexCard(hbaInfoLines):
    '''
    @summary: 检查是否有Q卡和E卡
    '''
    hasQcard = False
    hasEcard = False
    if not hbaInfoLines:
        LOG.info("hba card ret is None or empty.")
        return hasQcard, hasEcard
    
    #步骤1：检查服务器上hba卡的类型
    for line in hbaInfoLines:
        if line.lower().strip().startswith("manufacturer"):
            if 'qlogic' in line.lower():
                LOG.info('win12or16 has Q Card.')
                hasQcard = True
                continue
            elif 'emulex' in line.lower():
                hasEcard = True
    return hasQcard, hasEcard
    

class EmulexEval(object):
    '''
    @summary: Emulex 卡采集
    '''
    hbaObjLst = []
    hbaDictLst = []
    
    hbaCardPlugCmd = "hbacmd"
    hbaCardCmdCommon = ""
    
    def __init__(self, context):
        self.context = context
        #查询E卡基本信息的命令
        self.hbaCardBasicCmd = self.creatCmdDesc("hbacmd listhbas")
        
    
    def isSimulator(self,context):
        try:
            return context.get("isSimulator")
        except:
            util.log.info(context,"context has no isSimulator key")
            return False
        
    
    def doEval(self):
        #检查插件信息前，先看看目录是否存在
        if self.hasPlug():
            #有插件则继续进行检查
            self.evalTask(self.context)
            return self.hbaDictLst
        else:
            #无插件则退出检查，并报不通过
            LOG.info("this server has no Emulex plug.")
            self.hbaDictLst.append(buildHbaCardInfoDictByTmoModel(UNKNOWN, EMULEX))
            return self.hbaDictLst
        
        return self.hbaDictLst 
    
    def evalTask(self, context):
        self.injectHabBasicInfo(context)
        #过滤掉不在线的端口
        self.checkHbaByState(context)
        self.injectHbaTmoInfo(self.context)
        
        for hba in self.hbaObjLst:
            self.hbaDictLst.append(buildHbaCardInfoDict(hba))
    
    def checkHbaByState(self,context):
        '''
        @summary: 过滤掉状态不为Operational的端口
        '''
        stateLst = []
        
        for hba in self.hbaObjLst:
            state = self.getStateByWwpn(hba.getPortWwn(),context)
            hba.setStatus(state)
            stateLst.append(state)
        
        for statu,hba in zip(stateLst,self.hbaObjLst):
            if ('operational' != statu.lower().strip()):
                self.hbaObjLst.remove(hba)
                hba.setStatus(self.getStateByWwpn(hba.getPortWwn(),context))
        
        
    def getStateByWwpn(self, wwpn,context):
        state = 'NA'
        wwpnStateCmd = self.creatCmdDesc("hbacmd PortAttributes " , wwpn)
        LOG.info('wwpnStateCmd = ' + wwpnStateCmd)
        
        injectOneCmdRet(self.context, 'cmd_info_eCard_wwpn_state' + wwpn, wwpnStateCmd)
        stateLines = getCmdPureRet(self.context, 'cmd_info_eCard_wwpn_state' + wwpn).splitlines()
        
        for line in stateLines:
            if line.strip().lower().startswith('port state'):
                state = line.split(':')[-1].strip()
                break
        util.log.info(context,"Emulex card tmo = " + state)
        return state
            
        
    def injectHabBasicInfo(self, context):
        '''
        @summary: 求wwpn 、model等基本信息
        '''
        injectOneCmdRet(context, 'cmd_info_ecard_hbaBasic_info', self.hbaCardBasicCmd)
        basicLines = getCmdPureRet(context, 'cmd_info_ecard_hbaBasic_info').splitlines()
        
        basicLst = splitLstByTag(basicLines, "Port WWN")
        
        for hbaLst in basicLst:
            
            hba = EmulexHbaInfo(hbaLst)
            self.hbaObjLst.append(hba)
        
            
    def injectHbaTmoInfo(self, context):
        '''
        @summary: 向每个hba卡对象中注入超时时间
        '''
        for hba in self.hbaObjLst:
            cmdId = "cmd_info_ecard_hbaTmo_info_" + hba.getPortWwn()
            cmdDesc = self.creatCmdDesc("hbacmd getdriverparams " , hba.getPortWwn())
            
            #执行查询超时参数的命令，并将回显保存到html中
            injectOneCmdRet(self.context, cmdId, cmdDesc)
            
            hbaTmoRet = getCmdPureRet(context, cmdId)
            hba.setTmo(self.getHbaTmoByRet(hbaTmoRet)) 

    
    def creatCmdDesc(self, cmd, str=''):
        '''
        @summary: 因为模拟器和真实环境某些命令不一样，需要区分
        '''
        if self.isSimulator(self.context):
            util.log.info(self.context,"create simulator cmd.")
            return cmd + str
        else :
            util.log.info(self.context,"create true dev cmd.")
            return self.hbaCardCmdCommon + cmd + str
        

    def getHbaTmoByRet(self, hbaTmoRetParm):
        '''
        @summary: 根据回显获取超时参数
        '''
        
        hbaTmoRetLines = hbaTmoRetParm.splitlines()
            
        curIdx = 0 
        timeOut = ''
        linkTimeOut = ''
        nodeTimeOut = ''
        for line in hbaTmoRetLines:
            if 'cur' in line.lower():
                lst = line.split()
                for i, temp in enumerate(lst):
                    if 'cur' == temp.lower():
                        curIdx = i
                        break
            try:
                if 'linktimeout' in line.lower():
                    linkTimeOut = line.split()[curIdx]
                    #转成十进制
                    linkTimeOut = int('0x' + linkTimeOut , 16)
                    linkTimeOut = str(linkTimeOut)
                    continue
                if 'nodetimeout' in line.lower():
                    nodeTimeOut = line.split()[curIdx]
                    nodeTimeOut = int('0x' + nodeTimeOut , 16)
                    nodeTimeOut = str(nodeTimeOut)
            except:
                LOG.info('get time out failed.')
                
        timeOut = 'linkTimeOut:' + linkTimeOut + ',' + 'nodeTimeOut:' + nodeTimeOut     
        return timeOut
                
    
    def buildHbaDicts(self):
        for hba in self.hbaObjLst:
            self.hbaDictLst.append(buildHbaCardInfoDict(hba))
        
    
    def hasPlug(self):
        '''
        @summary: 检查是否有插件
        '''
        injectOneCmdRet(self.context, 'cmd_info_ecard_hbaPlug_info', self.hbaCardPlugCmd)
        plugLines = getCmdPureRet(self.context, 'cmd_info_ecard_hbaPlug_info').splitlines()
            
        for line in plugLines:
            if not line.strip():
                continue
            if 'no command specified!' in line.lower():
                return True
        LOG.info('has no Emulex Plug.')
        
        return False



class QlogicEval(object):
    '''
    @summary: Qlogic 卡采集
    '''
    hbaObjLst = []
    
    hbaDictLst = []
    
    def __init__(self, context):
        self.context = context
    
    def doEval(self):
        injectOneCmdRet(self.context, 'cmd_info_qcard_hbaPlug_info', 'qaucli -v')
        plugLines = getCmdPureRet(self.context, 'cmd_info_qcard_hbaPlug_info').splitlines()
        
        if plugLines and (len(plugLines) > 1) and ('qlogic' not in plugLines[1].lower()):
            #无插件则退出检查
            LOG.info('this server has no Qlogic Plug.')
            self.hbaDictLst.append(buildHbaCardInfoDictByTmoModel(UNKNOWN, QLOGIC))
            return self.hbaDictLst
        else:
            LOG.info('this server has Qlogic Plug. Now begin eval.')
            self.evalTask(self.context)
            return self.hbaDictLst 
    
    
    def evalTask(self, context):
        
        injectOneCmdRet(context, 'cmd_info_qcard_hbabasic_info', 'qaucli -i')
        injectOneCmdRet(context, 'cmd_info_qcard_hbatmo', 'qaucli -c')
        
        basicInfoRetLines = getCmdPureRet(context, 'cmd_info_qcard_hbabasic_info').splitlines()
        tmoInfoRetLines = getCmdPureRet(context, 'cmd_info_qcard_hbatmo').splitlines()
        
        #把hba卡回显分成一段一段回显，每段回显代表一个hba卡
        basicLst = splitLstByTag(basicInfoRetLines, "hba model")
        tmoRetLst = splitLstByTag(tmoInfoRetLines, "hba instance")

        self.injectHbaBasicInfo(basicLst) 
        self.injectHbaTmoInfo(tmoRetLst)
                
    
    def injectHbaBasicInfo(self, basicRetLst):
        if not basicRetLst:
            LOG.info('basicRetLst is []')
            
        for basicLst in basicRetLst:
            #状态
            status = ''
            for line in basicLst:
                if(line.lower().strip().startswith("hba status"))and (':' in line.lower()):
                    status = line.split(':')[-1].strip()
                    break
            #只取状态为非link down的hba卡
            if 'link down' != status.lower():
                # 型号、wwpn、驱动、固件、状态 
                hbaObj = QlogicHbaInfo(basicLst)
                hbaObj.setStatus(status)
                self.hbaObjLst.append(hbaObj)
    
    
    def injectHbaTmoInfo(self, tmoRetLstParm):
        #超时时间
        tmoDicLst = []
        wwpnTmo = ''
        tmoArg = ''
        for tmoLst in tmoRetLstParm:
            for line in tmoLst:
                #wwpn
                if ('hba instance' in line.lower()) and ('wwpn' in line.lower()):
                    line = line.lower()
                    wwpn = line.lower()[line.index('wwpn') + 4:]
                    
                    wwpnTmo = wwpn.split()[0].strip()
                    continue
                #超时参数
                if ('link down timeout' in line.lower()) and (':' in line):
                    tmoArg = line.split(':')[-1].strip()
            
            tmoWwpnDic = {}
            tmoWwpnDic[TMO_ARG] = tmoArg
            tmoWwpnDic[WWPN] = str(wwpnTmo)
        
            tmoDicLst.append(tmoWwpnDic)
        
        #超时时间  与  基本信息（型号、驱动...） 通过wwpn关联
        for hba in self.hbaObjLst:
            for tmoDic in tmoDicLst:
                if hba.getPortWwn().lower() == tmoDic[WWPN].lower():
                    hba.setTmo(tmoDic[TMO_ARG])
                    break
            self.hbaDictLst.append(buildHbaCardInfoDict(hba))
        
    
def isWin2012or2016(devTypeParm):
    LOG.info('devTypeParm = ' + devTypeParm)
    if ('2012' in devTypeParm) or ('2016' in devTypeParm):
        return True
    return False

def isWin2008(devTypeParm):
    LOG.info('devTypeParm = ' + devTypeParm)
    if '2008' in devTypeParm:
        return True
    return False


def buildHbaCardInfoDict(hbaObj):
    '''
    @summary: 根据hba卡回显生成hba字典
    '''
    hbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
    
    if not hbaObj:
        return hbaCardInfoDict
    
    hbaCardInfoDict['WWPN'] = hbaObj.getPortWwn()
    hbaCardInfoDict['HBADriver'] = hbaObj.getDriVersion()
    hbaCardInfoDict['Timeout'] = hbaObj.getTmo()
    hbaCardInfoDict['HBAModel'] = hbaObj.getModel()
    
    return hbaCardInfoDict

def buildHbaCardInfoDictByTmoModel(timeOut, model):
    hbaCardInfoDict = {"WWPN":"NA", "HBADriver":"NA", "Host":{"PortID":"NA", "HBAName":"NA"}, "Timeout":"Error", "HBAModel":"NA"}
    hbaCardInfoDict['Timeout'] = timeOut
    hbaCardInfoDict['HBAModel'] = model
    return hbaCardInfoDict

class HbaInfo(object):  
    portWwn = 'NA'
    snNo = 'NA'
    model = 'NA'
    driverVersion = 'NA'
    fwVersion = 'NA'
    status = 'NA'
    tmo = 'Error'
    
    hbaType = 'NA'
    
    def setPortWwn(self, wwn):
        self.portWwn = wwn
    def setSnNo(self, snNo):
        self.snNo = snNo
    def setModel(self, model):
        self.model = model
    def setHbaType(self, type):
        self.hbaType = type
    def setDriVersion(self, version):
        self.driverVersion = version
    def setFwVersion(self, version):
        self.fwVersion = version
    def setStatus(self, statu):
        self.status = statu
    def setTmo(self, tmoArgs):
        self.tmo = tmoArgs
        
    def getPortWwn(self):
        return self.portWwn
    def getSnNo(self):
        return self.snNo
    def getModel(self):
        return self.model
    def getThisType(self):
        return self.hbaType
    def getDriVersion(self):
        return self.driverVersion
    def getFwVersion(self,):
        return self.fwVersion
    def getStatus(self):
        return self.status
    def getTmo(self):
        return self.tmo
    

class QlogicHbaInfo(HbaInfo):
    '''@summary: 根据回显生成Q卡对象,包含型号、fw型号、wwpn等值'''
    
    basics = []
    
    
    def __init__(self, basicLst):
        '''
        @summary: 构造方法
        @param basicLst: 基本信息回显，包含型号、驱动
        @param tmoLst: 包含超时参数的回显  
        '''
        super(QlogicHbaInfo, self).setHbaType(QLOGIC_TYPE)
        if basicLst:
            self.basics = basicLst
        else:
            LOG.info('basicLst or tmoLst is None or empty.')
        self.initBasicInfo()
    
    def initBasicInfo(self):
        #求得：型号、wwpn、驱动、固件
        if not self.basics:
            return
        
        for line in self.basics:
            #型号
            if (line.lower().strip().startswith('hba model')) and (':' in line):
                super(QlogicHbaInfo, self).setModel(line.split(':')[-1].strip())
                continue
            #wwpn
            elif (line.lower().strip().startswith('port name')) and (':' in line):
                super(QlogicHbaInfo, self).setPortWwn(line.split(':')[-1].strip())
                continue
            #驱动版本
            elif (line.lower().strip().startswith('driver version')) and (':' in line):
                super(QlogicHbaInfo, self).setDriVersion(line.split(':')[-1].strip())
                continue
            #fw版本
            elif (line.lower().strip().startswith('firmware version')) and (':' in line):
                super(QlogicHbaInfo, self).setFwVersion(line.split(':')[-1].strip())
            
    
    def setTmoInfo(self, tmoLst):
        if not tmoLst:
            return
        
        for line in tmoLst:
            if (line.lower().strip().startswith('link down timeout')) and (':' in line):
                tmoArg = line.split(':')[-1].strip()
                super(QlogicHbaInfo, self).setTmo(str(tmoArg))
                
    def getInfo(self):
        return "model = " + self.getModel() + ' wwpn = ' + self.getPortWwn() + ' dr =' + self.getDriVersion() + ' fw =' + self.getFwVersion() 
                

class EmulexHbaInfo(HbaInfo):
    hbaLst = []
    def __init__(self, lst):
        super(EmulexHbaInfo, self).setHbaType(EMULEX_TYPE)
        if not lst:
            return
        
        self.hbaLst = lst
        self.initInfo()
    
    def initInfo(self):
        if not self.hbaLst:
            return 
        
        for line in self.hbaLst:
            if (line.lower().strip().startswith('port wwn')) and (':' in line):
                super(EmulexHbaInfo, self).setPortWwn(line.split()[-1].strip())
                continue
            
            if (line.lower().strip().startswith('serial no')) and (':' in line):
                super(EmulexHbaInfo, self).setSnNo(line.split()[-1].strip())
                continue
            if (line.lower().strip().startswith('model')) and (':' in line):
                super(EmulexHbaInfo, self).setModel(line.split()[-1].strip())
                
    def getInfo(self):
        return "model = " + self.getModel() + ' wwpn = ' + self.getPortWwn() + ' dr =' + self.getDriVersion() + ' fw =' + self.getFwVersion()


#公共代码    
def injectOneCmdRet(context, cmdId, cmdDesc):
    funErrMsgOld = context.get("ret_map").get("err_msg")

    #检查是否有相关路径，如无相关路径，则需要带上路径执行
    
    funErrMsgNew = getSingleWinCommandRet(context, cmdId, cmdDesc).get("err_msg")
    
    context.get("ret_map").put('err_msg', funErrMsgOld + funErrMsgNew)

def injectMoreCmdsRet(context, cmdIds, cmdDescs):
    for (cmd, desc) in zip(cmdIds, cmdDescs):
        injectOneCmdRet(context, cmd, desc)
        
        
def saveHbaTmoRet(context, cmdInfoRet):
    if len(cmdInfoRet) > 5:
        context.get("ret_map").put("HBA_timeout_result_information", "HBA_timeout_information \r\n" + cmdInfoRet)
        
def getSingleWinCommandRet(context, cmdInfoId, command):
    funErrMsg = ''
    CLI = context.get("SSH")
    LANGUAGE = context.get("lang")
    
    cmdDisplayTemp = CLI.execCmdHasLog(command)
    
    if cmdInfoId.startswith ('cmd_info'):     
        context.get("ret_map").put(getCmdIdKey(cmdInfoId), cmdDisplayTemp)
    if None == cmdDisplayTemp or '' == cmdDisplayTemp or cmdDisplayTemp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or cmdDisplayTemp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            funErrMsg += command + ":\texecute failed\r\n"
        else:
            funErrMsg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            funErrMsg += command + ":\texecute success\r\n"
        else:
            funErrMsg += command + u":\t执行成功\r\n"
            
    context.get("ret_map").put("err_msg", funErrMsg)

    return context.get("ret_map")    

def getCmdIdKey(cmdId):
    if cmdId.startswith('cmd_info'):
        return "cmd_display" + cmdId[8:]
    return ''

def getCmdPureRet(context, cmd):
    result = ""
    
    try:
        result = context.get("ret_map").get(getCmdIdKey(cmd))
    except:
        LOG.info('getCmdPureRet cmd')
    return result
    

def splitLstByTag(lst, tagArg):
    '''
    @summary: 根据钩子对列表进行分片
    '''
    startIdxLst = []
    endIdxLst = []
    splitLst = []
    if not lst:
        return splitLst
    
    for idx, line in enumerate(lst):
        if getIndexByTag(line, tagArg):
            startIdxLst.append(idx)
    
    endIdxLst = startIdxLst[1:]
    endIdxLst.append(len(lst))
    
    for idx, idx2 in zip(startIdxLst, endIdxLst):
        splitLst.append(lst[idx - 1:idx2])
    return splitLst
            
#hba model   
def getIndexByTag(line, tag):
    if not line:
        return False
    if tag.lower() in line.lower():
        return True
    return False 

