# coding=utf-8
'''
    DocStr: collect HyperMetro feature configuration on windows server host
    Since: V3R1C00RC2
'''
import os
import sys
CURRENT_PATH = os.path.dirname(os.path.abspath(__file__))
sys.path.append(CURRENT_PATH)
CURRENT_PATH = os.path.join(CURRENT_PATH, "..\\..")
sys.path.append(CURRENT_PATH)

from common import util
from common import contentParse
from common import constants

SYSTEMINFO_CMD_MAP = {'id':'windows_system_info' ,
                      'cmd' : r'wmic OS Get Version /value '}
MPIOCHECK_CMD_MAP_OLD = {'id':'windows_path_verification_item' ,
           'cmd' : r'powershell Get-ItemProperty "HKLM:\System\CurrentControlSet\Services\msdsm\Parameters"'}
MPIOCHECK_CMD_MAP_NEW = {'id':'windows_path_verification_setting' ,
                         'cmd' : r'powershell Get-MPIOSetting'}

def execute(context):
    '''
    Function describe  : collect windows host HyperMetro information
    Return             : cmd display
    '''
    windowsHyperMetroChecker = WindowsHyperMetroChecker(context)
    return windowsHyperMetroChecker.evaluate()


class WindowsHyperMetroChecker(object):
    '''
    @summary: collect HyperMetro feature configuration on windows server host
    '''

    def __init__(self, context):
        '''
        @summary: constructor
        '''
        self.context = context
        self.wmic_con = context.get("SSH")
        self.lang = context.get("lang")
        self.cmd_display = context.get("ret_map")

    def evaluate(self):
        '''
        @summary: evaluation entrance
        '''
        resultStatus = ""
        util.updateItemProgress(self.context, constants.PROG5)
        util.log.info(self.context, "[windows] start to fetch hyperMetro configuration.")
        cmdEcho = self.wmic_con.execCmd(SYSTEMINFO_CMD_MAP['cmd'])
        util.updateItemProgress(self.context, constants.PROG35)
        self.cmd_display.put("cmd_display_" + SYSTEMINFO_CMD_MAP['id'], cmdEcho)

        result, resultTip = self.getResultMsg(SYSTEMINFO_CMD_MAP['cmd'], cmdEcho)
        resultStatus += resultTip
        if not result:
            self.cmd_display.put("err_msg", resultStatus)
            util.updateItemProgress(self.context, constants.PROG90)
            return self.cmd_display
        isParseSuc, isUsingOldCmd = self.parseOsVersionFromSysInfo(cmdEcho)
        if not isParseSuc:
            self.cmd_display.put("err_msg", resultStatus)
            util.updateItemProgress(self.context, constants.PROG90)
            return self.cmd_display

        if isUsingOldCmd:
            util.log.info(self.context, "[windows] OS version's lower than win8 or 2012.")
            cmdEchos = self.wmic_con.execCmd(MPIOCHECK_CMD_MAP_OLD['cmd'])
            util.updateItemProgress(self.context, constants.PROG75)
            self.cmd_display.put("cmd_display_" + MPIOCHECK_CMD_MAP_OLD['id'], cmdEchos)
            resultStatus += self.getResultMsg(MPIOCHECK_CMD_MAP_OLD['cmd'], cmdEchos)[1]
        else:
            util.log.info(self.context, "[windows] OS version's upper than win8 or 2012.")
            try:
                cmdEchos = self.wmic_con.executeCmdTimeoutLcalWmic(MPIOCHECK_CMD_MAP_NEW['cmd'], 60)
            except :
                cmdEchos = self.wmic_con.execCmd(MPIOCHECK_CMD_MAP_NEW['cmd'])
            util.updateItemProgress(self.context, constants.PROG75)
            self.cmd_display.put("cmd_display_" + MPIOCHECK_CMD_MAP_NEW['id'], cmdEchos)
            resultStatus += self.getResultMsg(MPIOCHECK_CMD_MAP_NEW['cmd'], cmdEchos)[1]
        util.updateItemProgress(self.context, constants.PROG80)
        self.cmd_display.put("err_msg", resultStatus)
        util.updateItemProgress(self.context, constants.PROG90)
        return self.cmd_display

    def parseOsVersionFromSysInfo(self, sysInfo):
        '''
        @summary: parse  OS version, if current version is below 6.2, using old command, otherwise using new command.
        @return isParseSuc, isUsingOldCmd
        '''

        for line in sysInfo.splitlines():
            if line.lower().startswith("version="):
                osVerLineList = line.split("=")
                osVersion = ""
                if len(osVerLineList) < 2:
                    break
                osVersion = osVerLineList[1]
                osVerParams = osVersion.split(".")
                #6.2.9200
                #| |   |--buildNumber
                #| |------minorVersion 
                #|--------majorVersion
                if len(osVerParams) < 2:
                    break
                majorVer = osVerParams[0]
                minorVer = osVerParams[1]
                if majorVer.isdigit() and int(majorVer) < 6:
                    return True, True
                elif majorVer.isdigit() and int(majorVer) == 6:
                    if minorVer.isdigit() and int(minorVer) < 2:
                        return True, True
                    elif minorVer.isdigit() and int(minorVer) >= 2:
                        return True, False
                elif majorVer.isdigit() and int(majorVer) > 6:
                    return True, False
            else:
                continue
        return False, ""

    def getResultMsg(self, step_name, cmd_display_temp):
        '''
        @summary: get result status's message
        '''
        result_msg = ""
        result = True
        if None == cmd_display_temp or '' == cmd_display_temp or\
            'TOOLKIT_SEND_CMD_TIME_OUT' in  cmd_display_temp or\
                'TOOLKIT_EXE_CMD_FAILED' in cmd_display_temp:
            result = False

        if "en" == self.lang:
            if result:
                result_msg += step_name + ":\texecute success\r\n"
            else:
                result_msg += step_name + ":\texecute failed\r\n"
        else:
            if result:
                result_msg += step_name + u":\t执行成功\r\n"
            else:
                result_msg += step_name + u":\t执行失败\r\n"


        return result, result_msg
