# coding=utf-8
__author__ = '******'
# 获取windows主机冗余路径的信息.
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult
import re
import traceback
from hosts.windows.windows_lun_wwn_info import get_result_info
from common import util
import common.constants as CONSTANT

CHECK_FAIL = 0
CHECK_PASS = 1

showVersionCommand = "upadm show version"

lowerShowVlunCommand = "upadm show vlun"

showVlunCommand = "upadm show vlun type=all"

#存储信息字典
multiInfo = {}

#query fail device or lun list
queryFailList = []

#用于保存执行失败的command
commandFailureList = []

#command execute result
executeCommandRet = []

#query vlun fail command
queryVlunFailCommand = []

cmd_list = [
    {"description": "cmd_display_power_version", "cmd": "powermt version"},
    {"description": "cmd_display_power_disks", "cmd": "powermt display dev=all"},
    {"description": "cmd_display_hdlm_version", "cmd": "dlnkmgr view -sys"},
    {"description": "cmd_display_hdlm_disks", "cmd": "dlnkmgr view -path"},
    {"description": "cmd_display_up_array", "cmd": "upadm show array"},
    {"description": "cmd_display_up_status", "cmd": "upadm check status"},
]


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    # 给全局变量赋初始值
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    util.log.info(context, "***[start executing windows info check]***")
    global IP
    IP = CLI.getIp()  
    cmd_display = context.get("ret_map")
    util.batch_execute(context, cmd_list, False)
    try:
        get_result_info(context)
        cmd_display = grabIscsiAndMpclainInfo(context)
        
        data = checkAndGetResult(context)
        
        #设置回显：{'HuaweiMultipathVersion': '', 'SelfMultiPath': ''}
        commandDesc = "cmd_display_windows_mulitipath_status_result_str"
        resultStr = str(makeMultipathInfo())
        util.log.info(context, "***[multipath status result is: " + resultStr + "]***")
        cmd_display.put(commandDesc, resultStr)
        
        #给evalResult设置
        cmd_display.put("evalResult", data[1])
        
        #结果成功or失败记录日志
        if data[0]:
            util.log.info(context, "***[evaluate pass]***")
        else:
            util.log.info(context, "***[evaluate failure]***")
    except :
        msg = traceback.format_exc()
        util.log.error(context, "windows multipath execute ==> " + msg)

def grabIscsiAndMpclainInfo(context):
    util.log.info(context, "***[start executing grabIscsiAndMpclainInfo()]***")
    
    commandDescGetIscsi = "windows_multipath_info_get_iscsitarget"
    commandGetIscsi = "powershell Get-IscsiTarget"
    
    commandDescGetMpioInfo = "windows_multipath_info_get_mpioinfo"
    commandGetMpioInfo = "mpclaim -e"
    
    commandDescGetMpclaimDiskinfo = "windows_multipath_info_get_mpiodiskinfo_"
    commandGetMpclaimDiskinfo = "mpclaim -s -d"    
    
    commandDescGetDiskinfoWithParmas = "windows_multipath_info_get_mpiodiskinfo_%s"
    commandGetDiskinfoWithParmas = "mpclaim -s -d %s "    
    
    cmd_display = context.get("ret_map")
    diskIdlist = []
    try:
        #单独采集不做处理        
        fun_flag, cmd_display, result = oneCmdExecute(commandGetIscsi, commandDescGetIscsi, cmd_display, context)
        fun_flag, cmd_display, result =oneCmdExecute(commandGetMpioInfo, commandDescGetMpioInfo, cmd_display, context)
        
        #采集且处理回显，用于命令拼接
        fun_flag, cmd_display, result = oneCmdExecute(commandGetMpclaimDiskinfo, commandDescGetMpclaimDiskinfo, cmd_display, context)

        #执行成功,解析diskID
        if fun_flag == CONSTANT.MAGIC_INT1:
            listStr = result.splitlines()

            for str in listStr:
                lstr = str.split()
                for ls in lstr:
                    if "disk" in ls.lower():
                        diskId = ls[4:]
                        if len(diskId) > 0 and diskId.isdigit():
                            diskIdlist.append(diskId)
                            
        util.log.info(context, "executing grabIscsiAndMpclainInfo diskIdlist : " + ",".join(diskIdlist))
        if len(diskIdlist) > 0:
            for diskId in diskIdlist:
                fun_flag, cmd_display, result = oneCmdExecute(commandGetDiskinfoWithParmas % diskId, commandDescGetDiskinfoWithParmas % diskId, cmd_display, context)
        #执行失败 
        else:
            util.log.error(context, "grabIscsiAndMpclainInfo ==> get mpclaim diskInfo is error.")
            
        return cmd_display
    except:
        msg = traceback.format_exc()
        util.log.error(context, "evaluateVlun ==> " + msg)
        return cmd_display  

def makeMultipathInfo():
    '''
    @summary: 构造多路径信息，评估使用
    '''
    dataDict = {}
    versionStr = 'NA'
    if multiInfo.has_key("version"):
        versionStr = str(multiInfo["version"])
    dataDict["HuaweiMultipathVersion"] = versionStr
    dataDict["SelfMultiPath"] = "disable"
    dataStr = str(dataDict)
    return dataStr

def checkAndGetResult(context):
    '''
    @summary评估，并返回评估结果
    @param context : 上下文
    '''
    util.log.info(context, "***[start executing checkAndGetResult()]***")
    ultraPathCheckRes = False
    result = None
    
    if hasMultipath(context):
        typeFlag = multiInfo["type"]
        #自研多路径
        if typeFlag == CONSTANT.ULTRA:
            util.log.info(context, "***[entry ultrapath]***")
            ultraPathCheckRes = ultraPathCheck(context)
        
        #evaluate fail
        if not ultraPathCheckRes:
            # show vlun命令失败
            if queryVlunFailCommand :
                evalMessage ="eval.host.multipath.reduntpath.donot.get.disk.information"
                paramList = [queryVlunFailCommand[0]]
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)
            #this condition is lun query fail or some lun not pass
            else:
                result = multiInfo["result"]
        
        else:
            result = multiInfo["result"]
    
    #不存在多路径，则评估不通过
    else:
        result = multiInfo["result"]
    util.updateItemProgress(context, CONSTANT.PROG90)
    return ultraPathCheckRes, result

def hasMultipath(context):
    '''
    @summary:判断是否安装了自研多路径(目前只涉及自研多路径)
    @param context : 上下文
    '''
    util.log.info(context, "***[start executing hasMultipath()]***")
    hasPathRes = False
    try:
        '''
        #不存在共存的场景
        #判断是否有自研多路径
        '''
        hasPathRes = hasUltrapath(context)
        util.log.info(context, "***[ultraFlag= " + str(hasPathRes) + "]***")

        if hasPathRes:
            util.log.info(context, "***[this windows has ultrapath]***")
            multiInfo["type"] = CONSTANT.ULTRA
        #多路径查询命令失败
        else:
            evalMessage = "eval.host.multipath.reduntpath.self.allnotexist"
            paramList = []
            result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)
            multiInfo["result"] = result
        
        return hasPathRes
    
    except:
        msg = traceback.format_exc()
        util.log.error(context, "hasMultipath ==> " + msg)
        return False
    
def hasUltrapath(context):
    '''
    @summary:判断是否有自研多路径
    @param context : 上下文
    '''
    util.log.info(context, "***[start executing hasUltrapath()]***")
    hasUltra = False
    command = showVersionCommand
    commandDesc = "windows_multipath_info_check_has_ultrapath"
    cmd_display = context.get("ret_map")
    pattern = "(\d+)\.(\d+)\.(\d+)"
    try:
        ret = oneCmdExecute(command, commandDesc, cmd_display, context)
        util.updateItemProgress(context, CONSTANT.PROG10)
        #save execute result
        executeCommandRet.append(ret[2])
        #检查是否oneCmdExecute执行成功
        if ret[0] == CONSTANT.MAGIC_INT1:
            lineList = ret[2].splitlines()
            for line in lineList:
                #如果有Software Version或者Driver Version,继续
                if (CONSTANT.SOFT_WARE_VERSION in line.lower()) or (CONSTANT.DRIVER_VERSION in line.lower()):
                    datas = line.strip().split(":")
                    util.log.info(context, "***[" + str(datas) + "]***")
                    if len(datas) > CONSTANT.MAGIC_INT1:
                        util.log.info(context, "***[version= " + datas[1] + "]***")
                        #如果满足0.0.0格式，取出存为“version”
                        if re.match(pattern, datas[1].strip()):
                            multiInfo["version"] = datas[1].strip()
                            hasUltra = True
                            break
        else:
            util.log.info(context, "***[command execute failure: " + command + "]***")
            commandFailureList.append(command)
            
        return hasUltra
    except:
        msg = traceback.format_exc() 
        util.log.error(context, "hasUltrapath ==> " + msg)
        return False

def ultraPathCheck(context):
    '''
    @summary:检查自研多路径
    @param context : 上下文
    '''
    util.log.info(context, "***[start executing ultraPathCheck()]***")
    global IP
    flag = False
    #自研多路径版本是否小于等于8.01.051
    isLowerVersion = checkVersion(context, multiInfo["version"])
    util.updateItemProgress(context, CONSTANT.PROG15)
    command = ""
    #不同版本的不同show vlun命令
    if isLowerVersion:
        command = lowerShowVlunCommand
    else:
        command = showVlunCommand
        
    commandDesc = "windows_multipath_info_check_ultrapath"
    cmd_display = context.get("ret_map")
    try:
        ret = oneCmdExecute(command, commandDesc, cmd_display, context)
        util.updateItemProgress(context, CONSTANT.PROG20)
        #save execute result
        executeCommandRet.append(ret[2])
        #vlun Id list
        vlunIdList = []
        #show vlun 命令执行成功
        if ret[CONSTANT.MAGIC_INT0] == CONSTANT.MAGIC_INT1 and ret[CONSTANT.MAGIC_INT2].find("Vlun ID") > CONSTANT.MAGIC_INT0:
            lineList = ret[CONSTANT.MAGIC_INT2].splitlines()
            #取出所有的VLun ID
            if len(lineList) > CONSTANT.MAGIC_INT2:
                tempList = lineList[CONSTANT.MAGIC_INT2:]
                for item in tempList:
                    item = item.strip()
                    #为空，则进入下一循环
                    if not item:
                        continue
                    items = re.split("\s+", item)
                    num = items[CONSTANT.MAGIC_INT0].strip()
                    #过滤掉"-----"这类行，且第一项为数字
                    if num.isdigit():
                        #转换成字符，便于直接拼接
                        vlunIdList.append(str(num))
                util.log.info(context, "***[total vlun size: " + str(len(vlunIdList)) + "]***")     
            
            #如果有vlunID，则开始对每个vlun进行评估
            execFail = False
            if vlunIdList:
                query_ret = util.query_show_path_info(context,
                                                      "upadm show path")
                executeCommandRet.append(query_ret)
                flag = evaluateVluns(vlunIdList, context, isLowerVersion)
            else:
                commandFailureList.append(command)
                return flag
            
            result = None
            
            #如果评估lun命令失败
            if queryVlunFailCommand:
                util.log.info(context, "***[query command fail]***")
                paramList = [queryVlunFailCommand[0]] 
                evalMessage = "eval.host.multipath.reduntpath.donot.get.disk.information"
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)
            
            #通过，PASSED
            if flag:
                evalMessage = ""
                paramList = []
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.PASSED, evalMessage, ''.join(executeCommandRet), paramList)
            #失败,FAILED
            else:
                util.log.info(context, "***[lun query fail]***")
                paramList = [str(IP), ','.join(queryFailList)] 
                evalMessage = "eval.host.multipath.reduntpath.ultrapath.donot.have.redundant.path"
                result = ItemEvalResult(CONSTANT.ITEM_KEY, EvalResultEnum.FAILED, evalMessage, ''.join(executeCommandRet), paramList)

            #将结果写入multiInfo
            multiInfo["result"] = result
        
        #show vlun 命令执行失败
        else:
            util.log.info(context, "***[command execute failure: " + command + " ]***")          
            commandFailureList.append(command)
            queryVlunFailCommand.append(command)
        return flag          
    except:
        msg = traceback.format_exc()
        util.log.error(context, "ultraPathCheck ==> " + msg)
        return False 
def checkVersion(context, version):
    '''
    @summary:检查自研多路径
    @param context : 上下文
    @param version : 多路径版本号
    @return: 是否小于等于8.01.051
    '''
    util.log.info(context, "***[start executing checkVersion()]***")
    #不需要判断version，因为能进方法已经做过判断
    ver = util.getUltrapathIntVer(context, version)
    lowerVer = util.getUltrapathIntVer(context, "8.01.051")
    if ver <= lowerVer:
        util.log.info(context, "***[the ultrapath version <= 8.01.051]***")
        return True
    else:
        util.log.info(context, "***[the ultrapath version > 8.01.051]***")
        return False
    
def oneCmdExecute(command, commandDesc, cmd_display, context):
    '''
    @summary:获取单一命令执行结果
    @param command : shell 命令
    @param commandDesc: 命令描述
    @param cmd_display: 保存结果的map
    @param CLI: SSH连接
    @param LANGUAGE: 语言类型
    '''
    global CLI
    global LANGUAGE
    fun_flag = CONSTANT.CHECK_FAIL
    fun_err_msg = cmd_display.get("err_msg")
    if not fun_err_msg:
        fun_err_msg = ""
    util.log.info(context, "***[execute command: " + command + "]***")
    if (CLI is None or LANGUAGE is None) and context is not None:
        CLI = context.get("SSH")
        LANGUAGE = context.get("lang")
    try:
        result = CLI.executeCmdTimeoutLcalWmic(command, 60)
    except :
        result = CLI.execCmd(command)    
    cmd_display.put("cmd_display_" + commandDesc, result)
    if None == result or '' == result or result.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 or result.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute failed\r\n"
        else:
            fun_err_msg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANGUAGE:
            fun_err_msg += command + ":\texecute success\r\n"
        else:
            fun_err_msg += command + u":\t执行成功\r\n"
        
        fun_flag = CONSTANT.CHECK_PASS 
    cmd_display.put("err_msg", fun_err_msg)
    util.log.info(context, "***[" + fun_err_msg + "]***")
    return fun_flag, cmd_display, result

def evaluateVluns(vlunList, context, isLowerVersion):
    '''
    @summary: 评估所有的vlun是否通过
    @param vlunList : vlunID 
    @param context : 上下文
    @param isLowerVersion : 自研多路径版本是否小于等于8.01.051
    '''
    util.log.info(context, "***[start executing evaluateVluns()]***")
    flag = True
    command = ""
    try:
        idx = 0
        prgStep, stepsUnit = util.calcPerStepDetail(CONSTANT.PROG70, len(vlunList))
        for vlun in vlunList:
             #确定命令
            if isLowerVersion:
                command = lowerShowVlunCommand + " id=" + vlun
            else:
                command = lowerShowVlunCommand + " id=" + vlun + " type=all"
            currFlag = evaluateVlun(command, context, vlun)
            util.itemProgressIncr(context, idx, prgStep, stepsUnit)
            idx += 1
            #如果评估vlun的命令失败，直接返回
            if queryVlunFailCommand:
                return False
            flag = flag and currFlag
        return flag
    except:
        msg = traceback.format_exc()
        util.log.error(context, "evaluateVluns ==> " + msg)
        return False

def evaluateVlun(command, context, vlunID):
    '''
    @summary:对单个vlun是否通过进行评估
    @param command : 执行命令
    @param context : 上下文
    @param vlunID : vlunID 
    '''
    util.log.info(context, "***[start executing evaluateVlun()]***")
    chkPass = False
    commandDesc = "windows_multipath_info_check_ultrapath_vlunid_" + vlunID
    cmd_display = context.get("ret_map")
    resultDict = {}
    try:
        ret = oneCmdExecute(command, commandDesc, cmd_display, context)
        #save execute result
        executeCommandRet.append(ret[2])
        #执行成功
        if ret[CONSTANT.MAGIC_INT0] == CONSTANT.MAGIC_INT1:
            isHyperMetroLUN, chkPass, _ = util.chkSingleLunPathRedundant(context, ret[2])
            #非双活
            if not isHyperMetroLUN:
                #失败
                if not chkPass:
                    util.log.error(context, 'Normal Vlun path not pass:' + vlunID)
                    queryFailList.append(vlunID)
                #成功
                else:
                    util.log.info(context, 'Normal Vlun path pass:' + vlunID)
            #双活成功
            elif chkPass:
                util.log.info(context, 'Hypermetro Vlun path pass:' + vlunID)
            #双活失败
            else:
                queryFailList.append(vlunID)
                util.log.error(context,
                               'Hypermetro Vlun path not pass：' + vlunID)
        #执行失败 
        else:
            util.log.info(context, "***[command execute failure: " + command + " ]***")          
            commandFailureList.append(command)
            queryFailList.append(vlunID)   
            queryVlunFailCommand.append(command)
        return chkPass      
    except:
        msg = traceback.format_exc()
        util.log.error(context, "evaluateVlun ==> " + msg)
        return False


def check_result(cmd_display_temp, cmd):
    """
    获取命令执行情况
    :param cmd_display_temp: 回文
    :param cmd: 命令
    """
    if not cmd_display_temp or cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
            or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
        if "en" == LANGUAGE:
            return "%s:\texecute failed\r\n" % cmd
        else:
            return u"%s:\t执行失败\r\n" % cmd
    else:
        if "en" == LANGUAGE:
            return "%s:\texecute success\r\n" % cmd
        else:
            return u"%s:\t执行成功\r\n" % cmd
