# coding=utf-8
# 获取Windows系统storage foundation相关信息
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..")
sys.path.append(path)
from common import constants,util

cmd_info_id = ['cmd_info_storage_foundation_hastatus_sum',
               'cmd_info_storage_foundation_lltstat_l',
               'cmd_info_storage_foundation_gabconfig_a',
               'cmd_info_storage_foundation_vxdg_g_dgname_info',
               'cmd_info_storage_foundation_hagrp_state',
               'cmd_info_storage_foundation_hares_state',
               'cmd_info_storage_foundation_hares_display',
               'cmd_info_storage_foundation_hagrp_display',
               'cmd_info_storage_foundation_hasys_list',
               'cmd_info_storage_foundation_vxdg_list',
               'cmd_info_storage_foundation_vxprint',
               'cmd_info_storage_foundation_vxprint_h',
               'cmd_info_storage_foundation_vxprint_v',
               'cmd_info_storage_foundation_vxprint_p',
               'cmd_info_storage_foundation_vxdisk_e_list',
               'cmd_info_storage_foundation_hdlm_disk',
               'cmd_info_storage_foundation_vxdisk_version',
               'cmd_info_storage_foundation_vxdisk_list']
cmd_info_desc = ['hastatus -sum',
                 'lltstat -l',
                 'gabconfig -a',
                 'vxdg -g dgname info',
                 'hagrp -state',
                 'hares -state',
                 'hares -display',
                 'hagrp -display',
                 'hasys -list',
                 'vxdg list',
                 'vxprint',
                 'vxprint -h',
                 'vxprint -v',
                 'vxprint -p',
                 'vxdisk -e list',
                 'dlnkmgr view -lu',
                 'vxassist version',
                 'vxdisk list']
cmd_info_dic = dict(zip(cmd_info_id,cmd_info_desc))
CLI = None
LANGUAGE = None

def execute(context):
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")
    cmd_display = context.get("ret_map")
    return cmd_execute(cmd_display, CLI, LANGUAGE, context, cmd_info_dic)

def cmd_execute(cmd_display, CLI, LANGUAGE, context,cmd_info_dict):
    if len(cmd_info_dict) > 0:
        fun_err_msg = ''
        prgStep = constants.PROG85 / len(cmd_info_dict)
        curstep = constants.PROG5
        util.updateItemProgress(context, curstep)
        for cmd_info_id,cmd_info_desc in cmd_info_dict.items():
            #特殊命令获取dgname后执行
            if cmd_info_id == 'cmd_info_storage_foundation_vxdg_g_dgname_info':
                fun_err_msg += exeCmdVxdgList(CLI, cmd_display, prgStep, curstep, context)
            else:
                cmd_display_temp = CLI.execCmd(cmd_info_desc)
                curstep += prgStep
                util.updateItemProgress(context, curstep)
                cmd_display.put("cmd_display" + cmd_info_id[8:], cmd_display_temp)
                if None == cmd_display_temp or '' == cmd_display_temp or \
                        cmd_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                        or cmd_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc + ":\texecute failed\r\n"
                    else:
                        fun_err_msg += cmd_info_desc + u":\t执行失败\r\n"
                else:
                    if "en" == LANGUAGE:
                        fun_err_msg += cmd_info_desc + ":\texecute success\r\n"
                    else:
                        fun_err_msg += cmd_info_desc + u":\t执行成功\r\n"
        cmd_display.put("err_msg", fun_err_msg)
        return  cmd_display
    else:
        return ""

def exeCmdVxdgList(CLI, cmd_display, prgStep, curstep, context):
    fun_err_msg = ''
    cmd_display_temp = CLI.execCmd('vxdg list')
    cdt_lst = cmd_display_temp.splitlines()
    for index in range(len(cdt_lst)):
        if cdt_lst[index].find("Name") > 0 and cdt_lst[index+1].find("Cluster") > 0:
            cluster_name = cdt_lst[index].strip().split(":")[1].strip()
            cmd = 'vxdg -g %s info' % cluster_name
            vxdg_display_temp = CLI.execCmd(cmd)
            curstep += prgStep
            util.updateItemProgress(context, curstep)
            cmd_display.put("cmd_display_" + cmd, vxdg_display_temp)
            if None == vxdg_display_temp or '' == vxdg_display_temp or vxdg_display_temp.find('TOOLKIT_SEND_CMD_TIME_OUT') > 0 \
                    or vxdg_display_temp.find('TOOLKIT_EXE_CMD_FAILED') > 0:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd + ":\texecute failed\r\n"
                else:
                    fun_err_msg += cmd + u":\t执行失败\r\n"
            else:
                if "en" == LANGUAGE:
                    fun_err_msg += cmd + ":\texecute success\r\n"
                else:
                    fun_err_msg += cmd + u":\t执行成功\r\n"
    return fun_err_msg
