# --*-- coding:utf-8 --*--
# Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from hosts.common.windows_parse_utils import get_horizontal_cli_ret
from common.cmd_execute import BaseCmdExecute, DES, CMD

CMD_LIST = [
    {DES: "cmd_display_get_vmhost", CMD: "powershell get-vmhost"},
    {DES: "cmd_display_get_vm", CMD: "powershell get-vm"},
]

VM_USE_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_vmharddiskdrive_", CMD: "powershell get-vmharddiskdrive '%s'"},
    {DES: "cmd_display_vmfibrechannelhb_", CMD: "powershell get-vmfibrechannelhba '%s'"},
]


def execute(context):
    VirtualInfo(context).execute()


class VirtualInfo(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def execute(self):
        """
        类的执行入口
        """
        self.cmd_list = CMD_LIST
        self.generate_relative_cmd_list(self.get_vm_name_list(), VM_USE_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list()

    def get_vm_name_list(self):
        """
        获取虚拟机名列表
        :return: 数据
        """
        cmd = "powershell get-vm"
        data_info = self.cli.execCmd(cmd)
        data_dicts = get_horizontal_cli_ret(data_info)
        data_names = []
        for data_dict in data_dicts:
            data_names.append((data_dict.get("Name", ""),))
        return data_names
