#coding:utf-8
import re
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..\\..\\..")
sys.path.append(path)
from common.contentParse import getSingleOrMoreCommandRetFromTxt 


#获取操作系统名称
def execute(context):
     
    #获取回文
    tempList = getSingleOrMoreCommandRetFromTxt(context, "cmd_display_hba_card_wwpn", False)
    result = ""
    if len(tempList) < 2:
        context["result"]="NA"
        return context
    if "powershell Get-InitiatorPort" in tempList[1]:
        for line in tempList:
            if "Fibre Channel" in line:
                result = result + (re.split("\s+", line)[-3]).strip() + ";"
    elif "MSFC_FibrePortHBAAttributes" in tempList[1]:
        for line in tempList:
            if "PortWWN" in line and "=" in line:
                result = result + changeWwpnFormate((re.split("=", line)[-1]).strip()) + ";"
    if "" == result:
        result = result + "NA"
    else:
        result = result[0:-1]
    context["result"]=result
    return context

#转换十进制wwpn号为十六进制
def changeWwpnFormate(portWwn):
    result = ""
    temp = ""
    if "," in portWwn:
        portWwnList = portWwn.split(",")
    else:
        return portWwn
    
    try:
        for port in portWwnList:
            temp = hex(int(port.strip()))[2:]
            if len(temp) == 2:
                result = result + temp
            else:
                result = result + "0" + temp
    except:
        return portWwn
    return result
