# -*- coding: UTF-8 -*-
import sys
import os
import re
import traceback

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, os.path.pardir)
sys.path.append(path)

from common import contentParse
from common import util
from common import constants
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult

linuxCmdInfoIdList = ["cmd_info_multipath_version_linux",
                      "cmd_info_version_linux"]
linuxCommandList = ["upadm show version",
                    "cat /etc/*release"]

linuxInitVersion = "5.01.052"
linuxEndVersion = "5.01.070"

notFoundPattern = "upadm|not found|unable to detect ultrapath device node"
verPattern = "software version|ultrapath for"
NOT_RANGE = "not in the range"
RANGE = "in the range"
EXE_FAILED = "execution failed"

ITEMKEY = "CompatibilityBetweenUltraPathAndSUSE"
COM_FAILED = "eval.host.multipath.buglist.failed"
EVAL_FAILED = "multipath.aix.check.version.failed"


def execute(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    '''
    retDict = context.get("ret_map")
    liunuxVerPattern = re.compile(r'SUSE Linux .* 10', re.I)

    cmdMultipathVersionRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, linuxCmdInfoIdList[0],
                                                                                    linuxCommandList[0])
    cliRet = cmdMultipathVersionRet + "\r\n"

    if RANGE == isMultipathVersionInRange(context, cmdMultipathVersionRet, linuxInitVersion, linuxEndVersion):
        linuxVersionRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, linuxCmdInfoIdList[1],
                                                                                 linuxCommandList[1])
        cliRet += linuxVersionRet + "\r\n"
        if len(linuxVersionRet.splitlines()) < constants.THREE:
            errMsgKey = COM_FAILED
            evalResult = EvalResultEnum.FAILED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [linuxCommandList[1]])
            retDict["evalResult"] = itemEvalResult
        elif liunuxVerPattern.search(linuxVersionRet) and "PATCHLEVEL" not in linuxVersionRet:
            errMsgKey = EVAL_FAILED
            evalResult = EvalResultEnum.FAILED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult
        else:
            errMsgKey = ""
            evalResult = EvalResultEnum.PASSED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult
    elif EXE_FAILED == isMultipathVersionInRange(context, cmdMultipathVersionRet, linuxInitVersion, linuxEndVersion):
        errMsgKey = COM_FAILED
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [linuxCommandList[0]])
        retDict["evalResult"] = itemEvalResult
    else:
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
    return retDict


def isMultipathVersionInRange(context, cmdMultipathVersionRet, initVersion, endVersion):
    """
    @summary: 判断多路径版本是否在指定区间
    @param cmdMultipathVersionRet: 回文
    @param initVersion: 起始版本
    @param endVersion: 结束版本
    @return: 返回是否在区间内
    """
    try:

        if re.search(notFoundPattern, cmdMultipathVersionRet[5:], re.I):
            util.log.info(context, "the cmd cannot found:" + unicode(cmdMultipathVersionRet))
            return NOT_RANGE

        elif re.search(verPattern, cmdMultipathVersionRet, re.I):
            multipathVersion = ''
            for line in cmdMultipathVersionRet.splitlines():
                if re.search(verPattern, line, re.I):
                    multipathVersion = line.split(":")[-1].strip()
                    break

            targetVersionTup = util.getUltrapathIntVer(context, multipathVersion)
            initVersionTup = util.getUltrapathIntVer(context, initVersion)
            endVersionTup = util.getUltrapathIntVer(context, endVersion)

            if targetVersionTup < initVersionTup or targetVersionTup > endVersionTup:
                util.log.error(context, "the version is not in the ranger:" + unicode(cmdMultipathVersionRet))
                return NOT_RANGE
            else:
                return RANGE
        else:
            util.log.error(context, "the cmd execution failed:" + unicode(cmdMultipathVersionRet))
            return EXE_FAILED
    except:
        util.log.error(context, 'get exception:' + traceback.format_exc())
        return EXE_FAILED
