# -*- coding: UTF-8 -*-
import sys
import os
import re
import traceback
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, os.path.pardir)
sys.path.append(path)

from common import contentParse
from common import util
from common import constants
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult

windowsCmdInfoIdList = ["cmd_info_multipath_version_windows",
                        "cmd_info_array_windows",
                        "cmd_info_array_id_windows",
                        "cmd_info_multipath_path_windows"]
windowsCommandList = ["upadm show version",
                      "upadm show array",
                      "upadm show path array_id=%s",
                      "upadm show path"]

linuxCmdInfoIdList = ["cmd_info_multipath_version_linux",
                      "cmd_info_array_linux",
                      "cmd_info_array_id_linux",
                      "cmd_info_multipath_path_linux"]
linuxCommandList = ["upadmin show version",
                    "upadmin show array",
                    "upadmin show path array_id=%s",
                    "upadmin show path"]

solarisCmdInfoIdList = ["cmd_info_multipath_version_solaris",
                        "cmd_info_array_solaris",
                        "cmd_info_array_id_solaris",
                        "cmd_info_multipath_path_solaris"]
solarisCommandList = ["upadm show version",
                      "upadm show array",
                      "upadm show path array_id=%s",
                      "upadm show path"]

vmwareCmdInfoIdList = ["cmd_info_multipath_version_vmware",
                       "cmd_info_array_vmware",
                       "cmd_info_array_id_vmware",
                       "cmd_info_multipath_path_vmware"]
vmwareCommandList = ["esxcli upadm show version",
                     "esxcli upadm show diskarray",
                     "esxcli upadm show path -a %s",
                     "esxcli upadm show path"]


linuxInitVersion = "5.01.052"
linuxEndVersion = "8.01.051"
solarisInitVersion = "5.01.045"
solarisEndVersion = "8.01.051"
vmwareInitVersion = "5.01.045"
vmwareEndVersion = "8.01.051"
windowsInitVersion = "5.01.045"
windowsEndVersion = "8.01.051"

NOT_FOUND = "not found"
UNKNOWN_COMMAND = "unknown command"
NOT_RANGE = "not in the range"
RANGE = "in the range"
EXE_FAILED = "execution failed"

ITEMKEY = "CtrlPathGT8UpgradeCarsh"
COM_FAILED = "eval.host.multipath.buglist.failed"
EVAL_FAILED = "ctrl.path.gt8.upgrade.carsh.failed"

ARRAY_ID = "array id"
TARGET_PORT = "target port"
CONTROLLER = "controller"
PATH_STATE = "path state"
PORT_TYPE = "port type"
ARRAY_NAME = "array name"
NORMAL = "normal"
DEGRAD = "degrad"


def execute(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    '''
    retDict = context.get("ret_map")
    evalResult = EvalResultEnum.FAILED
    errMsgKey = COM_FAILED

    osType = getOSType(context)
    util.updateItemProgress(context, constants.PROG5)
    if "NA" == osType:
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, "", errMsgKey, [])
        retDict["evalResult"] = itemEvalResult
    elif constants.OS_TYPE_LINUX_LOW == osType or constants.OS_TYPE_FUSIONSPHERE_LOW == osType:
        return dealContextData(context, linuxCmdInfoIdList, linuxCommandList, linuxInitVersion, linuxEndVersion)

    elif constants.OS_TYPE_SOLARIS_LOW == osType:
        return dealContextData(context, solarisCmdInfoIdList, solarisCommandList, solarisInitVersion, solarisEndVersion)

    elif constants.OS_TYPE_VMWARE_OS_LOW == osType:
        return dealContextData(context, vmwareCmdInfoIdList, vmwareCommandList, vmwareInitVersion, vmwareEndVersion)

    elif constants.OS_TYPE_WINDOWS_LOW == osType:
        return dealContextData(context, windowsCmdInfoIdList, windowsCommandList, windowsInitVersion, windowsEndVersion, True)


    return retDict

def dealContextData(context, cmdInfoIdListTmp, commandListTmp, initVersion, endVersion, isWindows = False):
    """
    @summary: 处理评估数据，写到context中去
    @param cliRet: 当前回文
    @param context: 上下文
    @param cmdInfoIdListTmp: 命令id列表
    @param commandListTmp: 命令列表
    @param initVersion: 起始版本
    @param endVersion: 结束版本
    """
    retDict = context.get("ret_map")
    ctrlIdStr = ""
    arrayIdAndCtrlIdList = []
    arrayIdAndCtrlIdStr = ""

    cmdMultipathVersionRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdListTmp[0], commandListTmp[0])
    util.updateItemProgress(context, constants.PROG15)
    cliRet = cmdMultipathVersionRet + "\r\n"

    if RANGE == isMultipathVersionInRange(context, cmdMultipathVersionRet, initVersion, endVersion, isWindows):
        cmdArrayIdRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdListTmp[1], commandListTmp[1])
        cliRet += cmdArrayIdRet + "\r\n"
        util.updateItemProgress(context, constants.PROG20)
        arrayIdList = getArrayIdList(context, cmdArrayIdRet)
        util.updateItemProgress(context, constants.PROG25)
        if not arrayIdList:
            errMsgKey = COM_FAILED
            evalResult = EvalResultEnum.FAILED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandListTmp[1]])
            retDict["evalResult"] = itemEvalResult
            return retDict
        araySize = 1 if len(arrayIdList) == 0 else len(arrayIdList)
        perGp = constants.PROG40 / araySize
        pg = constants.PROG25
        for arrayId in arrayIdList:
            cmdEnginePhysicalPathRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdListTmp[2] + "_%s" % arrayId, commandListTmp[2] % arrayId)
            cliRet += cmdEnginePhysicalPathRet + "\r\n"
            pg += perGp
            util.updateItemProgress(context, pg)
            if EXE_FAILED == getPhysicPathGT8CtrlIds(context, cmdEnginePhysicalPathRet):
                cmdTargetPortRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdListTmp[3], commandListTmp[3])
                cliRet += cmdTargetPortRet + "\r\n"

                arrayNameAndCtrlIdStr = getPhysicPathGT8CtrlIdsOther(context, cmdTargetPortRet)
                if EXE_FAILED == arrayNameAndCtrlIdStr:
                    errMsgKey = COM_FAILED
                    evalResult = EvalResultEnum.FAILED
                    itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandListTmp[3]])
                    retDict["evalResult"] = itemEvalResult
                    return retDict
                elif arrayNameAndCtrlIdStr:
                    errMsgKey = EVAL_FAILED
                    evalResult = EvalResultEnum.FAILED
                    itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [arrayNameAndCtrlIdStr])
                    retDict["evalResult"] = itemEvalResult
                    return retDict
                else:
                    errMsgKey = ""
                    evalResult = EvalResultEnum.PASSED
                    itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
                    retDict["evalResult"] = itemEvalResult
                    return retDict
            else:#覆盖ISCSI 和 FC两种场景
                ctrlIdStr = getPhysicPathGT8CtrlIds(context, cmdEnginePhysicalPathRet)
            util.log.info(context, "The ctrlIdStr is :" + ctrlIdStr)

            if ctrlIdStr:
                arrayIdAndCtrlIdStr += "Array %s: %s;" % (arrayId, ctrlIdStr)
        util.updateItemProgress(context, constants.PROG80)
        if arrayIdAndCtrlIdStr:
            arrayIdAndCtrlIdList.append(arrayIdAndCtrlIdStr[:-1])

        if arrayIdAndCtrlIdList:
            errMsgKey = EVAL_FAILED
            evalResult = EvalResultEnum.FAILED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, arrayIdAndCtrlIdList)
            retDict["evalResult"] = itemEvalResult
            return retDict
        else:
            errMsgKey = ""
            evalResult = EvalResultEnum.PASSED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult

    elif EXE_FAILED == isMultipathVersionInRange(context, cmdMultipathVersionRet, initVersion, endVersion, isWindows):
        errMsgKey = COM_FAILED
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandListTmp[0]])
        retDict["evalResult"] = itemEvalResult
    else:
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
    return retDict

def isMultipathVersionInRange(context, cmdMultipathVersionRetTmp, initVersion, endVersion, isWindows):
    """
    @summary: 判断多路径版本是否在指定区间
    @param cmdMultipathVersionRetTmp: 回文
    @param initVersion: 起始版本
    @param endVersion: 结束版本
    @return: 返回是否在区间内
    """
    if NOT_FOUND in cmdMultipathVersionRetTmp or ("'upadm'" in cmdMultipathVersionRetTmp and isWindows) \
       or (UNKNOWN_COMMAND in cmdMultipathVersionRetTmp.lower() or \
           "unable to detect ultrapath device node" in cmdMultipathVersionRetTmp.lower()):
        util.log.info(context, "the cmd cannot found:" + unicode(cmdMultipathVersionRetTmp))
        return NOT_FOUND

    elif (constants.SOFT_WARE_VERSION in cmdMultipathVersionRetTmp.lower()) or (constants.ULTRAPATH_VERSION in cmdMultipathVersionRetTmp.lower()):
        multipathVersion = ''
        for line in cmdMultipathVersionRetTmp.splitlines():
            if (constants.SOFT_WARE_VERSION in line.lower()) or (constants.ULTRAPATH_VERSION in line.lower()):
                multipathVersion = line.split(":")[-1].strip()
                break

        targetVersionTup = util.getUltrapathIntVer(context, multipathVersion)
        initVersionTup = util.getUltrapathIntVer(context, initVersion)
        endVersionTup = util.getUltrapathIntVer(context, endVersion)

        if targetVersionTup < initVersionTup or targetVersionTup > endVersionTup:
            util.log.error(context, "the version is not in the ranger:" + str(cmdMultipathVersionRetTmp))
            return NOT_RANGE
        else:
            return RANGE
    else:
        util.log.error(context, "the cmd execution failed:" + unicode(cmdMultipathVersionRetTmp))
        return EXE_FAILED

def getArrayIdList(context, cmdArrayIdRetTmp):
    """
    @summary: 获取引擎ID
    @param cmdArrayIdRetTmp: 回文
    @return: 返回引擎ID列表
    """
    hasArrayId = False
    arrayIdListTmp = []
    for line in cmdArrayIdRetTmp.splitlines():
        if ARRAY_ID in line.lower():
            hasArrayId = True
            continue

        if not hasArrayId:
            continue

        lineStr = re.split("\s+", line.strip())
        if len(lineStr) < constants.FIVE:
            continue
        else:
            arrayIdListTmp.append(line.split()[0])

    util.log.info(context, "the array id is :" + str(arrayIdListTmp))
    return arrayIdListTmp

def getTargetPortTupList(context, cmdTargetPortListRet):
    """
    @summary: 获取路径Target port
    @param cmdTargetPortListRet: 回文
    @return: 返回路径Target port List
    """
    hasTargetPort = False
    targetPortTupList = []
    for line in cmdTargetPortListRet.splitlines():
        if TARGET_PORT in line.lower() and PATH_STATE in line.lower() and ARRAY_NAME in line.lower() and CONTROLLER in line.lower():
            hasTargetPort = True
            continue

        if not hasTargetPort:
            continue

        lineStr = line.strip().split()
        if len(lineStr) < constants.SIX:
            continue
        elif (NORMAL in lineStr[5].strip().lower() or DEGRAD in lineStr[5].strip().lower()):
            targetPortTupList.append((lineStr[2], lineStr[3], lineStr[4]))

    util.log.info(context, "the target port is :" + str(targetPortTupList))
    return targetPortTupList

def getPhysicPathGT8CtrlIdsOther(context, cmdTargetPortListRet):
    """
    @summary: 判断控制器的路径数目是否大于 8
    @param cmdTargetPortListRet: 回文
    @return: 返回控制器Id字符串
    """
    ctrlIdAndPhyPathNumMap = {}
    ctrlNameAndCtrlId = {}
    ctrlNameAndCtrlIdStr = ''
    hasPhysicPath = False#是否有表头 
    portTypeIndex = False#protType 对应的列，为False取8，否则取最后一列
    arrayName = False#遇到新的表头，重新计算
    for line in cmdTargetPortListRet.splitlines():
        if CONTROLLER in line.lower() and PATH_STATE in line.lower() and PORT_TYPE in line.lower():
            hasPhysicPath = True
            arrayName = True
            if line.endswith(PORT_TYPE):
                portTypeIndex = True
            continue

        if not hasPhysicPath:
            continue

        lineStr = re.split("\s\s+", line.strip())

        if arrayName:
            arrayNameStr = lineStr[2].strip()
            arrayName = False

        if len(lineStr) >= constants.EGIHT and (NORMAL in lineStr[5].strip().lower() or DEGRAD in lineStr[5].strip().lower()):
            getArrayNameCtrlIdPortTypeAndPhyPathNumMap(ctrlIdAndPhyPathNumMap, lineStr[3].strip(), lineStr[-1].strip() if portTypeIndex else lineStr[7].strip(), arrayNameStr)

    # 如果没解析到路径，（1)匹配到路径的表头，说明是命令执行失败了；(2）没解析到的
    # 情况下可能是NORMAL 和 DEGRAD外的其他模式，是无效的路径
    if not ctrlIdAndPhyPathNumMap and not hasPhysicPath:
        util.log.error(context, "the cmd execution failed:" +
                       cmdTargetPortListRet)
        return EXE_FAILED

    util.log.info(context, "the ctrlIdAndPhyPathNumMap is:" + str(ctrlIdAndPhyPathNumMap))
    for key in ctrlIdAndPhyPathNumMap:
        if ctrlIdAndPhyPathNumMap[key] > constants.EGIHT:
            ctrlNameAndCtrl = key.split("_#:#_")
            if ctrlNameAndCtrl[0] not in ctrlNameAndCtrlId:
                ctrlNameAndCtrlId[ctrlNameAndCtrl[0]] = [ctrlNameAndCtrl[1]]
            else:
                ctrlNameAndCtrlId[ctrlNameAndCtrl[0]] = ctrlNameAndCtrlId[ctrlNameAndCtrl[0]] + [ctrlNameAndCtrl[1]]

    for key in ctrlNameAndCtrlId:
        ctrlNameAndCtrlIdStr += "Array Name: %s Controller: %s;" % (key, ",".join(ctrlNameAndCtrlId[key]))

    return ctrlNameAndCtrlIdStr[:-1]

def getPhysicPathGT8CtrlIds(context, cmdEnginePhysicalPathRetTmp):
    """
    @summary: 判断控制器的路径数目是否大于 8
    @param cmdEnginePhysicalPathRetTmp: 回文
    @return: 返回控制器Id字符串
    """
    portTypeIndex = False#protType 对应的列，为False取8，否则取最后一列
    ctrlIdAndPhyPathNumMap = {}
    ctrlId = ""
    ctrlNameAndCtrl = ""
    hasPhysicPath = False
    for line in cmdEnginePhysicalPathRetTmp.splitlines():
        if CONTROLLER in line.lower() and PATH_STATE in line.lower():
            hasPhysicPath = True
            if line.endswith(PORT_TYPE):
                portTypeIndex = True
            continue

        if not hasPhysicPath:
            continue

        lineStr = re.split("\s\s+", line.strip())
        if len(lineStr) >= constants.EGIHT and (NORMAL in lineStr[5].strip().lower() or DEGRAD in lineStr[5].strip().lower()):
            getArrayNameCtrlIdPortTypeAndPhyPathNumMap(ctrlIdAndPhyPathNumMap, lineStr[3].strip(), lineStr[-1].strip() if portTypeIndex else lineStr[7].strip())
        else:
            continue

    if not ctrlIdAndPhyPathNumMap:
        util.log.error(context, "the cmd execution failed:" + unicode(cmdEnginePhysicalPathRetTmp))
        return EXE_FAILED

    util.log.info(context, "the ctrlIdAndPhyPathNumMap is:" + str(ctrlIdAndPhyPathNumMap))
    for key in ctrlIdAndPhyPathNumMap:
        ctrlNameAndCtrl = key.split("_#:#_")
        if ctrlIdAndPhyPathNumMap[key] > constants.EGIHT:
            ctrlId += (ctrlNameAndCtrl[1] + ",")

    return ctrlId[:-1]

def getPhysicPathGT8CtrlIdsByTargetPort(context, targetPortList):
    """
    @summary: 判断控制器的路径数目是否大于 8
    @param targetPortList: 列表
    @return: 返回阵列控制器Id字符串
    """
    tgtPortPthMap = {}
    ctrlNameAndCtrlId = {}
    ctrlNameAndCtrlIdStr = ""
    for targetPort in targetPortList:
        isParseSucc, ctrlEncMac, nodeId = util.parseWwpn(context, targetPort[2])
        if not isParseSucc:
            util.log.error(context, 'Parse WWPN failed:' + unicode(targetPort[2]))
            continue
        else:
            key = str(ctrlEncMac) + str(nodeId) + "_#:#_" + targetPort[0] + "_#:#_" + targetPort[1]
            if key in tgtPortPthMap:
                tgtPortPthMap[key] += 1
            else:
                tgtPortPthMap[key] = 1

    if not tgtPortPthMap:
        util.log.error(context, "the cmd execution failed:" + str(tgtPortPthMap))
        return EXE_FAILED

    util.log.info(context, "the tgtPortPthMap is:" + str(tgtPortPthMap))
    for key in tgtPortPthMap:
        if tgtPortPthMap[key] > constants.EGIHT:
            ctrlNameAndCtrl = key.split("_#:#_")
            if ctrlNameAndCtrl[1] not in ctrlNameAndCtrlId:
                ctrlNameAndCtrlId[ctrlNameAndCtrl[1]] = [ctrlNameAndCtrl[2]]
            else:
                ctrlNameAndCtrlId[ctrlNameAndCtrl[1]] = ctrlNameAndCtrlId[ctrlNameAndCtrl[1]] + [ctrlNameAndCtrl[2]]

    for key in ctrlNameAndCtrlId:
        ctrlNameAndCtrlIdStr += "Array Name: %s Controller: %s;" % (key, ",".join(ctrlNameAndCtrlId[key]))

    return ctrlNameAndCtrlIdStr[:-1]

def getArrayNameCtrlIdPortTypeAndPhyPathNumMap(ctrlIdAndPhyPathNumMap, key, portType, arrayNameStr = "Array"):
    """
    @summary: 获取ArrayNameCtrlIDPortTYpe和物理路径数目字典
    @param ctrlIdAndPhyPathNumMap: 字典
    @param key: 字典的key
    @return: 命令查询返回结果
    """
    newKey = arrayNameStr + "_#:#_" + key + "_#:#_" + portType
    if newKey in ctrlIdAndPhyPathNumMap.keys():
        ctrlIdAndPhyPathNumMap[newKey] = ctrlIdAndPhyPathNumMap[newKey] + 1
    else:
        ctrlIdAndPhyPathNumMap[newKey] = 1

    return ctrlIdAndPhyPathNumMap

def getCtrlIdAndPhyPathNumMap(ctrlIdAndPhyPathNumMap, key):
    """
    @summary: 获取控制器和物理路径数目字典
    @param ctrlIdAndPhyPathNumMap: 字典
    @param key: 字典的key
    @return: 命令查询返回结果
    """

    if key in ctrlIdAndPhyPathNumMap.keys():
        ctrlIdAndPhyPathNumMap[key] = ctrlIdAndPhyPathNumMap[key] + 1
    else:
        ctrlIdAndPhyPathNumMap[key] = 1

    return ctrlIdAndPhyPathNumMap

def getOSType(context):
    """
    @summary: 查询当前系统的类型
    @param context: 上下文参数
    @return: 命令查询返回结果
    """
    contextDevType = context.get(constants.DEV_LEVEL2_TYPE).lower().strip()
    
    #windows
    if constants.OS_TYPE_WINDOWS.lower().strip() == contextDevType:
        util.log.info(context, "this item of device is Windows.")
        return constants.OS_TYPE_WINDOWS_LOW 
    
    #fusionsphere 
    if constants.OS_TYPE_FUSIONSPHERE_LOW.strip() == contextDevType:
        util.log.info(context, "this item of device is fusionsphere.")
        return constants.OS_TYPE_FUSIONSPHERE_LOW 
    #vmware
    if constants.OS_TYPE_VMWARE_OS_LOW.strip() == contextDevType:
        util.log.info(context, "this item of device is  vmware.")
        return constants.OS_TYPE_VMWARE_OS_LOW 
    #solaris
    if constants.OS_TYPE_SOLARIS_LOW.strip() == contextDevType:
        util.log.info(context, "this item of device is solaris.")
        return constants.OS_TYPE_SOLARIS_LOW 
    #linux
    if constants.OS_TYPE_LINUX_LOW.strip() == contextDevType:
        util.log.info(context, "this item of device is Linux")
        return constants.OS_TYPE_LINUX_LOW 

    return "NA"  

