# coding=utf-8
from com.huawei.ism.tool.infograb.context import EvalResultEnum

import re
import sys
import os

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..")
sys.path.append(path)
from common import util
from common import constants
from common import contentParse

cmdInfoIdList = ["cmd_info_os_for_windows", "cmd_info_os_for_unix", "cmd_info_multipath_version_new", "cmd_info_multipath_version_old"]
commandList = ["echo %OS%", "uname -a", "upadm show version", "upadm show version"]
osTypeFor501063List = [constants.OS_TYPE_LINUX, constants.OS_TYPE_SOLARIS, constants.OS_TYPE_WINDOWS]
COM_FAILED = "eval.host.multipath.buglist.failed"

def execute(context):
    '''
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    '''
    checkUltrapathVersion(context)

def checkUltrapathVersion(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    '''
    util.updateItemProgress(context, constants.PROG15)
    intSoftVersion501022 = util.getUltrapathIntVer(context, "5.01.022")
    intSoftVersion501063 = util.getUltrapathIntVer(context, "5.01.063")
    intSoftVersion601007 = util.getUltrapathIntVer(context, "6.01.007")
    intSoftVersion601025 = util.getUltrapathIntVer(context, "6.01.025")
    retDict = context.get("ret_map")

    itemKey = "DIFNotIdentityCheck"
    evalResult = EvalResultEnum.PASSED
    cliRet = ""
    errMsgKey = ""

    osType = getOSType(context)
    if "NA" == osType:
        util.updateItemProgress(context, constants.PROG85)
        evalResult = EvalResultEnum.FAILED
        errMsgKey = COM_FAILED
        itemEvalResult = util.genEvalItemObj(itemKey, evalResult, "", errMsgKey, [commandList[1]])
        retDict["evalResult"] = itemEvalResult
    else:
        softVer, tempCliRet = getUltrapathVersion(osType, context)
        util.updateItemProgress(context, constants.PROG75)
        util.log.info(context, "The version is :" + softVer)
        cliRet += tempCliRet + "\r\n"

        if "Pass" == softVer:
            itemEvalResult = util.genEvalItemObj(itemKey, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult
        #无法评估
        elif "NA" == softVer:
            evalResult = EvalResultEnum.FAILED
            errMsgKey = COM_FAILED
            itemEvalResult = util.genEvalItemObj(itemKey, evalResult, cliRet, errMsgKey, [commandList[3]])
            retDict["evalResult"] = itemEvalResult
        else:
            intSoftVersion = util.getUltrapathIntVer(context, softVer)
            util.log.info(context, "Change the version to int is :" + str(intSoftVersion))
            util.updateItemProgress(context, constants.PROG85)
            if constants.OS_TYPE_AIX == osType and intSoftVersion501022 <= intSoftVersion <= intSoftVersion601025:
                evalResult = EvalResultEnum.FAILED
                errMsgKey = constants.ERR_MSG_DIF_NOT_IDENTITY_NOT_PASSED
            elif osType in osTypeFor501063List and intSoftVersion501063 <= intSoftVersion <= intSoftVersion601007:
                evalResult = EvalResultEnum.FAILED
                errMsgKey = constants.ERR_MSG_DIF_NOT_IDENTITY_NOT_PASSED
            itemEvalResult = util.genEvalItemObj(itemKey, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult

def getUltrapathVersion(osType, context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    @param osType : 操作系统
    @return: softVer多路径软件版本，cliRet命令回文
    '''
    cliRet = ""
    softVer = "NA"
    if constants.OS_TYPE_LINUX == osType:
        cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[2], commandList[2])
    else:
        cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[3], commandList[3])

    if "'upadm'" in cliRet and constants.OS_TYPE_WINDOWS == osType:
        return "Pass", cliRet

    resultList = cliRet[5:].splitlines()
    for line in resultList:
        if ("software" in line.lower() and "version" in line.lower()) or "ultrapath for" in line.lower():
            softVer = re.split(":", line)[-1].strip()
            break
        #当前未安装自验多路径直接通过，不考虑Windows
        elif "upadm" in line.lower() or "unable to detect ultrapath device node" in line.lower():
            softVer = "Pass"
            break
    return softVer, cliRet

def getOSType(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    @return: softVer多路径软件版本，cliRet命令回文
    '''
    
    contextDevType = context.get(constants.DEV_LEVEL2_TYPE).lower().strip()
    
    #windows
    if constants.OS_TYPE_WINDOWS.lower().strip() == contextDevType:
        util.log.info(context, "this item of device is Windows.")
        return constants.OS_TYPE_WINDOWS
    
    #linux
    if constants.OS_TYPE_LINUX.lower().strip() == contextDevType or constants.OS_TYPE_FUSIONSPHERE_LOW == contextDevType:
        util.log.info(context, "this item of device is Linux.")
        return constants.OS_TYPE_LINUX
    
    #Solaris
    if constants.OS_TYPE_SOLARIS.lower().strip() == contextDevType:
        util.log.info(context, "this item of device is Solaris.")
        return constants.OS_TYPE_SOLARIS

    #Aix
    if constants.OS_TYPE_AIX.lower().strip() == contextDevType:
        util.log.info(context, "this item of device is Aix.")
        return constants.OS_TYPE_AIX
    
    return "NA"

