# coding=utf-8
from com.huawei.ism.tool.infograb.context import EvalResultEnum
import os
import re
import sys

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, os.path.pardir)
sys.path.append(path)
from common import constants
from common import util

getConfigIpCmd = "iscsiadm -m node"
getTimeoutCmd1 = "iscsiadm -m node -p "
getTimeoutCmd2 = " | grep replacement_timeout | cat"

cmdInfoId = ["cmd_info_iscsi_config_ip",
             "cmd_info_iscsi_timeout_"]

itemKey = "IscsiTimeoutCheck"
    
def execute(context):
    '''
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    '''
    retDict = context.get("ret_map")

    retDict["evalResult"] = getEvalResult(context)

def getEvalResult(context):
    """
    @summary: 获取评估结果
    """
    cliRet = ""
    status, ret = getStatusAndCmdResult(context, cmdInfoId[0], getConfigIpCmd)
    util.updateItemProgress(context, constants.PROG30)
    cliRet += ret + "\n"
    tmpList = []
    #没有此命令，表示未配置iscsi，报成功
    if 'command not found' in ret.lower() or 'no records found' in ret.lower():
        util.log.info(context, 'Command not found, eval success...')
        util.updateItemProgress(context, constants.PROG90)
        itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.PASSED, cliRet, "")
    #命令成功且有命令
    elif status and len(ret.splitlines()) >= 2:
        for line in ret.splitlines()[1:]:
            if ':' in line:
                ip = line.split(':')[0].strip()
                initiator = line.split(' ')[-1].strip()
                tmp = ip + "_" + initiator
                #ip去重
                if tmp not in tmpList:
                    tmpList.append(tmp)
        util.updateItemProgress(context, constants.PROG50)
        if len(tmpList) > 0:
            tmpRet, initiatorList, command = getTimeOutParam(context, tmpList)
            cliRet += tmpRet + "\n"
            util.updateItemProgress(context, constants.PROG90)
            if command:
                util.log.error(context, "~~Send cmd (" + command + ") error...~~")
                itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, "eval.host.multipath.buglist.failed", [command])
            elif initiatorList:
                errorParam = ','.join(str(i) for i in initiatorList)
                util.log.error(context, "~~Current initiator(" + errorParam + ") timeout not pass...~~")
                itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, "iscsi.timeout.check.Linux.not.passed", [errorParam])
            else:
                util.log.info(context, '~~Eval success...~~')
                itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.PASSED, cliRet, "")
                
        else:
            util.log.error(context, '~~No timeout param...~~')
            util.updateItemProgress(context, constants.PROG90)
            itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, "eval.host.multipath.buglist.failed", [getConfigIpCmd])
        
    #命令发送失败，报无法评估
    else:
        util.log.error(context, "~~Send cmd (" + getConfigIpCmd + ") error...~~")
        util.updateItemProgress(context, constants.PROG90)
        itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, "eval.host.multipath.buglist.failed", [getConfigIpCmd])
    return itemEvalResult
def getStatusAndCmdResult(context, cmdInfoId, command):
    '''
    @summary: 下发命令，保存一条回文信息
    @param context: 上下文数据 
    @param cmdInfoID: 命令回文title 
    @param command: 命令
    '''
    sshCon = context.get("SSH")
    lang = context.get("lang")
    display = context.get("ret_map")
    resultMsg = display.get("err_msg")
    if not resultMsg:
        resultMsg = ""

    cmdResultTemp = sshCon.execCmdHasLogTimout(command, constants.HOST_CMD_TIMEOUT)
    util.log.info(context, cmdResultTemp)

    status = True
    if not cmdResultTemp or\
        'TOOLKIT_SEND_CMD_TIME_OUT' in  cmdResultTemp or\
            'TOOLKIT_EXE_CMD_FAILED' in cmdResultTemp:
        status = False

    if "en" == lang:
        if status:
            resultMsg += command + ":\texecute success\r\n"
        else:
            resultMsg += command + ":\texecute failed\r\n"
    else:
        if status:
            resultMsg += command + u":\t执行成功\r\n"
        else:
            resultMsg += command + u":\t执行失败\r\n"

    display[cmdInfoId] = cmdResultTemp
    display["err_msg"] = resultMsg
    
    return status, cmdResultTemp

def getTimeOutParam(context, tmpList):
    '''
    @summary: 下发命令，保存一条回文信息
    @param context: 上下文数据 
    @param tmpList: ip+initiator的数组
    '''
    initiatorList = []
    cliRet = ""
    util.updateItemProgress(context, constants.PROG70)
    for tmp in tmpList:
        ip = tmp.split('_')[0].strip()
        initiator = tmp.split('_')[-1].strip()
        command = getTimeoutCmd1 + ip + getTimeoutCmd2
        util.log.info(context, 'Find ip : ' + ip + ', start to get timeout...')
        status, ret = getStatusAndCmdResult(context, cmdInfoId[1]+ip, command)
        cliRet += ret + "\n"
        #查询超时时间参数，回文包含字段“node.session.timeo.replacement_timeout”
        if status and 'node.session.timeo.replacement_timeout' in ret.lower():
            time = None
            util.updateItemProgress(context, constants.PROG50)
            for line in ret.splitlines()[1:]:
                if '=' in line:
                    tmp = line.split('=')[-1].strip()
                    if tmp != "1":
                        initiatorList.append(initiator)
                        break
                else:
                    util.log.info(context, "Error cmd result" + ret)
                    return cliRet, initiatorList, command
        else:
            util.log.info(context, "Error cmd result" + ret)
            return cliRet, initiatorList, command
    return cliRet, initiatorList, ""