# -*- coding: UTF-8 -*-
import sys
import os
import re
import traceback
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, os.path.pardir)
sys.path.append(path)

from common import contentParse
from common import util
from common import constants
import linux_multipath_bug_judgement
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult

cmdInfoIdList = [
                 "cmd_info_system_kernel_version",
                 "cmd_info_multipath_version_linux",
                 "cmd_info_vlun_type_linux",
                 "cmd_info_vlun_linux"
                 ]
commandList = [
               "uname -r",
               "upadm show version",
               "upadmin show vlun type=all",
               "upadmin show vlun"
               ]

linuxInitVersion = "6.01.022"
linuxMiddleVersion = "8.01.051"
linuxEndVersion = "8.06.063"

linuxKernelVersion = 38
TWO_T_CAPACITY = 2147483648

NOT_FOUND = "upadm"
NOT_VLUN = "can't find any vluns"
NOT_RANGE = "not in the range"
UPPER_RANGE = "in the upper range"
LOWER_RANGE = "in the lower range"
EXE_FAILED = "execution failed"

CAPACITY = "capacity"

ITEMKEY = "MultipathLinuxLUNOptResultInterruption"
EVAL_WARNING = "multipath.linux.LUN.opt.result.interruption.failed"
EVAL_FAILED = "multipath.linux.LUN.opt.result.interruption.warning"
UNABLE_EVAL = "eval.host.multipath.buglist.failed"

def execute(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    @param CLI : SSH
    @param LANGUAGE : 语言类型
    '''
    retDict = context.get("ret_map")
    # 2T LUN 方案使用 "parted /dev/%s print" 命令会导致业务中断，去掉2T LUN 检查
    isDataCoverage = linux_multipath_bug_judgement.executeBugJudge(context)
    evalResult = EvalResultEnum.UNABLE_EVAL
    errMsgKey = UNABLE_EVAL
    cliRet = ''

    #步骤1：查询“升级检查磁盘数据覆盖度”检查结果是否为不通过（数据被覆盖）；如果是不通过（数据被覆盖），则当前检查项评估通过；如果是通过，则执行步骤2；
    if not isDataCoverage:
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, "the result is pass.", errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict

    util.updateItemProgress(context, constants.PROG5)
    cmdKernelRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[0], commandList[0])
    util.updateItemProgress(context, constants.PROG15)
    cliRet += cmdKernelRet + "\r\n"
    cmdKernelRetList = cmdKernelRet.splitlines()
    if len(cmdKernelRetList) < 2:
        util.log.error(context, "get the kernel version failed :" + unicode(cmdKernelRet))
        errMsgKey = UNABLE_EVAL
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[0]])
        retDict["evalResult"] = itemEvalResult
        util.updateItemProgress(context, constants.PROG95)
        return retDict

    util.log.info(context, "get the kernel version succ :" + unicode(cmdKernelRet))
    try:
        kernelVersion = cmdKernelRetList[1].strip().split(".")
        versionStr = kernelVersion[0] + kernelVersion[1]
        version = int(versionStr)
    except:
        util.log.error(context, 'Convert kernel version exception:' + traceback.format_exc())
        errMsgKey = UNABLE_EVAL
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[0]])
        retDict["evalResult"] = itemEvalResult
        util.updateItemProgress(context, constants.PROG95)
        return retDict

    if version < linuxKernelVersion:
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        util.updateItemProgress(context, constants.PROG95)
        return retDict

    cmdMultipathVersionRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[1], commandList[1])
    cliRet += cmdMultipathVersionRet + "\r\n"
    if UPPER_RANGE == isMultipathVersionInRange(context, cmdMultipathVersionRet, linuxInitVersion, linuxMiddleVersion, linuxEndVersion):
        util.updateItemProgress(context, constants.PROG55)
        cmdLUNCapacityRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[2], commandList[2])
        cliRet += cmdLUNCapacityRet + "\r\n"
        if NOT_VLUN in cmdLUNCapacityRet.lower():
            itemEvalResult = util.genEvalItemObj(ITEMKEY, EvalResultEnum.PASSED, cliRet, "")
            retDict["evalResult"] = itemEvalResult
            return retDict
        evalResult, errMsgKey = getEvalResult(context, cmdLUNCapacityRet)
        if not errMsgKey or errMsgKey == EVAL_FAILED:
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult
            return retDict

        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[2]])
        retDict["evalResult"] = itemEvalResult
        util.updateItemProgress(context, constants.PROG95)
        return retDict

    elif LOWER_RANGE == isMultipathVersionInRange(context, cmdMultipathVersionRet, linuxInitVersion, linuxMiddleVersion, linuxEndVersion):
        util.updateItemProgress(context, constants.PROG55)
        cmdLUNCapacityRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[3], commandList[3])
        cliRet += cmdLUNCapacityRet + "\r\n"
        if NOT_VLUN in cmdLUNCapacityRet.lower():
            itemEvalResult = util.genEvalItemObj(ITEMKEY, EvalResultEnum.PASSED, cliRet, "")
            retDict["evalResult"] = itemEvalResult
            return retDict
        evalResult, errMsgKey = getEvalResult(context, cmdLUNCapacityRet)
        if not errMsgKey or errMsgKey == EVAL_FAILED:
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult
            return retDict

        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[3]])
        retDict["evalResult"] = itemEvalResult
        util.updateItemProgress(context, constants.PROG95)
        return retDict

    elif EXE_FAILED == isMultipathVersionInRange(context, cmdMultipathVersionRet, linuxInitVersion, linuxMiddleVersion, linuxEndVersion):
        errMsgKey = UNABLE_EVAL
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[1]])
        retDict["evalResult"] = itemEvalResult

    else:
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
    util.updateItemProgress(context, constants.PROG95)
    return retDict

def getEvalResult(context, cmdLUNCapacityRet):
    """
    @summary: 获取评估结果
    @param cmdLUNCapacityRet: 回文
    @param context: 上下文
    @return: 返回评估结果
    """
    LUNCapacityList = getLUNCapacityList(context, cmdLUNCapacityRet)
    if not LUNCapacityList:
        util.log.error(context, "the LUN capacity is empty, cannot evaluate")
        return EvalResultEnum.FAILED, UNABLE_EVAL

    LUNCapacityFloatList = changeStringListToFloatList(context, LUNCapacityList)
    if not LUNCapacityFloatList:
        util.log.error(context, "the LUN capacity is empty")
        return EvalResultEnum.FAILED, UNABLE_EVAL

    for capacityFloat in LUNCapacityFloatList:
        if capacityFloat > TWO_T_CAPACITY:
            util.log.info(context, "find a LUN capacity is greater than 2T,the capacity is :%s" % capacityFloat)
            return EvalResultEnum.FAILED, EVAL_FAILED

    util.log.info(context, "all LUN capacity are less than 2T")
    return EvalResultEnum.PASSED, ""

def getLUNCapacityList(context, cmdLUNCapacityRet):
    """
    @summary: 获取LUN的容量
    @param cmdArrayIdRetTmp: 回文
    @return: 返回LUN的容量列表
    """
    LUNCapacityListTmp = []
    hasLUNCapacityInfo = False
    indexNum = -1
    for line in cmdLUNCapacityRet.splitlines():
        if CAPACITY in line.lower():
            lineSplitStr = re.split(r'\s+', line.strip().lower())
            util.log.info(context, "the result of line split is: " + unicode(lineSplitStr))
            indexNum = lineSplitStr.index(CAPACITY)
            if "vlun id" in line.lower():
                indexNum -= 1
            if "lun wwn" in line.lower():
                indexNum -= 1
            util.log.info(context, "the index of capacity is: " + unicode(indexNum))
            hasLUNCapacityInfo = True
            continue

        if not hasLUNCapacityInfo:
            continue

        lineStr = line.split()
        if len(lineStr) < constants.SIX:
            continue
        elif -1 != indexNum:
            LUNCapacityListTmp.append(line.split()[indexNum])

    util.log.info(context, "the lun capacity list is :" + unicode(LUNCapacityListTmp))
    return LUNCapacityListTmp

def changeStringListToFloatList(context, LUNCapacityList):
    """
    @summary: 将LUN容量转化为浮点型
    @param LUNCapacityList: LUN容量列表
    @param context: 上下文
    @return: LUN容量浮点型列表
    """
    LUNCapacityIntListTmp = []
    try:
        for LUNCapacity in LUNCapacityList:
            if LUNCapacity.lower().endswith("kb"):
                LUNCapacityIntListTmp.append(float(LUNCapacity[:-2]))
            elif LUNCapacity.lower().endswith("mb"):
                LUNCapacityIntListTmp.append(float(LUNCapacity[:-2]) * 1024)
            elif LUNCapacity.lower().endswith("gb"):
                LUNCapacityIntListTmp.append(float(LUNCapacity[:-2]) * 1024 * 1024)
            elif LUNCapacity.lower().endswith("tb"):
                LUNCapacityIntListTmp.append(float(LUNCapacity[:-2]) * 1024 * 1024 * 1024)
            elif LUNCapacity.lower().endswith("pb"):
                LUNCapacityIntListTmp.append(float(LUNCapacity[:-2]) * 1024 * 1024 * 1024 * 1024)
            else:
                continue
    except:
        util.log.error(context, 'Convert LUN capacity exception:' + traceback.format_exc())
        return []

    util.log.info(context, "the LUN capacity id is :" + unicode(LUNCapacityIntListTmp))
    return LUNCapacityIntListTmp

def isMultipathVersionInRange(context, cmdMultipathVersionRetTmp, initVersion, middleVersion, endVersion):
    """
    @summary: 判断多路径版本是否在指定区间
    @param cmdMultipathVersionRetTmp: 回文
    @param initVersion: 起始版本
    @param endVersion: 结束版本
    @return: 返回是否在区间内
    """
    if NOT_FOUND in cmdMultipathVersionRetTmp[5:] or "unable to detect ultrapath device node" in cmdMultipathVersionRetTmp.lower():
        util.log.info(context, "the cmd cannot found:" + unicode(cmdMultipathVersionRetTmp))
        return NOT_FOUND

    elif constants.SOFT_WARE_VERSION in cmdMultipathVersionRetTmp.lower() or (constants.ULTRAPATH_VERSION in cmdMultipathVersionRetTmp.lower()):
        multipathVersion = ''
        for line in cmdMultipathVersionRetTmp.splitlines():
            if constants.SOFT_WARE_VERSION in line.lower() or (constants.ULTRAPATH_VERSION in line.lower()):
                multipathVersion = line.split(":")[-1].strip()
                break

        targetVersionTup = util.getUltrapathIntVer(context, multipathVersion)
        initVersionTup = util.getUltrapathIntVer(context, initVersion)
        middleVersionTup = util.getUltrapathIntVer(context, middleVersion)
        endVersionTup = util.getUltrapathIntVer(context, endVersion)

        if targetVersionTup < initVersionTup or targetVersionTup >= endVersionTup:
            util.log.error(context, "the version is not in the ranger:" + unicode(cmdMultipathVersionRetTmp))
            return NOT_RANGE
        elif targetVersionTup > middleVersionTup:
            return UPPER_RANGE
        else:
            return LOWER_RANGE
    else:
        util.log.error(context, "the cmd execution failed:" + unicode(cmdMultipathVersionRetTmp))
        return EXE_FAILED
