# --*-- coding:utf-8 --*--
import re
import sys
import os
path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, "..")
sys.path.append(path)
from common import util
from common import constants
from common import contentParse
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult

CLI = None
LANGUAGE = None
cmdInfoIdList = ["cmd_info_multipath_version"]
COM_FAILED = "eval.host.multipath.buglist.failed"

def execute(context):
    '''
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : retDict['evalResult'] 
    '''
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = context.get("lang")

    return doEvaluate(context)

def doEvaluate(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    @return: retDict['evalResult']
    '''
    retDict = context.get("ret_map")
    util.updateItemProgress(context, constants.PROG25)
    resultMap = checkSoftwareVersion(context)
    util.updateItemProgress(context, constants.PROG65)
    succNum = resultMap.get('succNum')
    cliRet = resultMap.get('cliRet')
    errMsg = ""
    itemKey = "SolarisReportLunCheck"

    #无法评估
    if succNum == 2:
        util.log.info(context, 'solaris report lun unable to check.')
        errMsg = COM_FAILED
        itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, errMsg, ["upadm show version"])
    #评估成功
    elif succNum == 0:
        util.log.info(context, 'solaris report lun check successful.')
        itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.PASSED, cliRet, errMsg)
    #评估失败
    elif succNum == 1:
        util.log.error(context, 'solaris report lun check failed.')
        errMsg = constants.ERR_MSG_SOLARIS_REPORT_LUN_CHECK_NOT_PASSED
        itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, errMsg)

    util.updateItemProgress(context, constants.PROG85)
    retDict['evalResult'] = itemEvalResult
    return retDict

def checkSoftwareVersion(context):
    '''
    @summary: 查询多路径版本,进行评估
    @param context: 上下文参数
    @return: {评估结果，回显信息}
    '''

    succNum = 0
    cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, "cmd_info_multipath_version", "upadm show version")
    #command not found表示为安装多路径：评估通过
    if "upadm" in cliRet[5:] or "command not found" in cliRet or "unable to detect ultrapath device node" in cliRet.lower():
        succNum = 0
    #判断路径版本
    elif "software version" in cliRet.lower() or "ultrapath for" in cliRet.lower():
        for line in cliRet.splitlines()[1:]:
            if line.strip().lower().startswith("software version") or line.strip().lower().startswith("ultrapath for"):
                splitline = re.split(":", line.strip())
                if len(splitline) == 2:
                    version = splitline[-1].strip()
                    aimVer = util.getUltrapathIntVer(context, version)
                    lowerVer = util.getUltrapathIntVer(context, "8.01.024")
                    middleVer = util.getUltrapathIntVer(context, "8.01.048")
                    #如果在8.01.024和8.01.048之间：评估不通过
                    if lowerVer <= aimVer <= middleVer:
                        succNum = 1
                        break
    #如果命令执行失败：无法评估
    else:
        succNum = 2
    return {'succNum':succNum, 'cliRet':cliRet}
