# -*- coding: UTF-8 -*-
import sys
import os
import re
import traceback
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, os.path.pardir)
sys.path.append(path)

from common import contentParse
from common import util
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult

cmdInfoIdList = [
                 "cmd_info_system_kernel_version",
                 "cmd_info_multipath_version_linux",
                 ]
commandList = [
               "uname -r",
               "upadm show version",
               ]

linuxStartVersion = "8.06.045"
linuxEndVersion = "21.02.024"
linuxKernelVersion = "4.1.0"
notFoundPattern = "upadm|not found|nable to detect ultrapath device node"

ITEMKEY = "UltraPathAndLinuxMappingRelationship"
COM_FAILED = "eval.host.multipath.buglist.failed"
EVAL_FAILED = "ultrapath.linux.mapping.relationship.failed"

def qryUltrapathVersion(context):
    '''
    @summary: Query the HUAWEI ultrapath version.
    @param context: Python execution context.
    @return (isQrySucc, ultrapathVersion, cliRet)
    '''
    try:
        cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[1], commandList[1])
        verPattern = 'UltraPath for Linux'
        for line in cliRet.splitlines():
            if re.search(verPattern, line, re.I):
                return True, line.split(':')[-1].strip(), cliRet
        return False, '', cliRet
    except:
        util.log.error(context, 'Query ultrapath version exception:' + traceback.format_exc())
        return False, '', cliRet

def qrySystemKernelVersion(context):
    '''
    @summary: Query the System Kernel version.
    @param context: Python execution context.
    @return (isQrySucc, KernelVersion, cliRet)
    '''
    try:
        cmdKernelRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[0], commandList[0])
        if len(cmdKernelRet.splitlines()) >= 2:
            return True, cmdKernelRet.splitlines()[1].strip(), cmdKernelRet
        return False, '', cmdKernelRet
    except:
        util.log.error(context, 'Query ultrapath version exception:' + traceback.format_exc())
        return False, '', cmdKernelRet

def getKernelIntVer(context, ver):
    '''
    @summary: Convert String version to a tuple with 2 version.
    @param context: Python execution context.
    @param ver: String version.
    @return: version tuple such as (2, 6, 1)
    '''
    try:
        verPattern = re.compile(r'\d+\.\d+\.\d+', re.I)
        verInfo = verPattern.search(ver)
        if verInfo:
            return tuple(map(int, verInfo.group().split('.')))
        else:
            return (0, 0, 0)
    except:
        util.log.error(context, 'Convert kernel version exception:' + traceback.format_exc())
        return (0, 0, 0)

def execute(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    @param CLI : SSH
    @param LANGUAGE : 语言类型
    '''
    retDict = context.get("ret_map")
    evalResult = EvalResultEnum.FAILED
    errMsgKey = COM_FAILED

    isSucc, kernelVersion, cliRet = qrySystemKernelVersion(context)
    if not isSucc:
        util.log.error(context, "get the kernel version failed :" + str(cliRet))
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[0]])
        retDict["evalResult"] = itemEvalResult
        return retDict

    curKernelVersionTup = getKernelIntVer(context, kernelVersion)
    tarKernelVersionTup = getKernelIntVer(context, linuxKernelVersion)
    if curKernelVersionTup == (0, 0, 0):
        util.log.error(context, "get the int kernel version failed :" + str(cliRet))
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[0]])
        retDict["evalResult"] = itemEvalResult
        return retDict

    if curKernelVersionTup <= tarKernelVersionTup:
        util.log.info(context, "thr curKernelVersionTup:" + str(curKernelVersionTup))
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict

    isSucc, version, versionRet = qryUltrapathVersion(context)
    cliRet += "\r\n" + versionRet
    if not isSucc:
        if re.search(notFoundPattern, versionRet[5:], re.I):
            util.log.info(context, "get the ultrapath version infomation :" + str(cliRet))
            errMsgKey = ""
            evalResult = EvalResultEnum.PASSED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult
            return retDict
        else:
            util.log.error(context, "get the ultrapath version failed :" + str(cliRet))
            evalResult = EvalResultEnum.FAILED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, COM_FAILED, [commandList[1]])
            retDict["evalResult"] = itemEvalResult
            return retDict

    curUltrapathVerTup = util.getUltrapathIntVer(context, version)
    startUltrapathVerTup = util.getUltrapathIntVer(context, linuxStartVersion)
    endUltrapathVerTup = util.getUltrapathIntVer(context, linuxEndVersion)
    if curUltrapathVerTup == (0, 0, 0):
        util.log.error(context, "get the int ultrapath version failed :" + str(cliRet))
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, COM_FAILED, [commandList[1]])
        retDict["evalResult"] = itemEvalResult
        return retDict

    if startUltrapathVerTup <= curUltrapathVerTup < endUltrapathVerTup:
        util.log.error(context, "get the ultrapath version failed :" + str(cliRet))
        errMsgKey = EVAL_FAILED
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict
    else:
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict
