# coding=utf-8
from com.huawei.ism.tool.infograb.context import EvalResultEnum
import os
import re
import sys

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, os.path.pardir)
sys.path.append(path)
from common import constants
from common import util

cmdInfoDesc = ["Reg Query \"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{4D36E97B-E325-11CE-BFC1-08002BE10318}\" /s /f LinkDownTime /v",
               "Reg Query \"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{4D36E97B-E325-11CE-BFC1-08002BE10318}\" /s /f MaxRequestHoldTime /v"]

cmdInfoId = ["cmd_info_iscsi_linkdowntime",
             "cmd_info_iscsi_maxrequestholdtime"]

itemKey = "IscsiTimeoutCheck"
    
def execute(context):
    '''
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    '''
    retDict = context.get("ret_map")

    retDict["evalResult"] = checkRisk(context)

def checkRisk(context):
    """
    @summary: 
    """
    cliRet = ""
    status, ret, maxLinkDownTime = getStatusAndCmdResult(context, cmdInfoId[0], cmdInfoDesc[0])
    util.updateItemProgress(context, constants.PROG30)
    cliRet += ret + "\n"
    statusLinkDownTime = False
    statusMaxRequestHoldTime = False
    #命令成功，且查到LinkDownTime，继续查询
    util.updateItemProgress(context, constants.PROG50)
    if status:
        status, ret, maxMaxRequestHoldTime = getStatusAndCmdResult(context, cmdInfoId[1], cmdInfoDesc[1])
        cliRet += ret + "\n"
        #查到MaxRequestHoldTime，检查超时时间
        util.updateItemProgress(context, constants.PROG70)
        if status:
            if maxLinkDownTime == 'NA' or maxLinkDownTime <= 5:
                statusLinkDownTime = True
            if maxMaxRequestHoldTime == 'NA' or maxMaxRequestHoldTime <= 5:
                statusMaxRequestHoldTime = True
            util.updateItemProgress(context, constants.PROG90)
            #评估结果需要判断两个值是否小于等于5或者为NA
            if statusLinkDownTime and statusMaxRequestHoldTime :
                util.log.info(context, "~~Eval success..~~")
                itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.PASSED, cliRet, "")
            #评估不通过
            else:
                errorParam = str(maxLinkDownTime) + ", " + str(maxMaxRequestHoldTime)
                util.log.info(context, "~~Eval failed.. errorParam (" + errorParam + ")~~")
                itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, "iscsi.timeout.check.Windows.not.passed", [str(maxLinkDownTime), str(maxMaxRequestHoldTime)])
        #命令失败，报命令失败
        else:
            util.updateItemProgress(context, constants.PROG90)
            util.log.info(context, "~~Send cmd (" + cmdInfoDesc[1] + ") error...~~")
            itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, "eval.host.multipath.buglist.failed", [cmdInfoDesc[1]])
    #命令失败，报命令失败
    else:
        util.updateItemProgress(context, constants.PROG90)
        util.log.info(context, "~~Send cmd (" + cmdInfoDesc[0] + ") error...~~")
        itemEvalResult = util.genEvalItemObj(itemKey, EvalResultEnum.FAILED, cliRet, "eval.host.multipath.buglist.failed", [cmdInfoDesc[0]])
    return itemEvalResult
def getStatusAndCmdResult(context, cmdInfoId, command):
    '''
    @summary: 
    @param context: 上下文数据 
    @param cmdInfoID: 命令回文title 
    @param command: 命令
    '''
    sshCon = context.get("SSH")
    lang = context.get("lang")
    display = context.get("ret_map")
    resultMsg = display.get("err_msg")
    maxParam = -1
    if not resultMsg:
        resultMsg = ""

    cmdResultTemp = sshCon.execCmdWithTimout(command, constants.HOST_CMD_TIMEOUT)

    status = True
    if not cmdResultTemp or\
        'TOOLKIT_SEND_CMD_TIME_OUT' in  cmdResultTemp or\
            'TOOLKIT_EXE_CMD_FAILED' in cmdResultTemp:
        status = False

    if "en" == lang:
        if status:
            resultMsg += command + ":\texecute success\r\n"
        else:
            resultMsg += command + ":\texecute failed\r\n"
    else:
        if status:
            resultMsg += command + u":\t执行成功\r\n"
        else:
            resultMsg += command + u":\t执行失败\r\n"

    display[cmdInfoId] = cmdResultTemp
    display["err_msg"] = resultMsg
    
    if status :
        maxParam = getMaxParam(context, cmdResultTemp, cmdInfoId[15:]) 
    return status, cmdResultTemp, maxParam

def getMaxParam(context, result, param):
    '''
    @summary: 
    @param result: 命令回文
    @param command: 参数值
    '''
    max = -1
    hasTimeout = False
    resultLines = result.splitlines()
    if param in result.lower():
        for rg in range(len(resultLines)):
            if rg ==0 :
                continue
            if param in resultLines[rg].lower() and re.search(r'\d+\\Parameters$', resultLines[rg - 1]):
                hasTimeout = True
                tmpLine = resultLines[rg]
                tmp = tmpLine.split(' ')[-1].strip()
                tmpMax = int(tmp, 16)
                if tmpMax > max:
                    max = tmpMax
    if not hasTimeout:
        #没有超时参数返回NA
        max = 'NA'
    return max
            