# coding=utf-8
from com.huawei.ism.tool.infograb.context import EvalResultEnum
import os
import re
import sys

path = os.path.dirname(os.path.abspath(__file__))
path = os.path.join(path, os.path.pardir)
sys.path.append(path)
from common import constants
from common import util

#===============================================================================
# 需要发送的一些命令
# @param id: 命令回文的title
# @param cmd: 命令  
#===============================================================================
OS_VERSION_QUERY = {"id":"cmd_display_windows_ver", "cmd": "wmic os get version"}
R2_CHECK_PATCH = {"id":"cmd_display_R2_check_patch", "cmd":"powershell get-hotfix"}
WS2008_CHECK_PATCH = {"id":"cmd_display_2008_check_patch", "cmd":"systeminfo"}
#===============================================================================
# 有蓝屏风险的操作系统版本
#===============================================================================
WINDOWS_2008_R2 = ["6.1.7600"]
WINDOWS_2008_AND_SP2 = ["6.0.6001", "6.0.6002"]

#===============================================================================
# EvalResultEnum评估结果需要的一些参数
#===============================================================================
BUGLIST_ITEM_KEY = "WindowsServer2008BuleScreen"
WINDOWS_2008_BULE_SCREEN_CMD_FAILED = "eval.host.multipath.buglist.failed"
WINDOWS_2008_BULE_SCREEN_NO_PATCH_FAILED = "windows.2008.blue.screen.risk.no.patch.failed"

def execute(context):
    '''
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    '''
    retDict = context.get("ret_map")

    #===========================================================================
    # 填装评估结果
    #===========================================================================
    retDict["evalResult"] = checkRisk(context)

def checkRisk(context):
    """
    @summary: 一步步排查风险项
    """
    cliRet = ""
    util.updateItemProgress(context, constants.PROG5)
    status, versionResult = getStatusAndCmdResult(context, OS_VERSION_QUERY["id"], OS_VERSION_QUERY["cmd"])
    util.updateItemProgress(context, constants.PROG10)
    cliRet += versionResult + "\n"
    #===========================================================================
    # 先检查Windows操作系统版本,根据版本执行后面操作
    #===========================================================================
    if not status:
        util.log.info(context, "[Windows] query Windows OS version failed.")
        evalResult = EvalResultEnum.FAILED
        errMsgKey = WINDOWS_2008_BULE_SCREEN_CMD_FAILED
        itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, errMsgKey, [OS_VERSION_QUERY["cmd"]])
        util.updateItemProgress(context, constants.PROG90)
        return itemEvalResult
    if checkOsVersion(WINDOWS_2008_R2, versionResult):
        util.log.info(context, "[Windows] start to check with Windows Server 2008 R2.")
        return do2008R2Check(context, cliRet)
    elif checkOsVersion(WINDOWS_2008_AND_SP2, versionResult):
        util.log.info(context, "[Windows] start to check with Windows Server 2008/2008 SP2.")
        return do2008AndSP2Check(context, cliRet)
    else:
        util.log.info(context, "[Windows] not risky Windows Version, evaluation passed.")
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, "")
        util.updateItemProgress(context, constants.PROG90)
        return itemEvalResult

def do2008R2Check(context, cliRet):
    """
    @summary: 检查操作系统是否打补丁
    """
    patchStatus, patchResult = getStatusAndCmdResult(context, R2_CHECK_PATCH["id"], R2_CHECK_PATCH["cmd"])
    util.updateItemProgress(context, constants.PROG50)
    cliRet += patchResult + "\n"
    if not patchStatus:
        util.log.info(context, "[Windows] query Windows patch failed.")
        evalResult = EvalResultEnum.FAILED
        errMsgKey = WINDOWS_2008_BULE_SCREEN_CMD_FAILED
        itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, errMsgKey, [R2_CHECK_PATCH["cmd"]])
        util.updateItemProgress(context, constants.PROG90)
        return itemEvalResult
    allResultList = patchResult.lower().splitlines()
    for singleLine in allResultList:
        singleWords = re.split("\s+", singleLine)
        if constants.TWO < len(singleWords):
            if "kb978500" == singleWords[constants.TWO].strip():
                util.log.info(context, "[Windows] the hotfix patch has been installed, evaluation passed.")
                evalResult = EvalResultEnum.PASSED
                itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, "")
                return itemEvalResult
    util.log.info(context, "[Windows] evaluation failed.")
    evalResult = EvalResultEnum.FAILED
    errMsgKey = WINDOWS_2008_BULE_SCREEN_NO_PATCH_FAILED
    itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, errMsgKey, [context["DEV_IP"], "Fix299429"])
    util.updateItemProgress(context, constants.PROG90)
    return itemEvalResult

def do2008AndSP2Check(context, cliRet):
    """
    @summary: 检查操作系统是否启用自带多路径、操作系统是否打补丁
    """
    patchStatus, patchResult = getStatusAndCmdResult(context, WS2008_CHECK_PATCH["id"], WS2008_CHECK_PATCH["cmd"])
    util.updateItemProgress(context, constants.PROG35)
    cliRet += patchResult + "\n"
    if not patchStatus and "windows" not in patchResult.lower():
        util.log.info(context, "[Windows] query Windows patch failed.")
        evalResult = EvalResultEnum.FAILED
        errMsgKey = WINDOWS_2008_BULE_SCREEN_CMD_FAILED
        itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, errMsgKey, [WS2008_CHECK_PATCH["cmd"]])
        util.updateItemProgress(context, constants.PROG90)
        return itemEvalResult
    allResultList = patchResult.lower().splitlines()
    for singleLine in allResultList:
        singleWords = re.split("\s+", singleLine.strip())
        if constants.ONE < len(singleWords):
            if ":" in singleWords[0] and "kb2277440" == singleWords[constants.ONE].strip():
                util.log.info(context, "[Windows] the hotfix patch has been installed, evaluation passed.")
                evalResult = EvalResultEnum.PASSED
                itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, "")
                util.updateItemProgress(context, constants.PROG90)
                return itemEvalResult
    util.log.info(context, "[Windows] the hotfix patch has not been installed, continue, evaluation failed.")
    evalResult = EvalResultEnum.FAILED
    errMsgKey = WINDOWS_2008_BULE_SCREEN_NO_PATCH_FAILED
    itemEvalResult = util.genEvalItemObj(BUGLIST_ITEM_KEY, evalResult, cliRet, errMsgKey, [context["DEV_IP"], "Fix333422"])
    util.updateItemProgress(context, constants.PROG90)
    return itemEvalResult

def checkOsVersion(riskVerList, versionResult):
    """
    @summary: 检查回文中的操作系统版本是否预期操作系统
    @param riskVerList: 预期操作系统list
    @param versionResult: 查询操作系统版本回文
    @return: 是否预期版本：是/否
    """
    for singleRiskVer in riskVerList:
        if singleRiskVer in versionResult:
            return True
    return False

def getStatusAndCmdResult(context, cmdInfoID, command):
    '''
    @summary: 此方法将把回文自动放入context中，命令执行结果resultMsg也自动放入context中
    @param context: 上下文数据 
    @param cmdInfoID: 命令回文title 
    @param command: 命令
    @return: status 命令执行结果：成功/失败
    @return: cmdResultTemp 命令回文
    '''
    sshCon = context.get("SSH")
    lang = context.get("lang")
    display = context.get("ret_map")
    resultMsg = display.get("err_msg")
    if not resultMsg:
        resultMsg = ""

    cmdResultTemp = sshCon.execCmdWithTimout(command, constants.HOST_CMD_TIMEOUT)

    status = True
    if not cmdResultTemp or\
        'TOOLKIT_SEND_CMD_TIME_OUT' in  cmdResultTemp or\
            'TOOLKIT_EXE_CMD_FAILED' in cmdResultTemp:
        status = False

    if "en" == lang:
        if status:
            resultMsg += command + ":\texecute success\r\n"
        else:
            resultMsg += command + ":\texecute failed\r\n"
    else:
        if status:
            resultMsg += command + u":\t执行成功\r\n"
        else:
            resultMsg += command + u":\t执行失败\r\n"

    #===========================================================================
    # 保存单个命令回文和命令执行结果
    #===========================================================================
    display[cmdInfoID] = cmdResultTemp
    display["err_msg"] = resultMsg

    return status, cmdResultTemp
