# -*- coding: UTF-8 -*-
import sys
import os
import re
import traceback
path = os.path.dirname(os.path.abspath(__file__))
sys.path.append(path)
path = os.path.join(path, os.path.pardir)
sys.path.append(path)

from common import contentParse
from common import util
from common import constants
from com.huawei.ism.tool.infograb.context import EvalResultEnum
from com.huawei.ism.tool.infograb.context import ItemEvalResult

cmdInfoIdList = [
                 "cmd_info_windows_hba_infomation",
                 "cmd_info_multipath_path",
                 "cmd_info_multipath_version",
                 "cmd_info_multipath_status",
                 ]
commandList = [
               "wmic scsicontroller",
               "upadm show path",
               "upadm show version",
               "upadm check status",
               ]

ultraPathVersion = "21.03.006"
notFoundPattern = "not found|nable to detect ultrapath device node"

ITEMKEY = "WindowsVirtualHyperVCluster"
COM_FAILED = "eval.host.multipath.buglist.failed"
EVAL_FAILED = "windows.virtual.hyperv.cluster.failed"

def qryUltrapathVersion(context):
    '''
    @summary: Query the HUAWEI ultrapath version.
    @param context: Python execution context.
    @return (isQrySucc, ultrapathVersion, cliRet)
    '''
    try:
        cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[2], commandList[2])
        verPattern = 'UltraPath for Linux|Software Version'
        for line in cliRet.splitlines():
            if re.search(verPattern, line, re.I):
                return True, line.split(':')[-1].strip(), cliRet
        return False, '', cliRet
    except:
        util.log.error(context, 'Query ultrapath version exception:' + traceback.format_exc())
        return False, '', cliRet

def qryWindowsHBAInfo(context):
    '''
    @summary: Query the HBA infomation.
    @param context: Python execution context.
    @return (isQrySucc, isHasHyperV, cliRet)
    '''
    try:
        cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[0], commandList[0])
        verPattern = 'Microsoft Hyper-V Fibre Channel HBA'
        for line in cliRet.splitlines():
            if re.search(verPattern, line, re.I):
                return True, True, cliRet
        return True, False , cliRet
    except:
        util.log.error(context, 'Query HBA infomation exception:' + traceback.format_exc())
        return False, False, cliRet

def qryUltraPathStatus(context):
    '''
    @summary: Query the Ultra path status.
    @param context: Python execution context.
    @return (isQrySucc, isHasPathWWN, cliRet)
    '''
    try:
        cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[3], commandList[3])
        verPattern = 'Incorrect path WWN info'
        for line in cliRet.splitlines():
            if re.search(verPattern, line, re.I):
                return True, True, cliRet
        return True, False , cliRet
    except:
        util.log.error(context, 'Query Ultra path status:' + traceback.format_exc())
        return False, False, cliRet

def qryUltraPathType(context):
    '''
    @summary: Query the UltraPath type.
    @param context: Python execution context.
    @return (isQrySucc, portTypeList, cliRet)
    '''
    isGetLastCol = False
    hasPortType = False
    portTypeList = []
    try:
        cliRet = contentParse.getSingleCommandRetPureRetWithoutResCheck(context, cmdInfoIdList[1], commandList[1])
        for line in cliRet.splitlines():
            if "port type" in line.lower():
                if line.strip().lower().endswith("port type"):
                    isGetLastCol = True
                hasPortType = True
                continue

            if not hasPortType:
                continue

            lineStr = line.lower().strip().split()

            if len(lineStr) < constants.EGIHT:
                continue
            elif isGetLastCol:
                portTypeList.append(lineStr[-1])
            else:
                portTypeList.append(lineStr[constants.SEVEN])

        util.log.info(context, "the port type is :" + unicode(portTypeList))
        return True, portTypeList, cliRet
    except:
        util.log.error(context, 'Query port type infomation exception:' + traceback.format_exc())
        return False, [], cliRet

def execute(context):
    '''
    @summary 评估，并返回评估结果
    @param context : 上下文
    @param CLI : SSH
    @param LANGUAGE : 语言类型
    '''
    retDict = context.get("ret_map")
    evalResult = EvalResultEnum.FAILED
    errMsgKey = COM_FAILED

    isSucc, isHasHyperV, cliRet = qryWindowsHBAInfo(context)
    if not isSucc:
        util.log.error(context, "get the kernel version failed :" + unicode(cliRet))
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[0]])
        retDict["evalResult"] = itemEvalResult
        return retDict
    if isSucc and not isHasHyperV:
        util.log.error(context, "can not found HyperV infomation :" + unicode(cliRet))
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict

    isSucc, portTypeList, ultraPathCliRet = qryUltraPathType(context)
    cliRet += "\r\n" + ultraPathCliRet

    if "'upadm'" in ultraPathCliRet:
        util.log.info(context, "can not find the ultrapath path :" + unicode(ultraPathCliRet))
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict

    if not portTypeList:
        util.log.error(context, "get the ultrapath path failed :" + unicode(ultraPathCliRet))
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, COM_FAILED, [commandList[1]])
        retDict["evalResult"] = itemEvalResult
        return retDict

    hasFCType = False
    for portTypeStr in portTypeList:
        if portTypeStr == "fc" or portTypeStr == "fcoe":
            hasFCType = True
            break

    if not isSucc:
        util.log.error(context, "get fc or fcoe port type failed :" + unicode(ultraPathCliRet))
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[1]])
        retDict["evalResult"] = itemEvalResult
        return retDict

    if isSucc and not hasFCType:
        util.log.error(context, "can not found fc or fcoe port type:" + unicode(ultraPathCliRet))
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict

    isSucc, version, versionRet = qryUltrapathVersion(context)
    cliRet += "\r\n" + versionRet
    if not isSucc:
        if re.search(notFoundPattern, versionRet, re.I):
            util.log.error(context, "the ultrapath version is not install, the return is :" + unicode(versionRet))
            errMsgKey = EVAL_FAILED
            evalResult = EvalResultEnum.FAILED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
            retDict["evalResult"] = itemEvalResult
            return retDict
        else:
            util.log.error(context, "get the ultrapath version failed :" + unicode(versionRet))
            evalResult = EvalResultEnum.FAILED
            itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, COM_FAILED, [commandList[2]])
            retDict["evalResult"] = itemEvalResult
            return retDict

    curUltrapathVerTup = util.getUltrapathIntVer(context, version)
    startUltrapathVerTup = util.getUltrapathIntVer(context, ultraPathVersion)
    if curUltrapathVerTup == (0, 0, 0):
        util.log.error(context, "get the int ultrapath version failed :" + unicode(versionRet))
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, COM_FAILED, [commandList[2]])
        retDict["evalResult"] = itemEvalResult
        return retDict

    if startUltrapathVerTup > curUltrapathVerTup:
        util.log.error(context, "This vesion has problem,the vesion is:" + unicode(version))
        errMsgKey = EVAL_FAILED
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict

    isSucc, isHasUlbraPathStatus, UlbraPathStatusCliRet = qryUltraPathStatus(context)
    cliRet += "\r\n" + UlbraPathStatusCliRet
    if not isSucc:
        util.log.error(context, "get ulbraPath status failed :" + unicode(UlbraPathStatusCliRet))
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey, [commandList[3]])
        retDict["evalResult"] = itemEvalResult
        return retDict
    if isSucc and isHasUlbraPathStatus:
        util.log.error(context, "This vesion has problem,the UlbraPathStatus is:" + unicode(UlbraPathStatusCliRet))
        errMsgKey = EVAL_FAILED
        evalResult = EvalResultEnum.FAILED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict
    else:
        util.log.error(context, "can not found UlbraPathStatus infomation :" + unicode(UlbraPathStatusCliRet))
        errMsgKey = ""
        evalResult = EvalResultEnum.PASSED
        itemEvalResult = util.genEvalItemObj(ITEMKEY, evalResult, cliRet, errMsgKey)
        retDict["evalResult"] = itemEvalResult
        return retDict
