#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# 获取EMC存储设备基本信息
from storages.EMC.emc_storage_util import cmd_execute
from storages.EMC.emc_storage_util import vplex_rest_post_execute
from storages.EMC.emc_storage_util import read_smart_idc_report
from storages.EMC.emc_storage_util import EMC_VMAX
from storages.EMC.emc_storage_util import EMC_VPLEX
from storages.EMC.emc_storage_util import EMC_UNITY
from storages.EMC.unity.emc_unity_info_getter import get_unity_system_info

cmd_info_id = [
    "cmd_info_storage_group_serial"
]
cmd_info_desc = [
    "getagent -serial"
]

vmax_info_id = [
    "file_info_storage_group_serial"
]
vmax_info_desc = [
    "symmetrix_cfg.txt"
]

vplex_info_id = [
    "cmd_info_cluster_summary", "cmd_info_device_version"
]
vplex_info_desc = [
    "cluster+summary", "version"
]


def execute(context):
    """
    执行EMC存储信息采集
    :param context: 上下文
    :return: 执行结果
    """
    dev_model = context.get("dev_model")
    if dev_model == EMC_VMAX:
        return read_smart_idc_report(context, vmax_info_id, vmax_info_desc)
    elif dev_model == EMC_VPLEX:
        return vplex_rest_post_execute(context, vplex_info_id, vplex_info_desc)
    elif dev_model == EMC_UNITY:
        return get_unity_system_info(context)
    else:
        return cmd_execute(context, cmd_info_id, cmd_info_desc)
