#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
# 获取EMC存储设备主机信息
from storages.EMC.emc_storage_util import cmd_execute
from storages.EMC.emc_storage_util import batch_get_vplex_info
from storages.EMC.emc_storage_util import read_smart_idc_report
from storages.EMC.emc_storage_util import EMC_VMAX
from storages.EMC.emc_storage_util import EMC_VPLEX
from storages.EMC.emc_storage_util import EMC_UNITY
from storages.EMC.unity.emc_unity_info_getter import get_unity_host_info

cmd_info_id = [
    "cmd_info_storage_group_all", "cmd_info_storage_group_hba"
]
cmd_info_desc = [
    "getall", "getall -hba"
]

vmax_info_id = [
    "file_info_storage_group_all", "file_info_storage_group_hba"
]
vmax_info_desc = [
    "hostgroup_cfg.txt", "host_cfg.txt"
]

vplex_info_id = "cmd_info_initiators_"
vplex_info_desc = "/clusters/cluster-*/exports/initiator-ports/"


def execute(context):
    """
    执行EMC存储信息采集
    :param context: 上下文
    :return: 执行结果
    """
    dev_model = context.get("dev_model")
    if dev_model == EMC_VMAX:
        return read_smart_idc_report(context, vmax_info_id, vmax_info_desc)
    elif dev_model == EMC_VPLEX:
        return batch_get_vplex_info(context, vplex_info_id, vplex_info_desc)
    elif dev_model == EMC_UNITY:
        return get_unity_host_info(context)
    else:
        return cmd_execute(context, cmd_info_id, cmd_info_desc)
