#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# 获取EMC存储设备映射信息
import re
from storages.EMC.emc_storage_util import cmd_execute
from storages.EMC.emc_storage_util import batch_get_vplex_info
from storages.EMC.emc_storage_util import read_smart_idc_report
from storages.EMC.emc_storage_util import EMC_VNX
from storages.EMC.emc_storage_util import EMC_VMAX
from storages.EMC.emc_storage_util import EMC_VPLEX
from storages.EMC.emc_storage_util import EMC_UNITY
from storages.EMC.unity.emc_unity_info_getter import get_unity_lun_info

CLI = None

cmd_info_id = [
    "cmd_info_storage_group_sg"
]
cmd_info_storage_groupname = "getall -sg"
cmd_info_desc = [cmd_info_storage_groupname]

vmax_info_id = [
    "file_info_storage_group_sg", "file_info_storage_group_cfg", "file_info_storage_group_volume"
]
vmax_info_desc = [
    "maskingview_cfg.txt", "storagegroup_cfg.txt", "volume_cfg.txt"
]

vplex_info_id = "cmd_info_storage_views_"
vplex_info_desc = "/clusters/cluster-*/exports/storage-views/"


def execute(context):
    """
    Function name      : execute
    Function describe  : 外部接入
    Input              : context
    Return             : cmd display
    """
    global cmd_info_id
    global cmd_info_desc
    
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")

    dev_type = context.get("dev_type")
    dev_model = context.get("dev_model")
    if dev_model == EMC_VMAX:
        return read_smart_idc_report(context, vmax_info_id, vmax_info_desc)
    elif dev_model == EMC_VPLEX:
        return batch_get_vplex_info(context, vplex_info_id, vplex_info_desc)
    elif dev_model == EMC_UNITY:
        return get_unity_lun_info(context)
    else:
        # 获取每个storage所对应的列表
        storage_value_lst = get_cmdlst_storagegroup(cmd_info_storage_groupname)
        # 获取每个storage对象所组成的列表
        storage_bean_lst = get_storagebean_lst(storage_value_lst)
        # 根据storage_bean_lst求cmd_desc
        set_cmd_desc(storage_bean_lst, dev_type)
        return cmd_execute(context, cmd_info_id, cmd_info_desc)


def set_cmd_desc(storage_beanlst, dev_type):
    cmd_desc_base = "getlun"+" %s "+"-uid"+" -capacity -name -state -ismetalun"
    if EMC_VNX in dev_type.upper():
        cmd_desc_base = cmd_desc_base + " -isthinlun"
    for bean in storage_beanlst:
        if len(bean.get_alunum_lst())>0:
            for num in bean.get_alunum_lst():
                cmd_desc = cmd_desc_base % num
                cmd_info_desc.append(cmd_desc)
                cmd_id = "cmd_info_storage_"
                cmd_id = cmd_id + bean.get_groupname()+"_alu"+num
                cmd_info_id.append(cmd_id)
                

#获取每个storage对象所组成的列表
def get_storagebean_lst(storage_lst):
    storage_bean_lst = []
    for lst in storage_lst:
        storage_bean = get_storagebean_bylst(lst)
        storage_bean_lst.append(storage_bean)
    return storage_bean_lst


#根据一个storage group的回文生成一个 storage对象
def get_storagebean_bylst(storage_lst):
    storage_bean = StorageGroup()
    if (None == storage_lst) or (0 == len(storage_lst)):
        return storage_bean
    for line in storage_lst:
        if ('storage' in line.lower()) and ('group' in line.lower()) and ('name' in line.lower()):
            name = line.split(':')[-1].strip()
            storage_bean.set_groupname(name)
            break
    #求alu num lst
    start = 0
    end = 0
    has_alu = False
    for i,line in enumerate(storage_lst):
        if ('alu' in line.lower()) and ('number' in line.lower()):
            start = i + 2
            has_alu = True
        elif 'shareable' in line.lower():
            end = i 
            break
    if has_alu:
        alu_lst = storage_lst[start:end]
        alu_num_lst = []
        for alu in alu_lst:
            alu = alu.strip()
            line_lst = re.split('\\s+',alu)
            num = line_lst[-1].strip()
            alu_num_lst.append(num)
        storage_bean.set_alunum_lst(alu_num_lst)
    return storage_bean
 

#获取每个storage所对应的列表
def get_cmdlst_storagegroup(cmd_desc):
    cmd_value_temp = CLI.execCmdHasLog(cmd_desc)
    cmd_value_lst = cmd_value_temp.splitlines()
    #过滤掉无用的数据
    check_lst = []
    for line in cmd_value_lst:
        if '' != line.strip():
            check_lst.append(line)
    cmd_value_lst = check_lst
    #每个storage group对应一个lst
    storagelst_lst = []
    storage_index_lst = []
    for i,line in enumerate(cmd_value_lst):
        if ('storage' in line.lower()) and ('group' in line.lower()) and ('name' in line.lower()):
            storage_index_lst.append(i)
    
    len_indexlst = len(storage_index_lst)
    for j in range(len_indexlst):
        lst = []
        start = storage_index_lst[j]
        try:
            end = storage_index_lst[j+1]
        except:
            end = len(cmd_value_lst)
            
        lst = cmd_value_lst[start:end]
        storagelst_lst.append(lst)
    return storagelst_lst 


class StorageGroup:

    __group_name = 'NA'
    __alu_num_lst = []

    def get_groupname(self):
        return self.__group_name

    def get_alunum_lst(self):
        return self.__alu_num_lst

    def set_groupname(self,name):
        self.__group_name = name

    def set_alunum_lst(self,lst):
        self.__alu_num_lst = lst

