#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import DES, CMD, change_list_to_tuple
from storages.EMC.nas.emc_isilon import EmcIsilon

CMD_LIST = [
    {DES: "cmd_display_local_list", CMD: "isi auth local list --verbose"},
    {DES: "cmd_display_ldap_list", CMD: "isi auth ldap list --verbose"},
    {DES: "cmd_display_ads_list", CMD: "isi auth ads list --verbose"},
    {DES: "cmd_display_nis_list", CMD: "isi auth nis list --verbose"},
    {DES: "cmd_display_krb_domain_list", CMD: "isi auth krb5 domain list --verbose"},
    {DES: "cmd_display_krb_realm_list", CMD: "isi auth krb5 realm list --verbose"},
    {DES: "cmd_display_settings_acls_view", CMD: "isi auth settings acls view"},
    {DES: "cmd_display_network_groupnets", CMD: "isi network groupnets list --verbose"},
]

ZONE_NAME_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_users_", CMD: "isi auth users list --zone=%s --verbose"},
    {DES: "cmd_display_groups_", CMD: "isi auth groups list --zone=%s --verbose"},
    {DES: "cmd_display_mapping_", CMD: "isi auth mapping list --zone=%s"},
]


class AuthInfoEmcIsilon(EmcIsilon):
    def __init__(self, context):
        EmcIsilon.__init__(self, context)

    def execute(self):
        self.cmd_list = CMD_LIST
        zone_name_list = self.get_zone_name_list()
        self.generate_relative_cmd_list(change_list_to_tuple(zone_name_list), ZONE_NAME_RELATIVE_CMD_DICTS)
        self.execute_pure_cmd_list(True)
