#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import DES, CMD, change_list_to_tuple
from storages.EMC.nas.emc_isilon import EmcIsilon

CMD_LIST = [
    {DES: "cmd_display_soft_version", CMD: "isi version"},
    {DES: "cmd_display_cluster_status", CMD: "isi status |cat"},
    {DES: "cmd_display_license", CMD: "isi license list --verbose"},
    {DES: "cmd_display_storagepool_list", CMD: "isi storagepool list --verbose"},
    {DES: "cmd_display_storagepool_settings", CMD: "isi storagepool settings view"},
    {DES: "cmd_display_zones_list_verbose", CMD: "isi zone zones list --verbose"},
    {DES: "cmd_display_quotas_list_verbose", CMD: "isi quota quotas list --verbose"},
    {DES: "cmd_display_network_interfaces", CMD: "isi network interfaces list"},
    {DES: "cmd_display_network_pools_verbose", CMD: "isi network pools list --verbose"},
    {DES: "cmd_display_nfs_settings_global_view", CMD: "isi nfs settings global view"},
    {DES: "cmd_display_smb_settings_global_view", CMD: "isi smb settings global view"},
    {DES: "cmd_display_compression_settings", CMD: "isi compression settings view"},
    {DES: "cmd_display_dedupe_settings", CMD: "isi dedupe settings view"},
    {DES: "cmd_display_dedupe_stats", CMD: "isi dedupe stats"},
    {DES: "cmd_display_encoding_settings", CMD: "isi cluster encoding view"},
    {DES: "cmd_display_antivirus_cava_settings", CMD: "isi antivirus cava settings view"},
    {DES: "cmd_display_antivirus_cava_seevers", CMD: "isi antivirus cava servers list"},
    {DES: "cmd_display_antivirus_cava_policies", CMD: "isi antivirus cava policies list"},
    {DES: "cmd_display_antivirus_icap_settings", CMD: "isi antivirus icap settings view"},
    {DES: "cmd_display_antivirus_icap_servers", CMD: "isi antivirus icap servers list"},
    {DES: "cmd_display_antivirus_icap_policies", CMD: "isi antivirus icap policies list"}
]

ZONE_NAME_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_smb_shares_", CMD: "isi smb shares list --zone=%s --verbose"},
    {DES: "cmd_display_nfs_exports_", CMD: "isi nfs exports list --zone=%s --verbose"},
    {DES: "cmd_display_nfs_settings_export_view_", CMD: "isi nfs settings export view --zone=%s"},
    {DES: "cmd_display_nfs_settings_zone_view_", CMD: "isi nfs settings zone view --zone=%s"},
    {DES: "cmd_display_nfs_aliases_list_", CMD: "isi nfs aliases list --zone=%s"},
    {DES: "cmd_display_smb_settings_shares_", CMD: "isi smb settings shares view --zone=%s"},
    {DES: "cmd_display_smb_settings_zone_view_", CMD: "isi smb settings zone view --zone=%s"},
]

ZONE_SHARE_NAME_RELATIVE_CMD_DICTS = [
    {DES: "cmd_display_smb_shares_", CMD: "isi smb shares view --zone=%s '%s'"},
]

ISI_CONFIG_CMD_DICTS = [
    {DES: "cmd_display_config", CMD: "isi config"},
]


class BasicInfoEmcIsilon(EmcIsilon):
    def __init__(self, context):
        EmcIsilon.__init__(self, context)

    def execute(self):
        self.cmd_list = ISI_CONFIG_CMD_DICTS
        # 第一阶段进度到10%
        self.execute_pure_cmd_list(ignore_bad_start_line=True, cur_step=5.0, progress_width=5.0)
        self.exec_cmd("quit", True)

        self.cmd_list = CMD_LIST
        # 第二阶段进度到30%
        self.execute_pure_cmd_list(ignore_bad_start_line=True, cur_step=10.0, progress_width=20.0)

        zone_names_content = self.display.get("cmd_display_zones_list_verbose")
        zone_name_list = self.get_zone_name_list(cmd_content=zone_names_content)

        self.cmd_list = []
        self.generate_relative_cmd_list(change_list_to_tuple(zone_name_list), ZONE_NAME_RELATIVE_CMD_DICTS)
        # 第三阶段进度到60%
        self.execute_pure_cmd_list(ignore_bad_start_line=True, cur_step=30.0, progress_width=30.0)

        self.cmd_list = []
        self.generate_relative_cmd_list(self.get_zone_share_name_list(zone_name_list),
                                        ZONE_SHARE_NAME_RELATIVE_CMD_DICTS)
        # 第四阶段进度到90%
        self.execute_pure_cmd_list(ignore_bad_start_line=True, cur_step=60.0, progress_width=30.0)

    def get_zone_share_name_list(self, zone_name_list):
        """
        获取zone_name、share_name参数
        :param zone_name_list: zone_name列表
        :return: 数据
        """
        zone_and_share_tuples = []
        for zone_name in zone_name_list:
            share_content = self.display.get("cmd_display_smb_shares_" + zone_name)
            for line in share_content.splitlines():
                line_info = line.strip()
                if line_info.startswith("Share Name:"):
                    share_name = line_info[line_info.index(":") + 1:].strip().replace("'", "'\\''")
                    zone_and_share_tuples.append((zone_name, share_name))
        return zone_and_share_tuples
