#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
from common.cmd_execute import BaseCmdExecute
from storages.EMC.nas.emc_nas_parse_utils import parse_content_first_column


class EmcIsilon(BaseCmdExecute):
    def __init__(self, context):
        BaseCmdExecute.__init__(self, context)

    def get_zone_name_list(self, cmd_content=''):
        """
        获取zone_name参数
        :param cmd_content 命令结果
        :return: 数据
        """
        if not cmd_content:
            cmd = "isi zone zones list --verbose"
            content = self.exec_cmd(cmd, True)
        else:
            content = cmd_content
        zones = []
        for line in content.splitlines():
            line_info = line.strip()
            if line_info.startswith("Name:"):
                zone = line.split(":")[1].strip()
                zones.append(zone)
        return zones

    def get_policy_name_list(self):
        """
        获取policy_name参数
        :return: 数据
        """
        cmd = "isi antivirus policies list"
        return parse_content_first_column(self.exec_cmd(cmd, True))
