#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
SPLIT = "--------"


def parse_content_first_column(content):
    """
    获取回文第一列数据
    :param content: 回文
    :return: 数据
    """
    result = []
    start_flag = False
    for line in content.splitlines():
        if not start_flag and SPLIT in line:
            start_flag = True
            continue
        if start_flag and SPLIT in line:
            return result
        if not start_flag:
            continue
        items = line.split()
        if len(items) > 1:
            result.append(items[0].strip())
    return result
