# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.EMC.nas.parse.zones_parser import get_zone_name_list
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result


def execute(context):
    """
    获取 isi 下的 cifs server 信息
    :param context: 上下文数据
    """
    data_header = [
        "Zone Name", "Access Based Share Enum", "Dot Snap Accessible Child", "Dot Snap Accessible Root",
        "Dot Snap Visible Child", "Dot Snap Visible Root", "Enable Security Signatures",
        "Guest User", "Ignore Eas", "OneFS CPU Multiplier", "OneFS Num Workers",
        "Reject Unencrypted Access", "Require Security Signatures", "Server Side Copy",
        "Server String", "Support Multichannel", "Support NetBIOS",
        "Support SMB2", "Support Smb3 Encryption"
    ]
    parse_data(context, [data_header], get_cifs_server_content)


def get_cifs_server_content(context):
    """
    根据 zone 来获取每个的 cifs server 属性
    再把全局的 cifs server 配置 加在每个 zone 后面
    第一行是全局的，名称用 -- 标识
    全局的属性比非全局的多，多余的部分所有都显示全局的
    """
    zone_key_name = [
        "Access Based Share Enum", "Dot Snap Accessible Child", "Dot Snap Accessible Root",
        "Dot Snap Visible Child", "Dot Snap Visible Root", "Enable Security Signatures",
        "Guest User", "Ignore Eas", "OneFS CPU Multiplier", "OneFS Num Workers",
        "Reject Unencrypted Access", "Require Security Signatures", "Server Side Copy",
        "Server String", "Support Multichannel", "Support NetBIOS",
        "Support SMB2", "Support Smb3 Encryption"
    ]


    global_cifs_data = get_key_value_type_result(context, "cmd_display_smb_settings_global_view", ":", True)

    global_row = ["--"]
    for key_name in zone_key_name:
        global_row.append(global_cifs_data.get(key_name))
    cifs_server_content = [global_row]

    zone_name_list = get_zone_name_list(context)
    for zone_name in zone_name_list:
        row_data = [zone_name]
        cifs_server_cmd = "cmd_display_smb_settings_zone_view_" + zone_name
        zone_cifs_data = get_key_value_type_result(context, cifs_server_cmd, ":", True)
        for key in zone_key_name:
            row_data.append(zone_cifs_data.get(key, global_cifs_data.get(key, "-")))
        cifs_server_content.append(row_data)
    return cifs_server_content
