# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.EMC.nas.parse.zones_parser import get_zone_name_list
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_with_more_info_result, \
    parse_key_value_type_result, parse_table_type_cmd_result
from storages.storage_common import get_command_result_lines


def execute(context):
    """
    获取isi 的 cifs share permission 信息
    :param context: 上下文数据
    """
    data_header = [
        "Zone", "Share Name", "Path", "Description", "Client-side Caching Policy",
        "Automatically expand user names or domain names",
        "Automatically create home directories for users", "Browsable",
        "Access Based Enumeration", "Access Based Enumeration Root Only", "Allow Delete Readonly",
        "Allow Execute Always", "CA Timeout", "Sparse File",
        "Continuously Available", "Strict CA Lockout", "CA Write Integrity",
        "Change Notify", "Create Permissions", "Directory Create Mask",
        "Directory Create Mode", "File Create Mask", "File Create Mode",
        "File Filtering Enabled", "File Filter Extensions", "File Filter Type",
        "Hide Dot Files", "Host ACL", "Impersonate Guest",
        "Impersonate Guest", "Impersonate User", "Mangle Byte Start",
        "Mangle Map", "NTFS ACL Support", "Oplocks",
        "Smb3 Encryption Enabled", "Strict Flush", "Strict Locking",
        "Account", "Account Type", "Run as Root", "Permission Type", "Permission"
    ]
    parse_data(context, [data_header], get_cifs_share_content)


def get_zone_cifs_share_content(context, zone_name, res_content):
    get_share_name_dispaly = "cmd_display_smb_shares"
    underline_str = "_"
    get_share_name_cmd = get_share_name_dispaly + underline_str + zone_name
    name_data = get_key_value_type_with_more_info_result(context, get_share_name_cmd,
                                                         ":", True)
    index = 0
    while "Share Name" + str(index) in name_data:
        display_cmd = get_share_name_cmd + underline_str + name_data.get("Share Name" + str(index))
        get_one_cifs_share_content(zone_name, context, display_cmd, res_content)
        index += 1


def get_one_cifs_share_content(zone_name, context, display_cmd, res_content):
    zone_name_key_list = [
        "Share Name", "Path", "Description", "Client-side Caching Policy",
        "Automatically expand user names or domain names",
        "Automatically create home directories for users", "Browsable"
    ]
    share_info_key_list = [
        "Access Based Enumeration", "Access Based Enumeration Root Only", "Allow Delete Readonly",
        "Allow Execute Always", "CA Timeout", "Sparse File", "Continuously Available",
        "Strict CA Lockout", "CA Write Integrity", "Change Notify", "Create Permissions",
        "Directory Create Mask", "Directory Create Mode", "File Create Mask", "File Create Mode",
        "File Filtering Enabled", "File Filter Extensions", "File Filter Type", "Hide Dot Files",
        "Host ACL", "Impersonate Guest", "Impersonate Guest", "Impersonate User", "Mangle Byte Start",
        "Mangle Map", "NTFS ACL Support", "Oplocks", "Smb3 Encryption Enabled", "Strict Flush", "Strict Locking"
    ]
    permission_key_list = ["Account", "Account Type", "Run as Root", "Permission Type", "Permission"]

    key_val_line = 0
    table_line = 0
    result_lines = get_command_result_lines(context, display_cmd, with_blank=True)
    for i, line in enumerate(result_lines):
        if line.startswith("Permissions:"):
            key_val_line = i
        if line.startswith("Total:"):
            table_line = i
            break
    if not key_val_line or not table_line:
        return
    total_info_data = parse_key_value_type_result(result_lines[0:key_val_line], ":")
    permission_info_data = parse_table_type_cmd_result(result_lines[key_val_line:table_line])
    share_info_data = parse_key_value_type_result(result_lines[table_line:], ":")
    
    one_cifs_share_content = [zone_name]
    for key in zone_name_key_list:
        one_cifs_share_content.append(total_info_data.get(key, "-"))

    for key in share_info_key_list:
        one_cifs_share_content.append(share_info_data.get(key, "-"))

    for permission_info in permission_info_data:
        one_cifs_share_info_content = list(one_cifs_share_content)
        for key in permission_key_list:
            one_cifs_share_info_content.append(permission_info.get(key, "-"))
        res_content.append(one_cifs_share_info_content)


def get_cifs_share_content(context):
    """
    这个场景较为复杂，需要先获取zones再获取对应的share_name再通过share_name去查详细信息
    zones name 通过之前在 zones_parser.py 下的解析函数中获取
    详细信息为:
                                         Share Name: test share
                                               Path: /ifs
                                        Description:
                                        ......
    Permissions:
    ......(多余的表格信息)
    Total: xxxx

              Access Based Enumeration: Yes
    Access Based Enumeration Root Only: No
                 Allow Delete Readonly: No
                 ......
    我们通过 Permissions 和 Total 两个字段对获取的信息进行拆分
    0:Permissions（键值对）, Total:（键值对）
    """
    res_content = []
    zone_name_list = get_zone_name_list(context)

    for zone_name in zone_name_list:
        get_zone_cifs_share_content(context, zone_name, res_content)

    return res_content
