# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_result


def execute(context):
    """
    获取 isi 下的 dedupe 和 compression 信息
    :param context: 上下文数据
    """
    data_header = [
        "Compression Enabled", "Dedupe Schedule", "Dedupe Paths", "Dedupe Assess Paths",
        "Dedupe Cluster Physical Size", "Dedupe Cluster Used Size", "Dedupe Logical Size Deduplicated",
        "Dedupe Logical Saving", "Dedupe Estimated Size Deduplicated", "Dedupe Estimated Physical Saving"
    ]
    parse_data(context, [data_header], get_dedupe_compress_content)


def get_dedupe_compress_content(context):
    dedupe_settings_key_name = [
        "Dedupe Schedule", "Paths", "Assess Paths",
    ]
    dedupe_stats_key_name = [
        "Cluster Physical Size", "Cluster Used Size", "Logical Size Deduplicated",
        "Logical Saving", "Estimated Size Deduplicated", "Estimated Physical Saving"
    ]

    compression_lines = get_key_value_type_result(context, "cmd_display_compression_settings", ":", True)
    dedupe_settings_lines = get_key_value_type_result(context, "cmd_display_dedupe_settings", ":", True)
    dedupe_stats_lines = get_key_value_type_result(context, "cmd_display_dedupe_stats", ":", True)
    dedupe_compress_content = [compression_lines.get("Enabled")]

    for key_name in dedupe_settings_key_name:
        dedupe_compress_content.append(dedupe_settings_lines.get(key_name, "-"))

    for key_name in dedupe_stats_key_name:
        dedupe_compress_content.append(dedupe_stats_lines.get(key_name, "-"))

    return [dedupe_compress_content]
