# coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
from storages.HUAWEI.nas.util.parse_common import parse_data, get_key_value_type_with_more_info_result


def execute(context):
    """
    获取 isi 下的 ads 信息
    :param context: 上下文数据
    """
    data_header = [
        "Name", "Machine Account", "Authentication",
        "Groupnet", "Status", "Primary Domain", "Forest",
        "Site", "NetBIOS Domain", "Hostname", "Controller Time",
        "Node DC Affinity", "Node DC Affinity Timeout", "NSS Enumeration",
        "SFU Support", "Store SFU Mappings", "Ignore All Trusts",
        "Ignored Trusted Domains", "Include Trusted Domains", "Extra Expected SPNs",
        "Domain Offline Alerts", "LDAP Sign And Seal", "Lookup Users", "Lookup Normalize Users",
        "Allocate UIDs", "Lookup Normalize Groups", "Allocate GIDs", "Lookup Domains", "Lookup Groups",
        "Assume Default Domain", "Check Online Interval", "Machine Password Changes",
        "Machine Password Lifespan", "Create Home Directory", "Home Directory Template",
        "Unfindable Groups", "Unfindable Users", "Findable Groups",
        "Findable Users", "Restrict Findable", "Login Shell", "Creator Zone"
    ]

    parse_data(context, [data_header], get_domain_ads_content)


def get_domain_ads_content(context):
    ads_key_name = [
        "Name", "Machine Account", "Authentication",
        "Groupnet", "Status", "Primary Domain", "Forest",
        "Site", "NetBIOS Domain", "Hostname", "Controller Time",
        "Node DC Affinity", "Node DC Affinity Timeout", "NSS Enumeration",
        "SFU Support", "Store SFU Mappings", "Ignore All Trusts",
        "Ignored Trusted Domains", "Include Trusted Domains", "Extra Expected SPNs",
        "Domain Offline Alerts", "LDAP Sign And Seal", "Lookup Users", "Lookup Normalize Users",
        "Allocate UIDs", "Lookup Normalize Groups", "Allocate GIDs", "Lookup Domains", "Lookup Groups",
        "Assume Default Domain", "Check Online Interval", "Machine Password Changes",
        "Machine Password Lifespan", "Create Home Directory", "Home Directory Template",
        "Unfindable Groups", "Unfindable Users", "Findable Groups",
        "Findable Users", "Restrict Findable", "Login Shell", "Creator Zone"
    ]

    ads_data = get_key_value_type_with_more_info_result(context, "cmd_display_ads_list", ":", True)

    ads_content = []
    index = 0
    while ads_key_name[0] + str(index) in ads_data:
        ads_content.append([ads_data.get(key + str(index), "-").strip() for key in ads_key_name])
        index += 1

    return ads_content
